import React, { Component } from "react";
import { View, Image, ScrollView, Text, StyleSheet, TouchableOpacity, TextInput } from "react-native";
import { Container, TextLabel, AppButton, InfoCard } from "../../components";
import { icons, colors } from "../../assets";
import { compose } from "redux";
import { connect } from "react-redux";
import { generalAction } from "../../actions/GeneralActions";
import { WithFetching } from "../../HOC";
import styles from "./styles";
import DatePicker from "react-native-datepicker";
import moment from "moment";
import { Colors, Metrics } from "../../services";
import Utils from "../../Utils";
import { API_KEY_GOOGLE } from "../../constants";
import { pop } from "../../services/NavigationService";
import {
    API_MARK_AS_COMPLETE_CLINICIAN, POST_BREAK_CHECK,
    POST_LATLNG_API, POST_VERIFY_API, BASE_URL
} from "../../services/WebService";
import { DUMP } from "../../actions/ActionTypes";
import DateTimePicker from '@react-native-community/datetimepicker';
import { Overlay } from 'react-native-elements';
import Geolocation from '@react-native-community/geolocation';
import axios from "axios";
import { RadioButton } from 'react-native-paper';


let data = {};
let timeDiff = 0;
let timeDiffA = 0;
let val_loc = '';


class AddShiftTiming extends Component {
    constructor(props) {
        data = props.route.params.data;


        val_loc = props.route.params.location;

        const { shift_start_date, shift_end_date, shift_start_time, shift_end_time, location_address,
            category_name, contract_location_verified, total_amount } = data;
        super();

        timeDiff = Utils.calculateDiffTime(shift_end_time, shift_start_time);

        this.state = {
            shift_start_date: shift_start_date,
            shift_end_date: shift_end_date,
            shift_start_time: shift_start_time,
            shift_end_time: shift_end_time,
            startTimeErr: "",
            endTimeErr: "",
            showstarttime: false,
            showendtime: false,
            totalAmount: parseFloat(total_amount),
            totalAmount_break: parseFloat(total_amount),
            isError: false,
            loc_verify_show: contract_location_verified,
            Modal: false,
            shift_name: category_name,
            shift_time: shift_start_time + " to " + shift_end_time,
            current_loc: val_loc,
            show_location: val_loc,
            to_loc: location_address,
            sign_name: '',
            sign_title: '',
            location_status: '',
            lunchstarttime: false,
            lunchendtime: false,
            checked_taken: false,
            checked: false,
            radio_value: 'no',
            break_starttime: '',
            break_endtime: '',
            is_break: '',
            breakval_reason: '',
            breakavailable: data.is_break,
            lunch_time_val: '',
            lunch_reason_val: '',
            lunch_available_val: '',
            value_lunchtime: Utils.getLunchValue(),
            location_fetch: ''
        }
    }
    componentDidMount() {
        // const { shift_start_date, shift_end_date, shift_start_time, shift_end_time } = this.state;
        // timeDiff = Utils.calculateDiffTime(shift_end_time, shift_start_time);
        timeDiffA = timeDiff;

        //  this.totalBidNMileage(timeDiff);

        this.getOneTimeLocation();

    }


    getOneTimeLocation = () => {
        Geolocation.getCurrentPosition(
            (position) => {

                this.setState({ location_fetch: "" })

                const currentLongitude =
                    JSON.stringify(position.coords.longitude);

                const currentLatitude =
                    JSON.stringify(position.coords.latitude);

                this.props.route.params.location == "" ?
                    this.getAddress(currentLatitude, currentLongitude) :
                    this.checkLocation(currentLatitude, currentLongitude);

            },
            (error) => {
                // setLocationStatus();
                console.log(error)

                this.setState({ location_fetch: error.message })

            },
            {
                enableHighAccuracy: false,
                timeout: 30000,
                maximumAge: 1000
            },
        );
    };

    checkLocation = (lat, lng) => {

        let self = this;

        const { contract_id, contract_type } = data;

        let params = {
            contract_id: contract_id,
            latitude: lat,
            longitude: lng
        }
        axios.post(BASE_URL + POST_LATLNG_API, params, {
            headers: {
                token: "api.Pd*!(5675",
                api_version: '1.0',
                api_client: 'android'

            }
        })
            .then(function (response) {

                const checkval = response.data.message;

                if (checkval != 'failure') {

                    self.setState({ location_status: true })

                    self.setState({ show_location: self.state.to_loc })


                } else {

                    self.setState({ location_status: false })

                }


            })
            .catch(function (error) {
                console.log(error);
            })
    }

    labelText = (label, topMargin = {}) => {
        return (
            <TextLabel
                color={colors.ActiveTabTitle}
                style={[styles.textLabel, topMargin]}
            >
                {label}
            </TextLabel>
        );
    };

    setStartTime = time => {

        this.setState(
            {
                shift_start_time: time,
                startTimeErr: "",
                endTimeErr: ""
            },
            () => this.calculateDiffTimeB()
        );
    };

    setAndroidStartTime = (event, time) => {

        const starttime = moment(time).format("HH:mm:A");

        this.setState(
            {
                shift_start_time: starttime,
                startTimeErr: "",
                endTimeErr: "",
                showstarttime: false
            },
            () => this.calculateDiffTimeB()
        );


        timeDiff = Utils.calculateDiffTime(this.state.shift_end_time, starttime);

        if (timeDiff >= this.state.value_lunchtime) {

            this.setState({ breakavailable: "yes" });


        } else {

            this.setState({ breakavailable: "no" });

            this.setState({
                lunch_available_val: "",
                lunch_reason_val: "",
                lunch_time_val: ""
            });

        }

        this.setState({ break_starttime: "" });
        this.setState({ break_endtime: "" });


    };

    setAndroidEndTime = (event, time) => {

        const endtime = moment(time).format("HH:mm:A");

        this.setState(
            {
                shift_end_time: endtime,
                startTimeErr: "",
                endTimeErr: "",
                showendtime: false

            },
            () => this.calculateDiffTimeB()
        );



        timeDiff = Utils.calculateDiffTime(endtime, this.state.shift_start_time);



        if (timeDiff >= this.state.value_lunchtime) {

            this.setState({ breakavailable: "yes" });


        } else {

            this.setState({ breakavailable: "no" });
            this.setState({
                lunch_available_val: "",
                lunch_reason_val: "",
                lunch_time_val: ""
            });

        }

        this.setState({ break_starttime: "" });
        this.setState({ break_endtime: "" });


    };

    setLunchandroidStartTime = (event, time) => {


        const starttime = moment(time).format("HH:mm:A");

        this.setState(
            {
                break_starttime: starttime,
                startTimeErr: "",
                endTimeErr: "",
                lunchstarttime: false
            },
            () => this.calculateDiffTimeB()
        );

        //x>y

        if (starttime > this.state.shift_start_time) {


        }
        else {

            Utils.showError("Enter valid Lunch break Time");

            this.setState({ break_starttime: '' })
        }
    };

    setLunchandroidEndTime = (event, time) => {

        const endtime = moment(time).format("HH:mm:A");
        this.setState(
            {
                break_endtime: endtime,
                startTimeErr: "",
                endTimeErr: "",
                lunchendtime: false

            },
            () => this.calculateDiffTimeB()
        );

        //x>y

        if (endtime > this.state.break_starttime && this.state.shift_end_time >= endtime) {


            this.gettotalvalue(endtime);

        }
        else {

            Utils.showError("Enter valid Lunch break Time");

            this.setState({ break_endtime: '' })
        }

    };


    setEndTime = time => {
        this.setState(
            {
                shift_end_time: time,
                startTimeErr: "",
                endTimeErr: ""
            },
            () => this.calculateDiffTimeB()
        );
    };

    setLunchStartTime = time => {
        this.setState(
            {
                break_starttime: time,
                startTimeErr: "",
                endTimeErr: ""
            },
            () => this.calculateDiffTimeB()
        );

        if (this.state.shift_start_time > endtime) {

            Utils.showError("Enter valid Lunch break Time");

            this.setState({ break_starttime: '' })

        }
    };

    setLunchEndTime = time => {
        this.setState(
            {
                break_endtime: time,
                startTimeErr: "",
                endTimeErr: ""
            },
            () => this.calculateDiffTimeB()
        );

        if (time > this.state.break_starttime && this.state.shift_end_time >= time) {


            this.gettotalvalue(time);

        }
        else {

            Utils.showError("Enter valid Lunch break Time");

            this.setState({ break_endtime: '' })
        }
    };

    gettotalvalue = (endtime) => {

        let self = this;

        const c_id = this.props.route.params.data.contract_id;
        let params = {

            contract_id: c_id,
            break_start_time: self.state.break_starttime,
            break_end_time: endtime,
            is_break_available: self.state.radio_value,
            break_reason: self.state.breakval_reason,
            total_hours: timeDiff,


        }

        axios.post(BASE_URL + POST_BREAK_CHECK, params, {
            headers: {
                token: "api.Pd*!(5675",
                api_version: '1.0',
                api_client: 'android'

            }
        })
            .then(function (response) {


                if (response.data.code == 200) {


                    self.setState({
                        totalAmount_break: response.data.data[0].total_amount
                    });

                    var timeval = response.data.data[0].break_details.lunch_break_time;
                    var reasonval = response.data.data[0].break_details.lunch_break_reason;
                    var availableval = response.data.data[0].break_details.lunch_break;

                    self.setState({
                        lunch_available_val: availableval,
                        lunch_reason_val: reasonval,
                        lunch_time_val: timeval
                    });

                    availableval == "no" ? self.markasComplete() : null;


                }
                else if (response.data.code == 400) {

                    self.setState(
                        {
                            break_endtime: ""
                        })
                    Utils.showError(response.data.message);


                }

            })
            .catch(function (error, response) {
            })
    }

    calculateDiffTimeB(b, a, c) {
        const {
            shift_start_date,
            shift_end_date,
            shift_start_time,
            shift_end_time
        } = this.state;

        if (
            shift_start_date &&
            shift_end_date &&
            shift_start_time &&
            shift_end_time
        ) {

            timeDiff = Utils.calculateDiffTime(shift_end_time, shift_start_time);
            this.totalBidNMileage(timeDiff);
        }
    }
    renderError(err, obj = { marginTop: 4 }) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    labelLocationText = (label, topMargin = {}) => {
        return (

            <View>

                <TextLabel style={[styles.textLocation, topMargin]}>
                    {label}
                </TextLabel>

            </View>

        );
    };

    labelLocationerror = (label, topMargin = {}) => {
        return (

            <View>

                <TextLabel style={[styles.error, topMargin]}>
                    {label}
                </TextLabel>
            </View>

        );
    };

    datePickerandorid(modeval, setDate, datavalue, formatval) {
        const { shift_start_date } = this.state;
        return (

            <View>

                <DateTimePicker
                    style={{
                        borderBottomWidth: 1,
                        borderColor: Colors.textfieldBorder,
                        width: Platform.OS ? 345 : 350,
                        height: 50


                    }}
                    date={datavalue}
                    mode={modeval}
                    dateFormat={formatval}
                    minimumDate={new Date()}
                    value={new Date()}
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    is24Hour={true}
                    customStyles={{
                        dateInput: {
                            borderWidth: 0,
                            justifyContent: "flex-start",
                            alignItems: "flex-start",
                            //                            paddingTop: 6,
                            //   paddingLeft: 10
                        },
                        dateText: {
                            color: "#241332"
                        }
                    }}
                    onChange={setDate}

                />

            </View>
        );
    }

    timeColumn() {
        const {
            shift_start_time,
            shift_end_time,
        } = this.state;
        return (
            <View style={{ padding: 16 }}>
                {this.labelText("Start Time")}

                {Utils.isPlatformAndroid() ?
                    <TouchableOpacity style={styles.viewstyle}
                        onPress={showstartdate => {
                            this.setState({ showstarttime: true });
                        }}>

                        <View style={styles.passwordContainer}>
                            <TextInput
                                style={styles.inputStyletime}
                                editable={false}
                                selectTextOnFocus={false}
                                placeholder="Start Time"
                                value={this.state.shift_start_time}
                            />
                            <Image style={styles.ImageStyle}
                                source={icons.ic_time}
                            />
                        </View>
                    </TouchableOpacity> :
                    this.datePicker(
                        "Start Time",
                        icons.ic_time,
                        "time",
                        this.setStartTime,
                        shift_start_time,
                        "HH:mm:A"
                    )}

                {this.state.showstarttime == true ?
                    this.datePickerandorid("time", this.setAndroidStartTime, this.state.shift_start_time,
                        "HH:mm:A") : null}

                {!shift_start_time &&
                    this.renderError("Start Time is required", {
                        paddingHorizontal: 5
                    })}
                {this.state.startTimeErr.length > 0 &&
                    this.renderError(this.state.startTimeErr, {
                        paddingHorizontal: 5
                    })}

                {this.labelText("End Time", { marginTop: 24 })}

                {Utils.isPlatformAndroid() ?
                    <TouchableOpacity style={styles.viewstyle}
                        onPress={showstartdate => {
                            this.setState({ showendtime: true });
                        }}>

                        <View style={styles.passwordContainer}>
                            <TextInput
                                style={styles.inputStyletime}
                                editable={false}
                                selectTextOnFocus={false}
                                placeholder="End Time"
                                value={this.state.shift_end_time}
                            />
                            <Image style={styles.ImageStyle}
                                source={icons.ic_time}
                            />
                        </View>
                    </TouchableOpacity> :
                    this.datePicker(
                        "End Time",
                        icons.ic_time,
                        "time",
                        this.setEndTime,
                        shift_end_time,
                        "HH:mm:A"
                    )}

                {this.state.showendtime == true ?
                    this.datePickerandorid("time", this.setAndroidEndTime, this.state.shift_end_time, "HH:mm:A")
                    : null}
                {!shift_end_time && this.renderError("End Time is required")}
                {this.state.endTimeErr.length > 0 && this.renderError(this.state.endTimeErr)}

                {shift_end_time < shift_start_time && this.renderError("select valid start and end time")}

            </View>
        );
    }



    getAddress(latitude, longitude) {

        fetch(
            `https://maps.googleapis.com/maps/api/geocode/json?address=${latitude},${longitude}&key=${API_KEY_GOOGLE}`).
            then((response) => response.json())
            .then((responseJson) => {
                const results = JSON.stringify(responseJson);

                const address_current = responseJson.results[0].formatted_address;


                this.setState({ show_location: address_current })

                this.checkLocation(latitude, longitude);
            }
            );
    }

    verifyShiftClose = () => {

        let self = this;

        const c_id = this.props.route.params.data.contract_id;

        const {
            sign_name,
            sign_title } = this.state;

        if (sign_name && sign_title) {

            let params = {
                contract_id: c_id,
                name: this.state.sign_name,
                title: this.state.sign_title
            }
            this.props.cbShowLoader(true);

            axios.post(BASE_URL + POST_VERIFY_API, params, {
                headers: {
                    token: "api.Pd*!(5675",
                    api_version: '1.0',
                    api_client: 'android'
                }
            })
                .then(function (response) {

                    const checkval = response.data.message;

                    if (checkval != 'failure') {

                        Utils.showMessage("Success", checkval, "success");
                        self.props.cbShowLoader(false);
                        self.hidemodebox();

                    } else {


                    }
                })
                .catch(function (error) {
                    console.log(error);
                })

        } else {
            this.setState({ isError: true });
        }
    }
    totalBidNMileage(total_hours) {

        const { data, isClosedItem } = this.props.route.params;

        const { maximum_radius } = data;
        let maxRadius = maximum_radius;

        let rate = data.hourly_pay_rate && data.hourly_pay_rate;


        let bidAmount = +rate * total_hours; //i will change hour here with on shift


        let totalRadius = maxRadius;
        let dist = data.contract_invitations.invitation_latitude == null
            ? maxRadius
            : Utils.distance(data.contract_invitations.invitation_latitude,
                data.contract_invitations.invitation_longitude,
                data.contract_invitations.latitude,
                data.contract_invitations.longitude);

        totalRadius = dist > maxRadius ? maxRadius : dist;

        if (data.contract_invitations.bid_amount !== null &&
            data.contract_invitations.bid_amount !== "0.00") {


            // rate = data.contract_invitations.bid_amount / timeDiff; //change hour here
            rate = data.contract_invitations.bid_amount; //change hour here

            bidAmount = +rate * total_hours;

        }

        let totalAmount = data.cost_per_mile
            ? +bidAmount + +data.cost_per_mile * totalRadius
            : +bidAmount;

        this.setState({
            totalAmount
        });

        this.setState({ totalAmount_break: totalAmount })


    }

    radio_fun = value => {

        if (value == 'yes') {

            this.setState({ radio_value: value });

        }
        else {

            this.setState({ break_starttime: "" });
            this.setState({ break_endtime: "" });
            this.setState({ totalAmount_break: this.state.totalAmount });
            this.setState({ radio_value: value });

        }
    }
    lunchColumn() {
        const {
            break_starttime, break_endtime,
            radio_value, breakval_reason } = this.state;
        return (

            <View>
                <View style={{ paddingLeft: 10, flexDirection: 'row' }}>


                    <RadioButton.Group onValueChange={(value) => this.radio_fun(value)}
                        value={radio_value}>
                        <View style={{ flexDirection: 'row' }}>

                            <RadioButton value="yes" />
                            {this.labelText("Taken")}

                            <RadioButton value="no" />

                            {this.labelText("Not Taken")}
                        </View>
                    </RadioButton.Group>
                </View>

                {radio_value == 'yes' ?
                    <View style={{ paddingLeft: 16, flexDirection: 'row' }}>

                        <View style={{
                            flex: 1, flexDirection: 'column',
                            marginRight: 10,
                        }}>
                            {this.labelText("Start Lunch Time")}

                            {Utils.isPlatformAndroid() ?
                                <TouchableOpacity style={styles.viewrowstyle}
                                    onPress={showstartdate => {
                                        this.setState({ lunchstarttime: true });
                                    }}>

                                    <View style={styles.passwordContainer}>

                                        <TextInput
                                            style={styles.inputStyletime}
                                            editable={false}
                                            selectTextOnFocus={false}
                                            placeholder="Start Time"
                                            value={this.state.break_starttime}
                                        />
                                        <Image style={styles.ImageStyle}
                                            source={icons.ic_time}
                                        />

                                    </View>
                                </TouchableOpacity> :
                                this.datePicker(
                                    "Start Time",
                                    icons.ic_time,
                                    "time",
                                    this.setLunchStartTime,
                                    break_starttime,
                                    "HH:mm:A"
                                )}

                            {this.state.lunchstarttime == true ?
                                this.datePickerandorid("time", this.setLunchandroidStartTime,
                                    this.state.break_starttime, "HH:mm:A") : null}

                            {!break_starttime &&
                                this.renderError("Start Time is required", {
                                    paddingHorizontal: 5
                                })}
                            {this.state.startTimeErr.length > 0 &&
                                this.renderError(this.state.startTimeErr, {
                                    paddingHorizontal: 5
                                })}

                        </View>

                        <View style={{ flex: 1, flexDirection: 'column', marginRight: 10, }}>

                            {this.labelText("End Lunch Time",)}

                            {Utils.isPlatformAndroid() ?
                                <TouchableOpacity style={styles.viewrowstyle}
                                    onPress={showstartdate => {
                                        this.setState({ lunchendtime: true });
                                    }}>

                                    <View style={styles.passwordContainer}>
                                        <TextInput
                                            style={styles.inputStyletime}
                                            editable={false}
                                            selectTextOnFocus={false}
                                            placeholder="End Time"
                                            value={this.state.break_endtime}
                                        />
                                        <Image style={styles.ImageStyle}
                                            source={icons.ic_time}
                                        />
                                    </View>
                                </TouchableOpacity> :
                                this.datePicker(
                                    "End Time",
                                    icons.ic_time,
                                    "time",
                                    this.setLunchEndTime,
                                    break_endtime,
                                    "HH:mm:A"
                                )}

                            {this.state.lunchendtime == true ?
                                this.datePickerandorid("time", this.setLunchandroidEndTime,
                                    this.state.break_endtime, "HH:mm:A") : null}

                            {!break_endtime && this.renderError("End Time is required")}
                            {this.state.endTimeErr.length > 0 && this.renderError(this.state.endTimeErr)}

                            {break_endtime < break_endtime && this.renderError("select valid start and end time")}

                        </View>
                    </View>

                    : <View
                        style={[
                            styles.modalFirstColumn,
                            { paddingLeft: 16, marginVertical: 10 }]} >
                        {this.labelText("Lunch Break Reason :")}
                        <TextInput
                            numberOfLines={5}
                            multiline={true}
                            onChangeText={(value) => this.setState({ breakval_reason: value })}
                            style={styles.inputMessageStyle}
                        />

                        {!breakval_reason && this.renderError("Enter the Reason")}

                    </View>}

            </View>
        );
    }

    onSubmit = () => {

        const { shift_start_time, shift_end_time, totalAmount, totalAmount_break, breakavailable,
            radio_value, break_starttime, break_endtime, breakval_reason } = this.state;
        const { contract_id, contract_type } = data;
        const { id } = this.props.user;

        if (breakavailable == "yes") {


            if (radio_value == "yes") {


                if (break_starttime > break_endtime) {

                    Utils.showError("Enter valid Lunch break Time");

                }
                else if (break_starttime && break_endtime) {

                    this.markasComplete();


                }
                else {

                    this.setState({ isError: true });

                }

            }
            else if (radio_value == "no") {

                if (breakval_reason && shift_start_time && shift_end_time) {

                    this.gettotalvalue("");


                }
                else {

                    this.setState({ isError: true });

                }
            }

        }
        else {

            if (shift_start_time && shift_end_time) {

                this.markasComplete();

            } else {
                this.setState({ isError: true });
            }
        }
    };

    markasComplete = () => {

        const { shift_start_time, shift_end_time, totalAmount, totalAmount_break,
            lunch_available_val, lunch_reason_val, lunch_time_val, } = this.state;
        const { contract_id, contract_type } = data;
        const { id } = this.props.user;

        this.props.cbShowLoader(true);


        let timeval = shift_start_time + " to " + shift_end_time;

        this.setState({ shift_time: timeval })
        let payload = new FormData();
        payload.append('contract_id', contract_id)
        payload.append('shift_start_time', shift_start_time)
        payload.append('shift_end_time', shift_end_time)
        payload.append('total_hours', timeDiff)
        payload.append('total_amount', this.state.radio_value == "yes" ? totalAmount_break : totalAmount)
        payload.append('contractor_id', id)
        payload.append('contract_type', contract_type)
        payload.append('lunch_break', lunch_available_val);
        payload.append('lunch_break_reason', lunch_reason_val);
        payload.append('lunch_break_time', lunch_time_val);

        this.props.generalAction(
            API_MARK_AS_COMPLETE_CLINICIAN,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbSuccess,
            this.cbFailure
        );
    };
    cbSuccess = (response, message) => {
        this.props.cbShowLoader(false);
        Utils.showMessage("Success", message, "success");
        // setTimeout(() => {
        //     pop()
        // }, 300);

        if (this.state.loc_verify_show == null) {

            this.setState({ Modal: true })

        }
        else {

            setTimeout(() => {
                pop(2)
            }, 300);

        }
    }
    cbFailure = (error) => {
        this.props.cbShowLoader(false);
        Utils.showError(error);
    }

    hidemodebox = () => {

        this.setState({ Modal: false });
        setTimeout(() => {
            pop(2)
        }, 300);
    }

    render() {
        const { contractor_id, hourly_pay_rate, contract_invitations, total_hours, hour_rate } = data;
        const { totalAmount, totalAmount_break, shift_start_date, shift_end_date,
            shift_start_time, shift_end_time } = this.state;

        const { bid_amount } = contract_invitations;
        let rate = !Utils.isNull(bid_amount) && bid_amount !== '0.00' ? bid_amount / total_hours : hourly_pay_rate;

        return (
            <Container>
                <ScrollView>
                    {this.timeColumn()}

                    {this.state.breakavailable == "yes" ?
                        this.lunchColumn() : null}

                    <InfoCard
                        item={data}
                        style={{ marginTop: Metrics.screenWidth - 80 }}
                    // onPress={() => push("contractorDetail", {
                    //     data: { user_id: contractor_id },
                    //     showFooter: false
                    // })} 
                    />
                </ScrollView>

                <View style={Styles.bottom}>
                    <TextLabel style={Styles.title}>Total Cost</TextLabel>
                    <View style={{ alignItems: 'flex-end' }}>

                        {this.state.radio_value == "yes" ?

                            <TextLabel style={Styles.title}>{`$${totalAmount_break.toFixed(2)}`}</TextLabel>

                            : <TextLabel style={Styles.title}>{`$${totalAmount.toFixed(2)}`}</TextLabel>}


                        <TextLabel>{`Payment Break down : ( $${hour_rate}* ${timeDiff.toFixed(2)}hr )`}</TextLabel>
                    </View>
                    {/* bit amount */}
                </View>

                <AppButton
                    buttonTitle="SUBMIT"
                    style={{ backgroundColor: colors.ActiveTabTitle, fontWeight: 'bold' }}
                    btnColor={'#fff'}

                    onPress={() => this.onSubmit()}
                />


                <View style={styles.centeredView}>
                    <Overlay
                        animationType="slide"
                        transparent={true}
                        isVisible={this.state.Modal}
                        onRequestClose={() => {
                            this.setState({ Modal: false })
                            pop(2);
                        }}>
                        <ScrollView
                            showsHorizontalScrollIndicator={false}
                            keyboardShouldPersistTaps="always"
                            style={{

                                // flexDirection: 'row',
                                flexGrow: 0,
                                //width: '100%',
                            }}>
                            <View >

                                <TouchableOpacity
                                    activeOpacity={1}
                                // onPressOut={() => this.hidemodebox()}
                                >

                                    <View style={styles.modalView}>

                                        {this.labelText("Title/certification")}
                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.shift_name}
                                            editable={false}
                                            selectTextOnFocus={false}

                                            style={styles.inputhiddenStyle} />

                                        {this.labelText("Timing")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.shift_time}
                                            editable={false}
                                            selectTextOnFocus={false}
                                            style={styles.inputhiddenStyle}
                                        />

                                        {this.labelText("Current Location")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.show_location}
                                            editable={false}
                                            autoFocus={true}
                                            selection={{ start: 0, end: 0 }}
                                            style={styles.inputhiddenStyle} />

                                        {this.state.location_fetch == "" ? null
                                            : this.labelLocationerror(this.state.location_fetch)}

                                        {this.labelText("To Location")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.to_loc}
                                            editable={false}
                                            autoFocus={true}
                                            selection={{ start: 0, end: 0 }}
                                            style={styles.inputhiddenStyle} />

                                        {this.state.location_status ? this.labelLocationText("Location is  Matched")
                                            : this.labelLocationerror("Location is not Matched")}


                                        {this.labelText("Signature")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            placeholder="Enter name"
                                            onChangeText={(entry) => {
                                                this.setState({
                                                    sign_name: entry
                                                })
                                            }}
                                            style={styles.inputStyle} />

                                        {!this.state.sign_name &&
                                            this.renderError(`Name is required`)}
                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            placeholder="Enter Title"
                                            onChangeText={(entry) => {
                                                this.setState({
                                                    sign_title: entry
                                                })
                                            }}
                                            style={styles.inputStylelast} />

                                        {!this.state.sign_title &&
                                            this.renderError(`Title is required`)}

                                        <View style={{
                                            flexDirection: "row", alignItems: 'center', alignSelf: 'center',
                                            alignContent: 'center'
                                        }}>
                                            <View style={styles.buttonStyleback}>
                                                <AppButton
                                                    buttonTitle="CANCEL"
                                                    style={{
                                                        backgroundColor: "#d45404", height: 50,
                                                        height: 50,
                                                        width: "100%", alignItems: 'center'
                                                    }}
                                                    btnColor="#d45404"
                                                    onPress={() => {
                                                        this.setState({ Modal: false })
                                                    }}
                                                />
                                            </View>
                                            <View style={styles.buttonStyle}>
                                                <AppButton
                                                    buttonTitle="VERIFY"
                                                    style={{
                                                        backgroundColor: colors.ActiveTabTitle,
                                                        height: 50,
                                                        width: "100%", alignItems: 'center'
                                                    }}
                                                    btnColor={colors.cardColor}
                                                    onPress={() => {
                                                        this.verifyShiftClose();
                                                    }}

                                                />

                                            </View>
                                        </View>

                                    </View>
                                </TouchableOpacity>
                            </View>
                        </ScrollView>

                    </Overlay>


                </View>
            </Container>
        );
    }

    datePicker(title, icon, dateTime, setPickedDate, dateVlue, format) {
        return (
            <View>
                <DatePicker
                    style={styles.datePickerInput}
                    date={dateVlue}
                    mode={dateTime}
                    placeholder={title}
                    format={format}
                    minDate={
                        dateTime == "time"
                            ? null
                            : moment().format("YYYY-MM-DD")
                    }
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    iconComponent={
                        <Image
                            source={icon}
                            style={{ width: 15, height: 15, top: -5 }}
                        />
                    }
                    customStyles={{
                        dateInput: styles.dateInput,
                        dateText: { color: "#241332" }
                    }}
                    onDateChange={setPickedDate}
                />
            </View>
        );
    }
}
const Styles = StyleSheet.create({
    title: {
        fontWeight: 'bold',
        fontSize: 20,
        color: Colors.black
    }, bottom: {
        alignItems: 'center',
        padding: 16,
        backgroundColor: '#fff',
        flexDirection: 'row',
        justifyContent: 'space-between'
    }
});

const actions = { generalAction };

const mapStateToProps = ({ user }) => {
    return {
        user: user.data
    };
};

const ComposeAddShiftTiming = compose(
    connect(mapStateToProps, actions)(WithFetching(AddShiftTiming))
);

export default ComposeAddShiftTiming;