import React, { Component } from "react";
import {
    View,
    StyleSheet,
    TouchableOpacity,
    Text,
    Linking,
} from "react-native";
import { connect } from "react-redux";
import { UIFont, fonts, fontSize, colors } from "../../assets";
import { generalAction } from "../../actions/GeneralActions";

class AppUpdate extends Component {

    state = {
        url: this.props.valueset,
    };

    componentDidMount() {
    }
    Openurl = () => {

        Linking.openURL(this.state.url)
    }
    render() {
        return (
            <View style={styles.updateview} >
                <Text style={{
                    padding: 20, fontFamily: 'Gibson',
                    ...UIFont.font(fonts.semiBold, fontSize.xLarge, colors.BlackColor),
                    fontSize: 20, alignSelf: 'center'
                }}

                >Time to Update</Text>

                <Text style={{
                    color: 'black', padding: 20, fontFamily: 'Gibson',
                    ...UIFont.font(fonts.regular, fontSize.medium, colors.BlackColor),
                    fontSize: 20, alignSelf: 'baseline'
                }}

                >We added lots of new features and fixed some
                    bugs to make your experience as smooth as possible</Text>

                <TouchableOpacity
                    activeOpacity={1.0}
                    style={
                        styles.modalverifyFooter}
                    onPress={() =>
                        this.Openurl()
                    } >

                    <Text style={{
                        color: '#ffff',
                        textAlign: 'center',
                        ...UIFont.font(fonts.semiBold, fontSize.medium, colors.WhiteColor),
                        padding: 10,
                    }}>
                        Update
                    </Text>

                </TouchableOpacity>
            </View>

        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, closeContracts }) => ({
    user: user.data,
    closeContracts: closeContracts.data
});

export default connect(mapStateToProps, actions)(AppUpdate);

const styles = StyleSheet.create({

    modalverifyFooter: {
        width: "50%",
        alignContent: 'center',
        alignSelf: 'center',
        backgroundColor: "#bb050c",
        borderRadius: 5,
    },
    updateview: {
        justifyContent: 'flex-end',
        width: "85%",
        backgroundColor: "white",
        padding: 5,
        borderTopLeftRadius: 5,
        borderTopRightRadius: 5,
    },
});