import React, { Component, Fragment } from "react";
import {
  StyleSheet,
  Text,
  View,
  Image,
  TouchableOpacity
} from "react-native";
import {  Separator ,Supporticon} from "../../components";
import { icons, UIFont, fonts, fontSize, colors } from "../../assets";
import { generalAction } from "../../actions/GeneralActions";
import { API_CHANGE_STATUS } from "../../services/WebService";
import { USER } from "../../actions/ActionTypes";
import { connect } from "react-redux";
import { push } from "../../services/NavigationService";

class Availability extends Component {
  static navigationOptions = ({}) => {
    return {
      headerStyle: styles.header,
      headerRight: (
        <View style={{ backgroundColor: colors.HeaderColor, width: "10%" }} />
      )
    };
  };

  constructor(props, context) {
    super(props, context);
    this.state = {
      available: props.user.is_online ? true : false,
      notAvailable: props.user.is_online ? false : true
    };
  }

  changeStatus = availability => {
    const { user } = this.props;
    let payload = new FormData();
    payload.append("user_id", user.id);
    payload.append("is_online", availability ? 1 : 0);
    this.props.generalAction(
      API_CHANGE_STATUS,
      payload,
      USER.SUCCESS,
      USER.FAILURE,
      () => {},
      () => {}
    );
  };

  CardGap = obj => <View style={obj} />;

  heading() {
    return (
      <React.Fragment>
        <View style={{ flexDirection: "row", alignSelf: "flex-start" }}>
          <Text style={[styles.heading, styles.boldHeading]}>Mark</Text>
          <Text style={styles.heading}> your</Text>
        </View>
        <Text style={[styles.heading, { marginLeft: 25 }]}>Availability</Text>
      </React.Fragment>
    );
  }

  changeStatusUI(title, state) {
    const { available, notAvailable } = this.state;
    return (
      <Fragment>
        <Text style={styles.availableNotAvailable}>{title}</Text>
        <TouchableOpacity
          style={{ padding: 5 }}
          onPress={() => {
            this.setState({
              available: !available,
              notAvailable: !notAvailable
            });
            this.changeStatus(!available);
          }}
        >
          <Image source={state ? icons.ic_check : icons.ic_uncheck} />
        </TouchableOpacity>
      </Fragment>
    );
  }

  render() {
    const { available, notAvailable } = this.state;
    return (
      <View style={{ flex: 1 }}>
        {this.CardGap(styles.divForUpperSpace)}
        {this.heading()}
        <Separator style={styles.separatorStyle} />
        <View style={styles.availableStyle}>
          {this.changeStatusUI("Available", available)}
        </View>
        <View style={{ flex: 3, paddingHorizontal: 30 }}>
          <View style={styles.notAvailableStyle}>
            {this.changeStatusUI("Not Available", notAvailable)}
          </View>
          <View style={{ flex: 1, marginTop: -10 }}>
            <Text style={styles.para}>
              We won’t send you invitations when you are
            </Text>
            <Text style={styles.para}>not available </Text>
          </View>
        </View>
        <View style={{ flex: 9 }} />
        <Supporticon
                 clickBtn={() =>push("Support")}/>
      </View>
    );
  }
}

const actions = { generalAction };

const mapStateToProps = ({ user }) => {
  return {
    user: user.data
  };
};

export default connect(
  mapStateToProps,
  actions
)(Availability);

const styles = StyleSheet.create({
  header: {
    borderBottomWidth: 0,
    backgroundColor: colors.cardColor,
    shadowColor: "transparent",
    elevation: 0,
    shadowRadius: 0,
    shadowOffset: {
      height: 0
    }
  },
  heading: {
    ...UIFont.font(fonts.regular, fontSize.huge, colors.ActiveTabTitle),
    lineHeight: 39,
    letterSpacing: 0,
    alignSelf: "flex-start"
  },
  boldHeading: {
    ...UIFont.font(fonts.semiBold, fontSize.huge, colors.ActiveTabTitle),
    marginLeft: 25
  },
  divForUpperSpace: {
    flex: 0.5
  },
  separatorStyle: {
    backgroundColor: "#f4f4f6",
    marginHorizontal: 20,
    marginTop: 30
  },
  availableNotAvailable: {
    flex: 3,
    ...UIFont.font(fonts.semiBold, 22, colors.BlackColor),
    lineHeight: 39,
    letterSpacing: 0,
    textAlign: "left"
  },
  para: {
    ...UIFont.font(fonts.regular, 12, colors.BlackColor),
    lineHeight: 19,
    letterSpacing: 0,
    textAlign: "left"
  },
  availableStyle: {
    flex: 3,
    flexDirection: "row",
    paddingHorizontal: 30,
    alignItems: "center"
  },
  notAvailableStyle: {
    flex: 1.5,
    flexDirection: "row",
    alignItems: "center"
  }
});
