import React, { Component } from "react";
import { View, StyleSheet } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, MainCard,  Supporticon} from "../../components";
import { API_ALL_CONTRACTS } from "../../services/WebService";
import { push } from "../../services/NavigationService";
import { colors} from "../../assets";
import { generalAction } from "../../actions/GeneralActions";
import { LIST_ALL_CONTRACTS } from "../../actions/ActionTypes";

class AvailableJobs extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isFetching: false,
            isrefresh: false
        };
    }

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1, obj = {}) => {
        const { id, category_id } = this.props.user;
        this.setState({ isFetching: true });
        this.setState({ isrefresh: true });

        this.props.generalAction(
            API_ALL_CONTRACTS,
            { category_id, ...obj, page },

            LIST_ALL_CONTRACTS.SUCCESS,
            LIST_ALL_CONTRACTS.FAILURE,
            () => {

                this.setState({ isFetching: false });
                this.setState({ isrefresh: false });

                // this.setState({ refresh: false });

            },
            () => {

                this.setState({ isFetching: false });
                this.setState({ isrefresh: false });

                // this.setState({ refresh: false });

            },
            true,
            isConcat


        );
    };

    applyFilters = () => {
        push("filters", {
            cbOnApplyFilters: this.cbOnApplyFilters,
            screen: "availableJobs"
        });
    };

    cbOnApplyFilters = obj => {
        this.fetchData(false, 1, obj);
    };

    onChangeText = keyword => {
        this.fetchData(false, 1, { keyword });
    };

    renderItem = ({ item, index }, onDelete, goTo) => {

        return (
            <MainCard
                item={item}
                onDelete={onDelete}
                goTo={goTo}
                routeName={true}
            />
        );
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
               
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isrefresh}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.allContracts}
                    renderItem={item =>

                        this.renderItem(item, this.props.onDelete, data =>

                            push("availableJobsDetail", {
                                data,
                                screen: "available"
                            })
                        )

                    }
                />

                <Supporticon
                 clickBtn={() =>push("Support")}/>
                 
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, allContracts }) => ({
    user: user.data,
    allContracts: allContracts.data
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    AvailableJobs
);

const styles = StyleSheet.create({
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: colors.bgLightGrey
    },

});
