import React, { Component, Fragment } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    ScrollView,
    TouchableWithoutFeedback,
} from "react-native";
import { connect } from "react-redux";
import {
    InfoModal,
    AllInfo,
    RejectModal,
    AcceptModal,
    InfoMileage
} from "../../appComponents/ModalComponents";
import { Supporticon } from "../../components";
import { compose } from "redux";
import { pop, push, reset } from "../../services/NavigationService";
import { Images, icons, colors } from "../../assets";
import {
    DetailCard,
    Separator,
    TextLabel,
    FooterDetail,
    ReusableModal,
    MileagePaidBidRate,
    AcceptRejectBid
} from "../../components";
import {
    API_FACILITY_INVITATION,
    API_INVITATION_REJECT,
    API_INVITATION_ACCEPT,
    API_PERCENTAGE
} from "../../services/WebService";
import { generalAction, notificationBar, generalSaveAction } from "../../actions/GeneralActions";
import { DUMP, SHOW_BAR, HIDE_BAR, ADMIN_FEE_AMOUNT } from "../../actions/ActionTypes";
import { WithFetching } from "../../HOC";
import Utils from "../../Utils";
import moment from "moment";
import styles from "./styles";
import { API_KEY_GOOGLE } from "../../constants";
import { selectPostDetails } from "../../reduxSelectors";

class AvailableJobsDetail extends Component {
    constructor(props) {
        super(props);
        this.state = {
            maxRadius: props.route.params.data.maximum_radius,
            initial: true,
            totalBidAmount: 0,
            bidRate: 0,
            address: "",
            totalMileage: 0,
            latitude: 0,
            longitude: 0,
            rejectReason: "",
            boo: false,
            modal: "",
            percentageRate: 0
        };


    }

    componentDidMount() {

        const {
            contract_type,
            cost_per_mile
        } = this.props.route.params.data;
        this.props.navigation.setParams({
            showInfo: () => this.showModal("allInfo"),
            boo:
                contract_type == "Shift" && cost_per_mile == null
                    ? null
                    : cost_per_mile
        });
        this.getPercentageValue();
    }
    getPercentageValue = () => {
        this.props.cbShowLoader(true);
        this.props.generalAction(
            API_PERCENTAGE,
            null,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbSuccess,
            this.cbFailure,
            true
        );
    }
    cbSuccess = (response) => {
        this.props.cbShowLoader(false);
        const { percentage_value } = response;
        this.setState({
            percentageRate: percentage_value
        });
        this.props.generalSaveAction(ADMIN_FEE_AMOUNT, { amount: percentage_value });
        Utils.setAdminFee(percentage_value);
    }
    cbFailure = (response) => {

        this.props.cbShowLoader(false);
    }


    cbOnApplyFilters = obj => {
        const { data, screen } = this.props.route.params,
            { is_mileage_paid, invitation_id } = data;
        if (is_mileage_paid && screen == "received" && this.state.isAccepted) {
            let api = "",
                payload = new FormData();
            api = API_INVITATION_ACCEPT;
            payload.append("id", invitation_id);
            payload.append("user_id", this.props.user.id);
            payload.append("latitude", obj.latitude);
            payload.append("longitude", obj.longitude);
            payload.append("address", obj.address);

            this.callApi(api, payload);
        } else {
            this.setState({ ...obj, ...{ initial: false } });
        }
    };

    goTo = data => {
        const { user } = this.props,
            { address, latitude, longitude, totalBidAmount, bidRate } = this.state;

        let payload = new FormData();
        payload.append("user_id", user.id);
        payload.append("contract_id", data.contract_id);
        payload.append("invitation_status", "pending");
        payload.append("invitation_type", "received");
        payload.append("latitude", latitude);
        payload.append("longitude", longitude);
        payload.append("bid_amount", totalBidAmount);
        payload.append("bid_amount_new", bidRate);
        payload.append("address", address);

        this.callApi(API_FACILITY_INVITATION, payload);// mileage request
    };

    AcceptReject = () => {
        const {
            invitation_id,
            contract_id,
            is_mileage_paid
        } = this.props.route.params.data,
            { rejectReason, modal } = this.state;
        let api = "",
            payload = new FormData();
        if (modal == "accept") {
            if (is_mileage_paid) {
                this.hideModal();
                this.next(
                    "mileagePaid",
                    "Request",
                    this.props.route.params.data
                );
                this.setState({ isAccepted: true });

            } else {
                api = API_INVITATION_ACCEPT;
                payload.append("id", invitation_id);
                payload.append("user_id", this.props.user.id);
                this.callApi(api, payload);
            }

        } else {
            payload.append("user_id", this.props.user.id);
            payload.append("id", invitation_id);
            payload.append("message", rejectReason);
            api = API_INVITATION_REJECT;
            this.callApi(api, payload);
        }
    };

    callApi = (api, payload) => {
        this.props.generalAction(
            api,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.AcceptRejectSuccess,
            this.AcceptRejectFailure,

        );
        this.props.cbShowLoader(true);
    };

    AcceptRejectSuccess = (res) => {
        const { data } = this.props.route.params,
            { modal, totalBidAmount, totalMileage } = this.state;
        this.props.cbShowLoader(false);
        this.hideModal();

        if (modal === "accept") {
            Utils.showMessage(
                "Success",
                `${data.contract_type} accepted successfully`,
                "success"
            );
            reset("mySchedule");
        } else if (modal === "" || totalBidAmount > 0 || totalMileage > 0) {
            pop();
            this.invitationSent(data);
        } else if (modal == "reject") {
            pop();
        }
    };

    AcceptRejectFailure = err => {
        this.hideModal();
        this.props.cbShowLoader(false);
        Utils.showError(err);
    };

    invitationSent({ image_url, full_name }) {
        let obj = {
            image_url,
            full_name,
            message: "Your request has been sent"
        };
        this.props.notificationBar(SHOW_BAR, obj);
        setTimeout(() => {
            this.props.notificationBar(HIDE_BAR);
        }, 3000);
    }

    showModal = modal => {
        this.setState({ modal });
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.setState({ boo: false });
        this.Modal.setModalVisible(false);
    };

    renderModal = () => {
        const { modal, boo, rejectReason, maxRadius } = this.state,
            { data } = this.props.route.params;
        const {
            contract_type,
            cost_per_mile,
            hourly_pay_rate,
            total_hours
        } = this.props.route.params.data;
        let rate =
            hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0, data.contract_rate.indexOf("."))
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0,
                    data.hourly_pay_rate.indexOf(".")
                );
        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * data.total_hours;
        let totalAmount = data.cost_per_mile
            ? bidAmount + +data.cost_per_mile * maxRadius
            : bidAmount;

        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={styles.modalContainer}>
                        <View style={styles.modalInner}>
                            {modal == "info" && (
                                <InfoModal
                                    costMile={cost_per_mile}
                                    maxRadius={maxRadius}
                                />
                            )}
                            {modal == "allInfo" && (
                                <AllInfo note={this.props.note} />
                            )}
                            {modal == "mileage" && (
                                <InfoMileage
                                    rate={rate}
                                    contract_type={contract_type}
                                    diffTime={total_hours}
                                />
                            )}
                            {modal == "reject" && (
                                <RejectModal
                                    deleteContract={this.AcceptReject}
                                    hideModal={this.hideModal}
                                    onChangeText={rejectReason =>
                                        this.setState({ rejectReason })
                                    }
                                    value={rejectReason}
                                    onFocus={() => this.setState({ boo: true })}
                                    onBlur={() => this.setState({ boo: false })}
                                    boo={boo}
                                />
                            )}
                            {modal == "accept" && (
                                <AcceptModal
                                    deleteContract={this.AcceptReject}
                                    hideModal={this.hideModal}
                                    text1={"Are you sure you want to accept"}
                                    text2={`the ${contract_type}?`}
                                    total={`${totalAmount}`}
                                    showTotal={false}
                                />
                            )}
                        </View>
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };

    heading(label, style) {
        return (
            <TextLabel color={"black"} style={style}>
                {label}
            </TextLabel>
        );
    }

    footer(style, text, bgColor, textColor, callBack) {
        return (
            <FooterDetail
                style={style}
                text={text}
                backgroundColor={bgColor}
                textColor={{ color: textColor }}
                clickBtn={callBack}
            />
        );
    }

    paragraph(para, style, numberOfLines) {
        return (
            <Text style={style} numberOfLines={numberOfLines}>
                {para}
            </Text>
        );
    }

    labelButton(txt1, txt2, style) {
        return (
            <View style={[styles.eachView, style]}>
                <Text style={styles.firstText}>{txt1}</Text>
                <Text style={styles.txtContract}>{txt2}</Text>
            </View>
        );
    }

    bidRateLabelButton(bidRate, totalBidAmount, totalMileage, boo) {
        const { data } = this.props.route.params;
        return (
            <View
                style={[
                    styles.defaultStyle,
                    { marginVertical: 20, marginBottom: 70 }
                ]}
            >
                <View style={{ flex: 1.5 }}>
                    {this.heading("Bid Rate", [
                        styles.mileageBidLabelStyle,
                        { marginBottom: -5 }
                    ])}
                </View>
                <View
                    style={[
                        styles.ViewLabelButton,
                        {
                            flex: 3.5,
                            justifyContent: "space-between",
                            flexDirection: !boo ? "row" : "row-reverse"
                        }
                    ]}
                >
                    {!boo &&
                        this.labelButton("Your Bid", `$${bidRate}`, {
                            width: "24%"
                        })}
                    {!boo &&
                        this.labelButton("Hour Total", `$${(totalBidAmount).toFixed(2)}`, {
                            width: "33%"
                        })}
                    {this.labelButton(
                        boo ||
                            (data.contract_type == "Shift" &&
                                data.cost_per_mile == null)
                            ? "Total"
                            : "Total(Mileage + Bid)",
                        `$${(+totalMileage + +totalBidAmount).toFixed(2)}`,
                        {
                            width: "39%"
                        }
                    )}
                </View>
            </View>
        );
    }

    mileagePaidLabelButtonWithoutBid(rate, mileage) {
        return (
            <View
                style={[
                    styles.defaultStyle,
                    { marginVertical: 20, marginBottom: 90 }
                ]}
            >
                <View style={{ flex: 1.3 }}>
                    {this.heading("Rate", [
                        styles.mileageBidLabelStyle,
                        { marginBottom: -5 }
                    ])}
                </View>
                <View
                    style={[
                        styles.ViewLabelButton,
                        {
                            flex: 4,
                            justifyContent: "space-between",
                            flexDirection: "row"
                        }
                    ]}
                >
                    {this.labelButton("Hour Total", `$${(rate).toFixed(2)}`, {
                        width: "49%"
                    })}
                    {this.labelButton("Total", `$${(+rate + +mileage).toFixed(2)}`, {
                        width: "49%"
                    })}
                </View>
            </View>
        );
    }

    mileagePaidLabelButton(mileage) {
        return (
            <View style={[styles.defaultStyle, { marginTop: 10 }]}>
                <View style={{ flex: 4 }}>
                    {this.heading("Mileage Paid", [
                        styles.mileageBidLabelStyle,
                        { marginBottom: -5 }
                    ])}
                </View>
                <View style={[styles.ViewLabelButton, { flex: 2 }]}>
                    {this.labelButton("Mileage Total", `$${+(mileage).toFixed(2)}`, {
                        width: "65%"
                    })}
                </View>
            </View>
        );
    }

    renderMap = (latitude, longitude) => {
        const baseUrl = "https://maps.googleapis.com/maps/api/staticmap";
        const markerCenter = `center=${latitude},${longitude}`;
        const API_KEY = `key=${API_KEY_GOOGLE}`;
        const zoomLevel = "zoom=16";
        const imageSize = `size=400x400`;
        const customMarkerIcon = `markers=icon:https://assets.mapquestapi.com/icon/v2/circle.png%7Clabel:C%7C${latitude},${longitude}`;
        const mapImageUrl = `${baseUrl}?${markerCenter}&${zoomLevel}&${imageSize}&${API_KEY}&${customMarkerIcon}`;

        return (
            <View style={styles.mapStyle}>
                <Image
                    source={{ uri: mapImageUrl }}
                    style={{ width: "100%", height: "100%", borderRadius: 6 }}
                />
            </View>
        );
    };

    next = (goTo, btn, data) => {
        if (btn === "Request" && !data.is_mileage_paid) {
            this.goTo(data);
        } else {

            push(goTo, {
                cbOnApplyFilters: this.cbOnApplyFilters,
                data,
                is_mileage_paid: data.is_mileage_paid,
                location_address: data.location_address,
                latitude: data.latitude,
                longitude: data.longitude,
                cost_per_mile: data.cost_per_mile,
                shift_end_time: data.shift_end_time,
                shift_start_time: data.shift_start_time,
                contract_type: data.contract_type,
                maximum_radius: data.maximum_radius,
                total_hours: data.total_hours,
                btn
            });
        }
    };

    calculateDiffTime = (b, a) => {
        let dif = moment(b, "HH:mm:a").diff(moment(a, "HH:mm:a"));
        let diffTime = moment.duration(dif).hours();
        return +diffTime == 0 ? 1 : diffTime;
    };

    checkProfileNAccountValidation(text) {
        const { user } = this.props;
        if (!user.is_stripe_key) {
            Utils.showAlert(
                "Account details",
                `You have to provide account details in order to ${text} request`,
                () => push("paymentMethod")
            );
        } else if (
            user.is_personnel_file_status !== 2 ||
            user.is_profile_verified !== 2
        ) {
            Utils.showAlert(
                "Profile Verification",
                `Your Profile need to be verified in order to ${text} request`,
                () => push("profile")
            );
        }
    }

    rateCard = () => {
        const { data, screen } = this.props.route.params;
        let user_id = data.user_id;
        // if (screen === "available") {
        //     user_id = 217;
        // }
        return (
            <View
                style={{
                    height: 60,
                    width: "100%",
                    flexDirection: "row",
                    paddingHorizontal: 20,
                    paddingTop: 25
                }}
            >
                <TouchableOpacity
                    onPress={() => push("ratingAndComments", { user_id })}
                >
                    <Text style={{ color: "blue" }}>
                        View Rating and Comments
                    </Text>
                </TouchableOpacity>
                <View style={{ flex: 0.3 }}>
                    
                </View>
            </View>
        );
    };

    render() {
        const { data, screen } = this.props.route.params,
            {
                initial,
                totalBidAmount,
                totalMileage,
                address,
                bidRate,
                percentageRate
            } = this.state,
            { user } = this.props;

        let rate =
            data.hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0)
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0
                );
        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * data.total_hours;

        let totalAmount = data.cost_per_mile
            ? bidAmount + +data.cost_per_mile * this.state.maxRadius
            : bidAmount;

        let total =
            +totalBidAmount > 0 && +totalMileage == 0
                ? +totalBidAmount
                : +totalBidAmount == 0 && +totalMileage > 0
                    ? +totalMileage + bidAmount
                    : +totalBidAmount + +totalMileage;

        return (
            <Fragment>
                <ScrollView contentContainerStyle={{}}>
                    <DetailCard
                        data={data}
                        cbMileage={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("info")
                        }
                        cbTotal={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("mileage")
                        }
                        style={{ backgroundColor: colors.cardColor }}
                    />
                    <Separator style={styles.separatorStyle} />
                    <Text style={{ color: "green", marginHorizontal: 20 }}>{`${data.admin_percent}% adminstration fee will be applied.`}</Text>
                    <Separator style={styles.separatorStyle} />
                    {this.rateCard()}
                    {!!totalMileage && (
                        <Separator style={styles.separatorStyle} />
                    )}
                    {!!totalMileage && (
                        <MileagePaidBidRate
                            val1={data.location_address}
                            val2={address}
                            style={styles.textStyle}
                        />
                    )}
                    {!!totalMileage &&
                        this.mileagePaidLabelButton(totalMileage)}
                    {!!totalBidAmount && (
                        <Separator style={styles.separatorStyle} />
                    )}
                    {!initial &&
                        totalBidAmount == 0 &&
                        this.mileagePaidLabelButtonWithoutBid(
                            bidAmount,
                            totalMileage
                        )}
                    {!!totalBidAmount &&
                        this.bidRateLabelButton(
                            bidRate,
                            totalBidAmount,
                            totalMileage,
                            data.contract_type === "Contract"
                        )}
                    {!!!totalMileage &&
                        !!!totalBidAmount &&
                        screen === "available" && (
                            <Separator style={styles.separatorStyle} />
                        )}
                    {!!!totalMileage &&
                        !!!totalBidAmount &&
                        this.heading("Description", styles.boldText)}
                    {!!!totalMileage &&
                        !!!totalBidAmount &&
                        this.paragraph(
                            data.description,
                            [
                                styles.descriptionStyle,
                                {
                                    marginBottom:
                                        !initial &&
                                            screen === "received" &&
                                            data.is_mileage_paid
                                            ? 100
                                            : 10
                                }
                            ],
                            2
                        )}
                    {!!!totalMileage &&
                        !!!totalBidAmount &&
                        screen === "available" && (
                            <Separator style={styles.separatorStyle} />
                        )}
                    {initial && screen === "received" && !data.is_onboarded && (
                        <AcceptRejectBid
                            screen={"sent"}
                            text1={"Accept"}
                            text2={"Reject"}
                            cbOne={() => {
                                if (
                                    user.is_stripe_key &&
                                    user.is_personnel_file_status == 2
                                ) {
                                    this.showModal("accept");
                                } else {
                                    this.checkProfileNAccountValidation(
                                        "accept this"
                                    );
                                }
                            }}
                            cbTwo={() => this.showModal("reject")}
                        />
                    )}
                    {this.paragraph(
                        data.location_address,
                        styles.locationStyle,
                        1
                    )}
                    {this.renderMap(data.latitude, data.longitude)}

                </ScrollView>
                {!initial &&
                    this.footer(
                        { position: "absolute", bottom: 0 },
                        "SEND REQUEST",
                        {
                            backgroundColor: "#08548c"
                        },
                        "#ffffff",
                        () => this.goTo(data)
                    )}
                {initial &&
                    screen === "available" &&  // mileage paid
                    this.footer({ position: "absolute", bottom: 0, right: 0, width: "50%" },
                        "SEND REQUEST",
                        {
                            backgroundColor: "#959dad"
                        },
                        "#ffffff",
                        () => {
                            if (
                                user.is_stripe_key &&
                                user.is_personnel_file_status == 2
                            ) { //move next page
                                this.next(
                                    data.is_mileage_paid
                                        ? "mileagePaid"
                                        : "bidRate",
                                    "Request",
                                    data
                                );
                            } else {
                                this.checkProfileNAccountValidation(
                                    "bid or send"
                                );
                            }
                        }
                    )}
                {initial &&
                    !data.is_onboarded &&
                    this.footer(
                        {
                            position: "absolute",
                            bottom: 0,
                            width: screen === "available" ? "50%" : "100%"
                        },
                        "BID NOW",
                        {
                            backgroundColor: "#08548c"
                        },
                        "#ffffff",
                        () => {
                            if (
                                user.is_stripe_key &&
                                user.is_personnel_file_status == 2
                            ) {
                                this.next(
                                    data.is_mileage_paid
                                        ? "mileagePaid"
                                        : "bidRate",
                                    "Bid",
                                    data
                                );
                            } else {
                                this.checkProfileNAccountValidation(
                                    "bid or send"
                                );
                            }
                        }
                    )}
                {this.renderModal()}

                <Supporticon
                    clickBtn={() => push("Support")} />

            </Fragment>
        );
    }
}

const actions = { generalAction, notificationBar, generalSaveAction };
const mapStateToProps = ({ user, infoContent }, ownProps) => {
    return {
        user: user.data,
        data: selectPostDetails(ownProps),
        note: infoContent.data.content
    };
};

const DetailComponentCompose = compose(
    connect(mapStateToProps, actions)(WithFetching(AvailableJobsDetail))
);

export default DetailComponentCompose;

DetailComponentCompose.navigationOptions = ({ navigation }) => {
    const { state } = navigation;
    const params = state.params || {};
    return {
        headerStyle: styles.header,
        headerRight: (
            <View style={{ flexDirection: "row" }}>
                {params.boo && (
                    <TouchableOpacity
                        onPress={params.showInfo}
                    >
                        <Image
                            style={{ margin: 10 }}
                            resizeMode="contain"
                            source={icons.ic_info}
                        />
                    </TouchableOpacity>
                )}
            </View>
        )
    };
};