import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";

export default StyleSheet.create({

    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.cardColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    separatorStyle: {
        backgroundColor: "#dde3f6",
        marginHorizontal: 20,
        marginVertical: 10
    },
    descriptionStyle: {
        ...UIFont.font(fonts.regular, fontSize.xSmall, colors.BlackColor),
        marginHorizontal: 20,
        lineHeight: 22,
        letterSpacing: 0
    },
    boldText: {
        ...UIFont.font(fonts.regular, 18, colors.BlackColor),
        marginTop: 10,
        marginBottom: 10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 22,
        letterSpacing: 0
    },
    locationStyle: {
        ...UIFont.font(fonts.regular, 12, "#525252"),
        marginTop: 10,
        marginBottom: 20,
        marginHorizontal: 20,
        lineHeight: 14,
        letterSpacing: 0
    },
    mapStyle: {
        backgroundColor: "white",
        marginBottom: 60,
        height: 200,
        paddingHorizontal: 20,
        justifyContent: "center",
        alignItems: "center",
        borderRadius: 6
    },
    modalContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
    textColor: {
        ...UIFont.font(fonts.regular, fontSize.medium, "#343434")
    },
    modalInner: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "rgba(0,0,0,0.5)"
    },
    mileageBidLabelStyle: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor),
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    eachView: {
        borderRadius: 5,
        borderStyle: "solid",
        borderWidth: 1,
        borderColor: "#dde3f6",
        alignItems: "center",
        justifyContent: "center",
        height: 40
    },
    firstText: {
        ...UIFont.font(fonts.regular, 9, colors.CardDate),
        lineHeight: 11,
        letterSpacing: 0
    },
    txtContract: {
        ...UIFont.font(fonts.semiBold, 16, colors.CardDate)
    },
    defaultStyle: {
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        paddingRight: 10
    },
    ViewLabelButton: {
        justifyContent: "center",
        alignItems: "center"
    },
    footerStyle: {
        position: "absolute",
        justifyContent: "flex-end",
        alignItems: "center",
        paddingHorizontal: 10
    },
    textStyle: {
        ...UIFont.font(fonts.reqular, 15, colors.BlackColor)
    }
});
