import React, { Component } from "react";
import _ from "lodash";
import { View, Text, Image, TouchableOpacity, ScrollView, TextInput } from "react-native";
import { Input } from "../../components";
import ActionSheet from "react-native-actionsheet";
import PhoneInput from "react-native-phone-input";
import moment from "moment";
import DateTimePicker from '@react-native-community/datetimepicker';
import DatePicker from "react-native-datepicker";
import { Images, icons,  colors } from "../../assets";
import { FooterDetail, Separator, AppButton, Supporticon } from "../../components";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { connect } from "react-redux";
import {
    API_ALL_STATES,
    API_ALL_CITIES,
    API_ADD_ACCOUNT_INFO,
} from "../../services/WebService";
import { compose } from "redux";
import { DUMP, USER } from "../../actions/ActionTypes";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import Stripe from "../../services/Stripe";
import { WithFetching,  } from "../../HOC";
import styles from "./styles";
import Utils from "../../Utils";
import axios from 'axios';
import Colors from "../../services/Colors";
import { pop, popToTop, push } from "../../services/NavigationService";
import { GooglePlacesAutocomplete, } from 'react-native-google-places-autocomplete';    //2.4.1
import  { StripeProvider } from "@stripe/stripe-react-native";

class BankDetailsRegister extends Component {
    constructor(props) {
        super(props);

        const { user } = this.props;

        this.state = {
            firstName: "",
            lastName: "",
            showdate: false,
            email: user.email,
            user_id:this.props.route.params.user_ID,
            publishableKey: 'pk_live_T1oI7ll9MxdhDp8KaY2je5BY',
            postalCode: "",
            street: "",
            ssnNumber: "",
            mobilePhone: user.mobile_no,
            dob: user.dob,
            indexState: 0,
            states: [{ value: "Select State", id: 0 }, { value: "cancel" }],
            indexCities: 0,
            cities: [{ value: "Select City", id: 0 }, { value: "cancel" }],
            country_id: 231,
            city_id: 0,
            state_id: 0,
            isError: false,
            bankAccountNumber: "",
            routingNumber: "",
            state_name: "",
            city_name: "",
            address: null,
            lat: null,
            lng: null,

        };


    }


    componentDidMount() {

        this.fetchStates();

    }

    fetchStates() {
        this.props.generalAction(
            `${API_ALL_STATES}?country_id=${this.state.country_id}`,
            {},
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.fetchStatesSuccess,
            this.fetchStatesFailure,
            true
        );
    }

    fetchStatesSuccess = (res) => {
        let states = [];
        states = res.map((elem) => {
            return {
                value: elem.state_name,
                id: elem.state_id,
            };
        });
        states.unshift({ value: "Select State", id: 0 });
        states.push({ value: "cancel" });
        this.setState({ states });
    };

    fetchStatesFailure = (err) => { };

    fetchCities(state_id) {
        this.props.generalAction(
            `${API_ALL_CITIES}?state_id=${state_id}`,
            {},
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.fetchCitiesSuccess,
            this.fetchCitiesFailure,
            true
        );
    }

    fetchCitiesSuccess = (res) => {
        let cities = [];
        cities = res.map((elem) => {
            return {
                value: elem.name,
                id: elem.city_id,
            };
        });
        cities.unshift({ value: "Select City", id: 0 });
        cities.push({ value: "cancel" });
        this.setState({ cities });
    };

    fetchCitiesFailure = (err) => { };

    showActionSheet = (func) => {
        func.show();
    };

    submitDetails = () => {
        const {
            firstName,
            lastName,
            mobilePhone,
            email,
            dob,
            state_id,
            city_id,
            postalCode,
            street,
            ssnNumber,
            user_id
        } = this.state;

        if (
            firstName &&
            lastName &&
            mobilePhone &&
            email &&
            dob &&
            postalCode &&
            street &&
            ssnNumber &&
            this.accountInfo.getValue().length > 0 &&
            this.routingNumber.getValue().length > 0
        ) {
        // this.props.parentShowLoader();


         this.props.cbShowLoader(true);

        let params = {
            accountNumber: this.accountInfo.getValue(),
            routingNumber: this.routingNumber.getValue(),
            country: 'US',
            type: 'BankAccount',
            currency: 'usd',
        };

        Stripe.getStripTokenFromAccount(
            params,
            (response) =>
                this.makingPayload(response.id, user_id),
            this.onAccountTokenFailure
        );

        } else {


            this.setState({ isError: true });

        }

    };

    makingPayload = (stripe_key, user_id) => {
        this.props.cbShowLoader(false);
        const {
            firstName,
            lastName,
            mobilePhone,
            email,
            dob,
            address,
            postalCode,
            street,
            ssnNumber,
            state_name,
            city_name,
        } = this.state;

        let payload = new FormData();
        payload.append("user_id", user_id);
        payload.append("stripe_key", stripe_key);
        payload.append("first_name", firstName);
        payload.append("last_name", lastName);
        payload.append("phone", mobilePhone);
        payload.append("dob", dob);
        payload.append("state", state_name);
        payload.append("city", city_name);
        payload.append("postal_code", postalCode);
        payload.append("address", address);
        payload.append("street", street);
        payload.append("ssn", ssnNumber);
        payload.append("email", email);
        payload.append("info_type", "bank_account");

        this.onAccountTokenSuccess(payload);
        //api will call here
        
        this.props.cbShowLoader(true);

    };

    onAccountTokenSuccess = (payload) => {
        this.props.generalAction(
            API_ADD_ACCOUNT_INFO,
            payload,
            USER.SUCCESS,
            USER.FAILURE,
            (user) => {
                this.props.cbShowLoader(false);

                Utils.setUserToken(user.token);
                Utils.setUserType(user.user_type);
                Utils.setUserLoggedIn(true);
                Utils.showMessage(
                    "Success",
                    "Account details submitted successfully",
                    "success"
                );

                push("contractorStack", { user });
            },
            (err) => {
               
                Utils.showError(err);
                this.props.cbShowLoader(false);
            }
        );
    };
    onAccountTokenFailure = (err) => {

        this.props.cbShowLoader(false);
        setTimeout(() => {
            Utils.showMessage(
                "Error",
                "Unable to verify account. Check account details."
            );
        }, 1000);
    };
    renderError(err, obj = { marginTop: 4 }) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    inputField(placeholder, state, keyboardType = "default") {


        return (
            <View style={{ paddingHorizontal: 16 }}>
                <Input
                    blurOnSubmit={false}
                    value={this.state[state]}
                    placeholder={placeholder}
                    returnKeyType="next"
                    keyboardType={keyboardType}
                    style={{ padding: 0, marginTop: 12 }}
                    cbOnChangeText={(txt) => this.setState({ [state]: txt })}
                    autoCapitalize="none"
                />
                <Separator style={{ backgroundColor: "#cecece" }} />
                {!this.state[state] &&
                    this.renderError(`${placeholder} is required`)}
            </View>
        );
    }

    phoneNumberField() {
        const { mobilePhone } = this.state;
        return (
            <View style={{ marginTop: 12 }}>
                <PhoneInput
                    style={styles.txtInputStyle}
                    
                    initialValue={mobilePhone}
                    textProps={{ maxLength: 20 }}
                    onChangePhoneNumber={(text) =>
                        this.setState({ mobilePhone: text })
                    }
                    initialCountry={'us'}
                    ref={(ref) => {
                        this.phone = ref;
                    }}
                />
                {!mobilePhone && this.renderError(`Mobile Number is required`)}
            </View>
        );
    }

    datePicker() {
        const { dob } = this.state;
        return (
            <View style={{ paddingHorizontal: 16, marginTop: 16 }}>
                <DatePicker
                    // style={styles.datePickerInput}
                    date={dob}
                    mode={"date"}
                    placeholder={"Date of Birth"}
                    format={"YYYY-MM-DD"}
                    maxDate={moment().format("YYYY-MM-DD")}
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    showIcon={false}
                    customStyles={{
                        dateInput: styles.dateInput,
                        dateText: { color: "#241332" },
                    }}
                    onDateChange={(dob) => this.setState({ dob })}
                />
                <Separator style={{ backgroundColor: "#cecece" }} />
                {!dob && this.renderError(`Date of Birth is required`)}
            </View>
        );
    }

    getAdd(data) {

        this.setState(
            {
                address: data.description,
                street: data.structured_formatting.main_text
            }
        );


        var place_id = data.place_id;
        let self = this;

        axios.get('https://maps.googleapis.com/maps/api/place/details/json?place_id=' + place_id + '&fields=formatted_address,address_components&key=AIzaSyBMA898rbtiQ3aU0aINY7aVjtFKm_v42NA', {
        })
            .then(function (response) {


                for (let i = 0; i < response.data.result.address_components.length; i++) {

                    if (response.data.result.address_components[i].types[0] === "administrative_area_level_2") {

                        var city_val = response.data.result.address_components[i].long_name;

                        self.setState({ city_name: city_val });

                    } else if (response.data.result.address_components[i].types[0] === "administrative_area_level_1") {

                        var state_val = response.data.result.address_components[i].long_name;

                        self.setState({ state_name: state_val });

                    } else if (response.data.result.address_components[i].types[0] === "postal_code") {

                        var pincode_val = response.data.result.address_components[i].long_name;

                        self.setState({ postalCode: pincode_val });

                    }

                }

            })
            .catch(function (error) {
                console.log(error);
            })



    }

    datePickerandorid() {
        const { dob } = this.state;
        return (

            <View>

                <DateTimePicker
                    style={{
                        borderBottomWidth: 1,
                        borderColor: Colors.textfieldBorder,
                        width: Platform.OS ? 345 : 350
                    }}
                    date={dob}
                    mode={'date'}
                    dateFormat="YYYY-MM-DD"
                    maximumDate={new Date()}
                    value={new Date()}
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    is24Hour={true}
                    customStyles={{
                        dateInput: {
                            borderWidth: 0,
                            justifyContent: "flex-start",
                            alignItems: "flex-start",
                            paddingTop: 6,
                            paddingLeft: 10
                        },
                        dateText: {
                            color: "#241332"
                        }
                    }}
                    onChange={this.handleChangeAndroid}

                />

            </View>
        );
    }

    handleChangeAndroid = (event, selectedDate) => {

        const dateset = moment(selectedDate).format("YYYY-MM-DD");

        const age = moment().diff(moment(dateset), 'years');

        if (age > 20) {

            this.setState({ showdate: false });
            this.setState({ dob: dateset });
        }
        else {

            Utils.showError("Please select 21 years above");


        }

    }

    userDetailCard() {
        return (
            <View elevation={15} style={styles.inputWrapper}>
                {this.inputField("First Name", "firstName")}
                {this.inputField("Last Name", "lastName")}
                {this.phoneNumberField()}
                {this.inputField("Email", "email")}

                {Utils.isPlatformAndroid ?
                        <TouchableOpacity style={styles.viewstyle}
                            onPress={showdate => {
                                this.setState({ showdate: true });
                            }}>

                            <View style={styles.passwordContainer}>
                                <TextInput
                                    style={styles.inputStyle}
                                    editable={false}
                                    selectTextOnFocus={false}
                                    placeholder="Date of Birth"
                                    value={this.state.dob}
                                />
                                <Image style={styles.ImageStyle}
                                    source={icons.reg_calendar}
                                    size={10}
                                />
                            </View>
                        </TouchableOpacity> :
                       this.datePicker()
                    }
               

               {this.state.showdate == true ?
                        this.datePickerandorid() : null}

                    {(!this.state.dob || this.state.dob >= moment().format("YYYY-MM-DD")) &&
                        this.renderError(
                            !this.state.dob
                                ? "Date of Birth is required"
                                : "The date is not valid",
                            {}
                    )}

                <GooglePlacesAutocomplete
                    placeholder='Bank Address'
                    minLength={2} // minimum length of text to search
                    keyboardShouldPersistTaps={'handled'}
                    returnKeyType={'default'}
                    onPress={(data, details = null) => {

                        var data = details;
                        this.getAdd(data);

                    }}

                    onFail={(error) => console.error("errorPlaces", error)}
                    textInputProps={{
                        onChangeText: (text) => {

                            if (text > 0) {

                            }
                            else {

                                this.setState({ postalCode: "" });
                                this.setState({ state_name: "" });
                                this.setState({ city_name: "" });
                            }
                        },
                    }}
                    styles={{
                        textInput: {
                            marginStart: 10,
                            marginEnd: 10,
                            marginTop: 10,
                            backgroundColor: '#FFFFFF',

                        },
                        textInputContainer: {
                            width: '100%',
                            marginTop: 10,
                            backgroundColor: '#FFFFFF',
                            borderTopColor: '#FFFFFF',
                            borderBottomColor: '#FFFFFF',
                        },
                        description: {
                            fontWeight: 'bold',
                            backgroundColor: '#FFFFFF',

                        },
                        predefinedPlacesDescription: {
                            color: '#1faadb',
                            backgroundColor: '#FFFFFF',
                        }
                    }}

                    getDefaultValue={() => {
                        return ""; // text input default value
                    }}

                    predefinedPlacesAlwaysVisible={true}
                    query={{
                        key: 'AIzaSyBMA898rbtiQ3aU0aINY7aVjtFKm_v42NA',
                        language: 'en',

                    }}
                />

                <Separator style={{
                    backgroundColor: "#cecece", marginStart: 15,
                    marginEnd: 10,
                }} />
                {/* <script src="https://maps.googleapis.com/maps/api/js?libraries=places&key=AIzaSyBMA898rbtiQ3aU0aINY7aVjtFKm_v42NA"  */}
                {!this.state.address &&
                    this.renderError(`Address is required`)}

                <TextInput
                    style={{
                        padding: 0,
                        marginEnd: 10,
                        marginTop: 30, paddingHorizontal: 16
                    }}

                    placeholder="State"
                    blurOnSubmit={false}
                    autoCapitalize="none"
                    returnKeyType="next"
                    placeholderTextColor={"#a5a8af"}
                    value={this.state.state_name}
                    onChangeText={(entry) => {
                        this.setState({
                            state_name: entry
                        })
                    }}
                />
                <Separator style={{
                    backgroundColor: "#cecece", marginStart: 15,
                    marginEnd: 10,
                    marginTop: 10,
                }} />
                {!this.state.state_name &&
                    this.renderError(`State is required`)}


                <TextInput
                    style={{
                        padding: 0,
                        marginEnd: 10,
                        marginTop: 30, paddingHorizontal: 16
                    }}
                    placeholder="City"
                    blurOnSubmit={false}
                    autoCapitalize="none"
                    returnKeyType="next"
                    placeholderTextColor={"#a5a8af"}
                    value={this.state.city_name}
                    onChangeText={(entry) => {
                        this.setState({
                            city_name: entry
                        })
                    }}
                />
                <Separator style={{
                    backgroundColor: "#cecece", marginStart: 15,
                    marginEnd: 10,
                    marginTop: 10,
                }} />
                {!this.state.city_name &&
                    this.renderError(`City is required`)}

                <TextInput
                    style={{
                        padding: 0,
                        marginEnd: 10,
                        marginTop: 30, paddingHorizontal: 16
                    }}
                    placeholder="Postal Code"
                    blurOnSubmit={false}
                    keyboardType='numeric'
                    autoCapitalize="none"
                    returnKeyType="next"
                    placeholderTextColor={"#a5a8af"}
                    value={this.state.postalCode}
                    onChangeText={(entry) => {
                        this.setState({
                            postalCode: entry
                        })
                    }}
                />
                <Separator style={{
                    backgroundColor: "#cecece", marginStart: 15,
                    marginEnd: 10,
                    marginTop: 10,
                }} />
                {!this.state.postalCode &&
                    this.renderError(`postalCode is required`)}

                <TextInput
                    style={{
                        padding: 0,
                        marginEnd: 10,
                        marginTop: 30, paddingHorizontal: 16
                    }}
                    placeholder="Street"
                    blurOnSubmit={false}
                    autoCapitalize="none"
                    returnKeyType="next"
                    placeholderTextColor={"#a5a8af"}
                    value={this.state.street}
                    onChangeText={(entry) => {
                        this.setState({
                            street: entry
                        })
                    }}
                />
                <Separator style={{
                    backgroundColor: "#cecece", marginStart: 15,
                    marginEnd: 10,
                    marginTop: 10,
                    marginBottom: 20
                }} />
                {!this.state.state_name &&
                    this.renderError(`Street is required`)}
                {this.inputField("SSN Last 4 Digits", "ssnNumber", "numeric")}
            </View>
        );
    }

    dropDown(arr, index, stateName, func, callBack) {
        return (
            <View style={{ paddingHorizontal: 16 }}>
                <TouchableOpacity
                    style={[styles.categoryStyle, styles.actionSheetView]}
                    onPress={() =>
                        stateName === "indexCities" && this.state.state_id == 0
                            ? alert("Please select state first")
                            : this.showActionSheet(func)
                    }
                >
                    <Text
                        style={
                            index == 0
                                ? styles.zeroIndexCategoryStyle
                                : styles.textCategoryStyle
                        }
                    >
                        {arr[index].value}
                    </Text>
                    <Image source={icons.ic_expand} />
                </TouchableOpacity>

                <Separator style={{ backgroundColor: "#cecece" }} />
                <ActionSheet
                    ref={(o) => (func = o)}
                    options={arr.map((elem) => elem.value)}
                    cancelButtonIndex={arr.length - 1}
                    onPress={(i) => {
                        if (i !== arr.length - 1 && i !== 0) {
                            callBack(i);
                        }
                    }}
                />
                {this.state[stateName] === 0 &&
                    this.renderError(
                        `${stateName == "indexState" ? "State" : "City"
                        } is required`
                    )}
            </View>
        );
    }

    footer() {
        return (
            <FooterDetail
                style={{ marginTop: 10, marginBottom: 50 }}
                text={"Submit"}
                backgroundColor={{ backgroundColor: "#08548c" }}
                textColor={{ color: "#ffffff" }}
                clickBtn={this.submitDetails}
            />
        );
    }

    bankAccountCard() {
        const { bankAccountNumber, routingNumber } = this.state;
        return (
            <View
                elevation={15}
                style={[styles.inputWrapper, { paddingHorizontal: 16 }]}
            >
                <Input
                    ref={(ref) => (this.accountInfo = ref)}
                    placeholder="Bank account number"
                    type={INPUT_TYPES.TEXT}
                    identifier="bankAccountNumber"
                    keyboardType="number-pad"
                    style={{ padding: 0, marginTop: 12 }}
                    blurOnSubmit={() => Keyboard.dismiss}
                    value={bankAccountNumber}
                    cbOnChangeText={(txt) =>
                        this.setState({ bankAccountNumber: txt })
                    }
                />
                <Separator style={{ backgroundColor: "#cecece" }} />
                {!bankAccountNumber &&
                    this.renderError(`A valid account number is required`)}
                <Input
                    ref={(ref) => (this.routingNumber = ref)}
                    placeholder="Routing Number"
                    type={INPUT_TYPES.TEXT}
                    identifier="routingNumber"
                    maxLength={9}
                    keyboardType="number-pad"
                    style={{ padding: 0, marginTop: 12 }}
                    blurOnSubmit={() => Keyboard.dismiss}
                    value={routingNumber}
                    cbOnChangeText={(txt) =>
                        this.setState({ routingNumber: txt })
                    }
                />
                <Separator style={{ backgroundColor: "#cecece" }} />
                {!routingNumber &&
                    this.renderError(`A valid routing number is required`)}

                <Text style={{ marginHorizontal: 20, marginVertical: 40 }}>
                    "MedicaShift LLC only uses this information to deposit your
                    earnings to your Bank Account"
                </Text>
            </View>
        );
    }

    render() {


        return (
            <View style={{ flex: 1 }}>
                <StripeProvider
                    publishableKey={this.state.publishableKey}
                    merchantIdentifier="merchant.identifier">

                    <ScrollView style={styles.container} keyboardShouldPersistTaps={'handled'}>
                        {this.userDetailCard()}


                        {this.bankAccountCard()}
                        {/* {this.footer()} */}

                        <View style={{
                            flexDirection: "row", alignItems: 'center', alignSelf: 'center',
                            alignContent: 'center'
                        }}>
                            <View style={styles.buttonStyleback}>
                                <AppButton
                                    buttonTitle="Back"
                                    style={{
                                        backgroundColor: "#d45404",
                                        width: "100%", alignItems: 'center'
                                    }}
                                    btnColor="#d45404"
                                    onPress={() => {
                                        popToTop();
                                    }}
                                />
                            </View>
                            <View style={styles.buttonStyle}>
                                <AppButton
                                    buttonTitle="Finish"
                                    style={{
                                        backgroundColor: colors.ActiveTabTitle,
                                        width: "100%", alignItems: 'center'
                                    }}
                                    btnColor={colors.cardColor}
                                    onPress={() => {
                                        this.submitDetails();
                                    }}

                                />

                            </View>
                        </View>
                    </ScrollView>
                </StripeProvider>
                <Supporticon
                    clickBtn={() => push("Support")} />
            </View>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ user, networkInfo }) => {


    return { user: user.data, networkInfo };
};

const ComponentWithComposeFunc = compose(
    connect(
        mapStateToProps,
        actions
    )(WithFetching(BankDetailsRegister))
);

export default ComponentWithComposeFunc;

ComponentWithComposeFunc.navigationOptions = ({ navigation }) => {
    return {
        title: "Bank Details",
        headerStyle: styles.header,
        headerTitleStyle: styles.toolbarTitle,
        headerLeft: (
            <TouchableOpacity onPress={() => popToTop()}>
                <Image
                    style={{ margin: 10 }}
                    resizeMode="contain"
                    source={Images.backArrow}
                />
            </TouchableOpacity>
        ),
        headerRight: (
            <View
                style={{
                    backgroundColor: colors.HeaderColor,
                    width: "10%"
                }}
            />
        )
    };
};