import { StyleSheet } from "react-native";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";
import { UIFont, fontSize, fonts, colors } from "../../assets";

export default StyleSheet.create({

    container: {
        flex: 1,
        padding: 16
    },
    inputWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.4,
        shadowRadius: 2,
        shadowOffset: {
            height: 2,
            width: 2
        },
        paddingVertical: 10,
        marginBottom: 20
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start",
    },
    txtInputStyle: {
        minHeight: 50,
        fontSize: 20,
        color: "#000",
        borderRadius: 10,
        paddingLeft: 15,
        paddingBottom: 5,
        marginBottom: 10,
        paddingRight: 15,
        marginHorizontal: 10,
        alignSelf: "stretch",
        flex: 1,
        borderColor: "#dddddd",
        borderBottomWidth: 1
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6,
        marginHorizontal: 10
    },
    categoryStyle: {
        // width: "90%",
        flexDirection: "row",
        height: 60,
        alignItems: "center"
    },
    actionSheetView: {
        justifyContent: "space-between",
    },
    zeroIndexCategoryStyle: {
        ...UIFont.font(fonts.reqular, 15, Colors.textfieldBorder),
        letterSpacing: 0
    },
    textCategoryStyle: {
        ...UIFont.font(fonts.reqular, 15, "#040404"),
        letterSpacing: 0
    },
    buttonStyle: {
        width: "40%",
        alignItems: 'center',
        marginLeft: 10,
        marginBottom: 30
    },

    buttonStyleback: {
        width: "40%",
        alignItems: 'center',
        marginRight: 10,
        marginBottom: 30
    },
    toolbarTitle: {
        color: colors.WhiteColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },

    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,

        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    passwordContainer: {
        flexDirection: 'row',
        borderBottomWidth: 1,
        borderColor: Colors.textfieldBorder,
        paddingBottom: 10,
    },
    inputStyle: {
        flex: 1,
        color: colors.BlackColor,
    },
    viewstyle: {
        flex: 1,
        flexDirection: "row",
        marginStart: 15,
        marginEnd: 15,
        marginTop: 10,
        alignItems: "center",

    },
    ImageStyle: {
        padding: 10,
        margin: 5,
        height: 30,
        width: 30,
        resizeMode: 'stretch',
        alignItems: 'center',
    },
});
