import React, { Component } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    StyleSheet,
    TextInput,
    Platform
} from "react-native";
import Metrics from "../../services/Metrics";
import { TextLabel, FooterDetail, } from "../../components";
import { pop } from "../../services/NavigationService";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { API_PERCENTAGE } from "../../services/WebService";
import { DUMP, ADMIN_FEE_AMOUNT } from "../../actions/ActionTypes";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { WithFetching } from "../../HOC";
import { compose } from "redux";
import { connect } from "react-redux";
import Utils from "../../Utils";

class BidRate extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={icons.ic_arrow_backward_black}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };

    state = {
        totalBidAmount: 0,
        bidRate: 0,
        percentageRate: 0
    };
    componentDidMount() {
        this.getPercentageValue();
    }
    getPercentageValue = () => {
        this.props.cbShowLoader(true);
        this.props.generalAction(
            API_PERCENTAGE,
            null,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbSuccess,
            this.cbFailure,
            true
        );
    }
    cbSuccess = (response) => {
        const { percentage_value } = response;
        this.props.cbShowLoader(false);
        this.setState({
            percentageRate: percentage_value
        });
        this.props.generalSaveAction(ADMIN_FEE_AMOUNT, { amount: percentage_value });
        Utils.setAdminFee(percentage_value);
    }
    cbFailure = (response) => {
        this.props.cbShowLoader(false);
    }

    popToPreviousScreen = () => {
        const { cbOnApplyFilters, screen } = this.props.route.params;
        cbOnApplyFilters && cbOnApplyFilters(this.state);
        screen == "mileagePaid" ? pop(2) : pop();
    };

    heading(label, labelStyle) {
        return <TextLabel style={labelStyle}>{label}</TextLabel>;
    }

    footer(style, text, bgColor, textColor, callBack) {
        return (
            <FooterDetail
                style={style}
                text={text}
                backgroundColor={bgColor}
                textColor={{ color: textColor }}
                clickBtn={callBack}
            />
        );
    }

    renderError() {
        const { percentageRate } = this.state;
        const { data } = this.props.route.params;
        return (
            <Text style={styles.error}>{`${data.admin_percent}% Administration fee will be applied.`}</Text>
        );
    }

    onChangeText = bidRate => {
        const {
            shift_end_time,
            shift_start_time,
            contract_type,
            total_hours
        } = this.props.route.params;
        let totalBidAmount;

        if (contract_type === "Contract") {
            totalBidAmount = bidRate;
        } else {
            totalBidAmount =
                total_hours == 0 ? bidRate : total_hours * +bidRate;
        }
        this.setState({ totalBidAmount, bidRate });
    };

    inputText(contract_type, isError = false) {
        return (
            <View
                style={{
                    flexDirection: "row",
                    alignItems: "center",
                    width: "96%",
                    borderBottomColor: "#959dad",
                    borderBottomWidth: 1,
                    paddingBottom: 0
                }}
            >
                <TextInput
                    style={[
                        styles.textInputStyle,
                        isError ? { borderColor: "#f44336" } : {}
                    ]}
                    onChangeText={this.onChangeText}
                    placeholder={
                        contract_type === "Contract"
                            ? "hourly rate"
                            : "hourly rate"
                    }
                    keyboardType="numeric"
                    value={this.state.bidRate}
                    autoCapitalize="none"
                />
                <Image
                    resizeMode="contain"
                    source={icons.ic_dollar}
                    style={{}}
                    width={Metrics.images.small}
                    height={Metrics.images.small}
                />
            </View>
        );
    }

    render() {
        const { totalBidAmount } = this.state,
            { contract_type, admin_percent } = this.props.route.params;

        return (
            <View style={styles.container}>
                {this.heading(
                    `Enter the ${
                    contract_type === "Contract"
                        ? "hourly rate"
                        : "hourly rate"
                    } you are willing`,
                    [styles.categoryLabel, { marginBottom: -5 }]
                )}
                {this.heading("to work for", [
                    styles.categoryLabel,
                    { marginBottom: -5 }
                ])}
                <View style={styles.inputPart}>
                    {this.inputText(contract_type)}
                </View>
                
                <View style={{ flex: 1, marginTop: 10 }}>
                    {this.renderError()}
                </View>
                {this.footer(
                    [styles.footerStyle, { bottom: 55 }],
                    `Total: $${parseFloat(totalBidAmount).toFixed(2)}`,
                    {
                        backgroundColor: "#959dad"
                    },
                    colors.BlackColor,
                    () => null
                )}
                {this.footer(
                    [styles.footerStyle, { bottom: 0 }],
                    "NEXT",
                    {
                        backgroundColor: "#08548c"
                    },
                    "#ffffff",
                    this.popToPreviousScreen
                )}
            </View>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = (state) => {
    return {
        user: state.user.data
    };
};

const BidRateCompose = compose(
    connect(mapStateToProps, actions)(WithFetching(BidRate))
);
export default BidRateCompose;

const styles = StyleSheet.create({
    headerTitle: {
        color: colors.BlackColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.cardColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    container: {
        flex: 1,
        backgroundColor: colors.cardColor
    },
    categoryLabel: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor),
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    inputPart: {
        marginTop: 20,
        justifyContent: "center",
        alignItems: "center"
    },
    footerStyle: {
        position: "absolute",
        justifyContent: "flex-end",
        alignItems: "center",
        paddingHorizontal: 10
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start",
        paddingHorizontal: 20
    },
    textInputStyle: {
        ...UIFont.font(fonts.reqular, fontSize.small, "#241332"),
        paddingRight: Metrics.baseMargin,
        letterSpacing: 0,
        padding: Platform.OS && 15,
        flex: 1
    }
});
