import React, { Component } from "react";
import {
    TextInput,
    StyleSheet,
    Text,
    View,
    Image,
    SectionList,
    TouchableOpacity
} from "react-native";
import { ImageButton, TextLabel,Supporticon } from "../../components";
import { icons, UIFont, fonts, fontSize, colors } from "../../assets";
import ListEmpty from "../../components/FlatListHandler/ListEmpty";
import { push } from "../../services/NavigationService";
import { connect } from "react-redux";

class Category extends Component {
    static navigationOptions = ({ navigation }) => {
        const { state } = navigation;
        const params = state.params || {};
        return {
            headerStyle: styles.header,
            headerRight: (
                <ImageButton
                    source={icons.search_icon_black}
                    onPress={params.filterCategories}
                />
            )
        };
    };
    constructor(props) {
        super(props);
        this.filterCategories = this.filterCategories.bind(this);
        this.state = {
            category: [
                {
                    title: "Doctors",
                    data: [
                        "Physician Assistant",
                        "Nurse Practitioner",
                        "Doctor"
                    ]
                },
                {
                    title: "Nursing",
                    data: [
                        "RN",
                        "LPN",
                        "Home Health Aide",
                        "Certified Nursing Assistant",
                        "Certified Medication Assistant"
                    ]
                },
                { title: "Therapy and Rehab", data: ["PT", "OT"] },
                { title: "Therapy Assistants", data: ["CPTA", "COTA"] },
                { title: "Surgical Techs", data: [] },
                { title: "Imaging and Radiology", data: [] },
                { title: "Respiratory Professionals", data: [] },
                { title: "Administration and Executives", data: [] }
            ],
            showInput: false
        };
    }

    componentDidMount() {
        this.props.navigation.setParams({
            filterCategories: this.filterCategories
        });
        this.fetchCategories();
    }

    fetchCategories() {
        const { categories } = this.props;
        let category = [];
        categories.map(elem => {
            if (elem.child_categories_count === "0") {
                category.push({
                    title: elem.parent_category.category_name,
                    data: []
                });
            }
            if (typeof elem.child_categories_count == "number") {
                category.push({
                    title: elem.parent_category.category_name,
                    data: elem.child_categories.map(el => el.category_name)
                });
            }
        });
        this.setState({ allCategory: category, category });
    }

    filterCategories = () => {
        this.setState({ showInput: true });
    };

    GetSectionListItem = item => {
        let data = this.props.route.params.goTo;
        let category_id = 0;
        this.props.categories.map(elem => {
            if (elem.parent_category.category_name === item) {
                category_id = elem.parent_category.id;
            } else {
                elem.child_categories &&
                    elem.child_categories.map(el => {
                        if (el.category_name === item) {
                            category_id = el.id;
                        }
                    });
            }
        });
        push("postShift", { item, data, category_id });
    };

    labelText = (label, textStyle, color) => {
        return (
            <TextLabel emailColor={color} style={textStyle}>
                {label}
            </TextLabel>
        );
    };

    onChangeText = txt => {
        let { allCategory } = this.state;
        category = [];
        allCategory.map(elem => {
            if (elem.title.toLowerCase().includes(txt.toLowerCase())) {
                category.push(elem);
            } else {
                elem.data.map(el => {
                    if (el.toLowerCase().includes(txt.toLowerCase())) {
                        category.push(elem);
                    }
                });
            }
        });
        this.setState({ category });
    };

    renderInput() {
        return (
            <View style={{ marginHorizontal: 10, flexDirection: "row" }}>
                <TextInput
                    style={styles.textInputStyle}
                    onChangeText={this.onChangeText}
                    value={this.state.val}
                    autoCapitalize="none"
                />
                <TouchableOpacity
                    style={{
                        alignSelf: "center",
                        width: "15%",
                        height: 40,
                        justifyContent: "center"
                    }}
                    onPress={() => {
                        this.fetchCategories();
                        this.setState({ showInput: false });
                    }}
                >
                    <Image source={icons.ic_cross} />
                </TouchableOpacity>
            </View>
        );
    }

    renderSectionHeader = ({ section }) => {
        let sectionStyle =
            section.data.length == 0
                ? styles.singleSectionHeader
                : styles.sectionHeader;
        return (
            <TouchableOpacity
                onPress={() =>
                    section.data.length == 0
                        ? this.GetSectionListItem(section.title)
                        : null
                }
            >
                {this.labelText(section.title, sectionStyle, "#08548c")}
            </TouchableOpacity>
        );
    };

    renderItem = ({ item, index, section: { data } }) => {
        const { lastSectionListItem, sectionListItemS } = styles;
        return (
            <Text
                style={
                    data.length - 1 == index
                        ? lastSectionListItem
                        : sectionListItemS
                }
                onPress={this.GetSectionListItem.bind(this, item)}
            >
                {item}
            </Text>
        );
    };

    renderListEmpty = () =>
        !this.state.category.length ? <ListEmpty /> : null;

    render() {
        return (
            <View style={styles.container}>
                {this.labelText("Categories", styles.mainHeading, "#000000")}
                {this.state.showInput && this.renderInput()}
                {this.state.category.length ? (
                    <SectionList
                        sections={this.state.category}
                        renderSectionHeader={this.renderSectionHeader}
                        renderItem={this.renderItem}
                        keyExtractor={(item, index) => index}
                    />
                ) : (
                    <View style={{ height: "85%" }}>
                        {this.renderListEmpty()}
                    </View>
                )}

<Supporticon
                 clickBtn={() =>push("Support")}/> 
            </View>
        );
    }
}

const mapStateToProps = ({ categories }) => {
    return {
        categories: categories.data
    };
};

export default connect(mapStateToProps, null)(Category);

const styles = StyleSheet.create({
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#f7f7f7",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    container: {
        flex: 1,
        justifyContent: "center",
        backgroundColor: colors.TabsWrapper,
        paddingBottom: 10
    },
    mainHeading: {
        ...UIFont.font(fonts.regular, fontSize.xxLarge, colors.BlackColor),
        lineHeight: 26,
        letterSpacing: 0,
        marginTop: 10,
        marginLeft: 10
    },
    sectionHeader: {
        ...UIFont.font(fonts.semiBold, fontSize.small, colors.ActiveTabTitle),
        lineHeight: 17,
        letterSpacing: 0,
        backgroundColor: colors.cardColor,
        marginTop: 10,
        marginBottom: 0,
        paddingVertical: 20,
        marginHorizontal: 10,
        paddingHorizontal: 20,
        borderTopLeftRadius: 6,
        borderTopRightRadius: 6
    },
    singleSectionHeader: {
        ...UIFont.font(fonts.semiBold, fontSize.small, colors.ActiveTabTitle),
        lineHeight: 17,
        letterSpacing: 0,
        backgroundColor: colors.cardColor,
        marginTop: 10,
        marginBottom: 0,
        paddingVertical: 20,
        marginHorizontal: 10,
        paddingHorizontal: 20,
        borderTopLeftRadius: 6,
        borderTopRightRadius: 6,
        borderBottomLeftRadius: 6,
        borderBottomRightRadius: 6
    },
    sectionListItemS: {
        ...UIFont.font(fonts.regular, fontSize.small, "#616161"),
        lineHeight: 18,
        letterSpacing: 0,
        backgroundColor: colors.cardColor,
        marginHorizontal: 10,
        paddingHorizontal: 40,
        paddingVertical: 10
    },
    lastSectionListItem: {
        ...UIFont.font(fonts.regular, fontSize.small, "#616161"),
        lineHeight: 18,
        letterSpacing: 0,
        backgroundColor: colors.cardColor,
        marginHorizontal: 10,
        paddingHorizontal: 40,
        borderBottomLeftRadius: 6,
        borderBottomRightRadius: 6,
        paddingVertical: 10
    },
    textInputStyle: {
        width: "85%",
        marginHorizontal: 10,
        color: "black",
        borderBottomWidth: 1,
        borderColor: "black"
    }
});
