import React, { Component } from "react";
import { connect } from "react-redux";
import { WithFetching } from "../../HOC";
import {
    View,
    Text,
    StyleSheet,
    ScrollView,
} from "react-native";
import {
    Separator,
    AppButton,
    TextLabel,
    FormHandler,
    Input, Supporticon
} from "../../components";
import { pop, push } from "../../services/NavigationService";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import { API_CHANGE_PASS } from "../../services/WebService";
import { generalAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import Utils from "../../Utils";

class ChangePassword extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };

    state = {
        firstErr: false,
        secondErr: false,
        thirdErr: false,
        isError: false
    };

    onSubmit = () => {
        const formResponse = this.formHandler.onSubmitForm();
        const formResponse2 = this.formHandlerTwo.onSubmitForm();
        const formResponse3 = this.formHandlerThree.onSubmitForm();
        if (formResponse && formResponse2 && formResponse3) {
            formResponse2.password === formResponse3.password_confirmation
                ? this.requestForgotPass(
                    formResponse,
                    formResponse2,
                    formResponse3
                )
                : this.setState({ isError: true });
        }
    };

    requestForgotPass = (formResponse, formResponse2, formResponse3) => {
        this.props.cbShowLoader(true);
        let payload = new FormData();
        payload.append("old_password", formResponse.old_password);
        payload.append("password", formResponse2.password);
        payload.append(
            "password_confirmation",
            formResponse3.password_confirmation
        );
        this.props.generalAction(
            API_CHANGE_PASS,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.onForgotPassSuccess,
            this.onForgotPassFailure
        );
    };

    onForgotPassSuccess = () => {
        Utils.showMessage(
            "Success",
            "Password changed successfully",
            "success"
        );
        this.props.cbShowLoader(false);
        pop();
    };

    onForgotPassFailure = err => {
        Utils.showError(err);
        this.props.cbShowLoader(false);
    };

    renderError(err, obj) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    heading(label) {
        return (
            <TextLabel color={"black"} style={styles.boldText}>
                {label}
            </TextLabel>
        );
    }

    render() {
        const { firstErr, secondErr, thirdErr } = this.state;

        return (
            <React.Fragment>
                <ScrollView style={styles.container}>
                    {this.heading("Old Password")}
                    <View
                        style={
                            firstErr
                                ? styles.eachColumnWithError
                                : styles.eachColumn
                        }
                    >
                        <FormHandler ref={ref => (this.formHandler = ref)}>
                            <Input
                                placeholder={"********"}
                                placeholderTextColor={"black"}
                                error="Old password is required"
                                type={INPUT_TYPES.PASSWORD}
                                identifier="old_password"
                                blurOnSubmit={false}
                                value={""}
                                isContainerFlex={true}
                                setError={err =>
                                    this.setState({ firstErr: err })
                                }
                                textFieldStyle={
                                    !firstErr
                                        ? { marginHorizontal: 5 }
                                        : styles.textInputStyle
                                }
                            />
                        </FormHandler>
                    </View>
                    <Separator style={styles.seperatorStyle} />
                    {this.heading("New Password")}
                    <View
                        style={
                            secondErr
                                ? styles.eachColumnWithError
                                : styles.eachColumn
                        }
                    >
                        <FormHandler ref={ref => (this.formHandlerTwo = ref)}>
                            <Input
                                placeholder="******"
                                placeholderTextColor={"#606060"}
                                error="Password must contain at least 6 characters."
                                type={INPUT_TYPES.PASSWORD}
                                identifier="password"
                                blurOnSubmit={false}
                                value={""}
                                isContainerFlex={true}
                                setError={err =>
                                    this.setState({ secondErr: err })
                                }
                                textFieldStyle={
                                    !secondErr
                                        ? { marginHorizontal: 5 }
                                        : styles.textInputStyle
                                }
                            />
                        </FormHandler>
                    </View>
                    <Separator style={styles.seperatorStyle} />
                    {this.heading("Confirm Password")}
                    <View
                        style={
                            thirdErr
                                ? styles.eachColumnWithError
                                : styles.eachColumn
                        }
                    >
                        <FormHandler ref={ref => (this.formHandlerThree = ref)}>
                            <Input
                                placeholder="*******"
                                placeholderTextColor={"#606060"}
                                error="Password and confirm password doesn’t match."
                                type={INPUT_TYPES.PASSWORD}
                                identifier="password_confirmation"
                                blurOnSubmit={false}
                                value={""}
                                isContainerFlex={true}
                                cbOnChangeText={txt =>
                                    this.setState({ isError: false })
                                }
                                setError={err =>
                                    this.setState({ thirdErr: err })
                                }
                                blurOnSubmit
                                textFieldStyle={
                                    !thirdErr
                                        ? { marginHorizontal: 5 }
                                        : styles.textInputStyle
                                }
                            />
                        </FormHandler>
                    </View>
                    <Separator style={styles.seperatorStyle} />
                    {this.state.isError &&
                        this.renderError(
                            "New Password and confirm password doesn't match",
                            { paddingHorizontal: 20 }
                        )}
                </ScrollView>
                <Supporticon style={{bottom:60}}
                    clickBtn={() => push("Support")} />
                <AppButton
                    buttonTitle="Submit"
                    style={{
                        backgroundColor: colors.ActiveTabTitle,
                        width: "100%",
                        position: "absolute",
                        bottom: 0,
                        borderRadius: 0
                    }}
                    btnColor={colors.cardColor}
                    onPress={() => {
                        this.onSubmit();
                    }}
                />

                
            </React.Fragment>
        );
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: "#f7f7f7"
    },
    eachColumn: {
        flexDirection: "column"
    },
    eachColumnWithError: {
        height: 80,
        flexDirection: "column"
    },
    boldText: {
        ...UIFont.font(fonts.regular, 12, colors.BlackColor),
        marginTop: 10,

        marginBottom: -10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    seperatorStyle: {
        backgroundColor: "#dde3f6"
    },
    textInputStyle: {
        marginHorizontal: 10,
        color: "black"
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    }
});

const actions = { generalAction };

export default connect(null, actions)(WithFetching(ChangePassword));
