import React, { Component } from "react";
import { View, Image, ScrollView, Text, TextInput, StyleSheet, TouchableWithoutFeedback, TouchableOpacity } from "react-native";
import {
    Container, TextLabel,
    AppButton, Input,
    ReusableModal,
    InfoRoundBox, InfoCard, ButtonView
} from "../../components";
import { Images, icons, colors } from "../../assets";
import { compose } from "redux";
import { connect } from "react-redux";
import { generalAction } from "../../actions/GeneralActions";
import { WithFetching } from "../../HOC";
import styles from "./styles";
import { Colors } from "../../services";
import moment from "moment";
import Utils from "../../Utils";
import { Metrics } from "../../theme";
import { push, pop } from "../../services/NavigationService";
import { API_UPDATE_ONBOARD_CONTRACT } from "../../services/WebService";
import { DUMP } from "../../actions/ActionTypes";

let data = {};
let contractor = {}
let pendingContract = {}
class ContractSchedule extends Component {
    constructor(props) {
        data = props.route.params.data;
        super();
        this.state = {
        }
    }


    showModal = modal => {
        this.setState({ modal });
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.Modal.setModalVisible(false);
    };
    renderModal = () => {
        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={{ flex: 1, backgroundColor: "rgba(0,0,0,0.5)", alignItems: 'center', justifyContent: 'center' }}>

                        <TouchableOpacity onPress={() => this.hideModal()} style={{ width: 50, height: 50, margin: 16, position: 'absolute', top: 0, left: 0 }}>
                            <Image source={icons.ic_cross} style={{ tintColor: '#fff' }} />
                        </TouchableOpacity>
                        <View style={{
                            padding: 16,
                            width: Metrics.screenWidth - 40,
                            backgroundColor: "#fff", alignItems: 'center', borderRadius: 8
                        }}>
                            <TextLabel
                                style={{
                                    color: colors.BlackColor,
                                    fontSize: 16,
                                    fontWeight: 'bold',
                                    textAlign: 'center'
                                }}>
                                {'Please enter the reason to reject the request'}
                            </TextLabel>
                            <TextInput
                                style={styles.inputStyle}
                                placeholder={'Type here...'}
                                value={this.state.reason}
                                onChangeText={text => this.setState({ reason: text })}
                                multiline={true}
                            />
                        </View>
                        <AppButton
                            buttonTitle="SUBMIT"
                            style={{ backgroundColor: colors.ActiveTabTitle, width: Metrics.screenWidth, position: "absolute", bottom: 0 }}
                            btnColor={'#fff'}
                            onPress={() => this._apiForRejectAndApprove()}
                        />
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };
    _apiForRejectAndApprove = (type = 'rejected') => {
        const { contract_id, contractor_id } = data,
            { id } = pendingContract,
            { reason } = this.state;
        this.props.cbShowLoader(true);

        let payload = new FormData();
        payload.append('contract_id', contract_id);
        payload.append('id', id);
        payload.append('action_status', type);
        payload.append('rejected_reason', reason);

        this.props.generalAction(
            API_UPDATE_ONBOARD_CONTRACT,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            (response, message) => {
                this.props.cbShowLoader(false);
                this.hideModal();
                Utils.showMessage("Success", message, "success");
                pop(3);

                if (type !== 'rejected') {
                    const {
                        contract_id,
                        contractor_id,
                        user_id
                    } = this.props.route.params.data;
                    push("rating", {
                        userType: "facility",
                        contract_id,
                        contractor_id,
                        facility_id: user_id
                    });
                }
            },
            this.cbFailure
        );
    }
    cbSuccess = (response, message) => {
        this.props.cbShowLoader(false);
        this.hideModal();

        Utils.showMessage("Success", message, "success");

        setTimeout(() => {
            pop(3)
        }, 300);
    }
    cbFailure = (error) => {
        this.props.cbShowLoader(false);
        Utils.showError(error);
    }
    _acceptRejectBtn = () => {
        const { contract_status, contract_type } = data;
        return (
            <View style={{ width: Metrics.screenWidth, height: 60, marginTop: 8, flexDirection: "row" }}>
                <ButtonView
                    style={styles.btn}
                    onPress={() => this.showModal("reject")}
                >
                    <Text style={{ color: '#08548c' }}>{'Reject'}</Text>
                </ButtonView>
                <ButtonView
                    style={[styles.btn, { backgroundColor: "#08548c" }]}
                    onPress={() => this._apiForRejectAndApprove('approved')}
                >
                    <Text style={{ color: Colors.white, }}>{'Approve'}</Text>
                </ButtonView>
            </View>
        );
    }
    _renderItem = (key, value) => {
        return (
            <View style={{ flex: 1 }}>
                <TextLabel style={Styles.heading}>{key}</TextLabel>
                <TextLabel style={Styles.sub_heading}>{value}</TextLabel>
            </View>
        );
    }
    _getRate = () => {
        const { contract_invitations, contract_rate } = data;

        const { bid_amount } = contract_invitations[0];
        let rate = !Utils.isNull(bid_amount) && bid_amount !== '0.00' ? parseFloat(bid_amount) : parseFloat(contract_rate);
        return rate;
    }

    _getWorkingDays = () => {
        const { shift_start_date, shift_end_date, } = data;

        let diffDays = moment(shift_start_date, "MM-DD-YYYY").diff(
            moment(shift_end_date, "MM-DD-YYYY"), "days");
        let days = Math.abs(diffDays)
        return ++days;
    }

    render() {
        const { contractor_id, project_validity, shift_start_time, shift_start_date, shift_end_time, shift_end_date,
            total_hours, contract_rate, contract_status } = data;
        contractor = this.props.route.params.contractor;
        pendingContract = this.props.route.params.pendingContract;
        return (
            <Container>
                <ScrollView>
                    <View style={Styles.container}>
                        <TextLabel style={[Styles.heading, { fontSize: 24, }]}>{'Contract Schedule'}</TextLabel>
                        <View style={Styles.item}>
                            {this._renderItem('Contract Duration', project_validity)}
                            {this._renderItem('Working Days', this._getWorkingDays())}
                        </View>
                        <View style={Styles.item}>
                            {this._renderItem('Start Date', shift_start_date)}
                            {this._renderItem('Hourly Rate', `$${this._getRate()}`)}
                        </View>
                        <View style={Styles.item}>
                            {this._renderItem('End Date', shift_end_date)}
                            {this._renderItem('Shift Hours', Utils.calculateDiffTime(shift_end_time, shift_start_time))}
                        </View>
                        <View style={Styles.item}>
                            {this._renderItem('Total Shift Hours', total_hours)}
                            {this._renderItem('Total Fees', (this._getRate() * total_hours).toFixed(2))}
                        </View>
                    </View>
                    <InfoCard
                        item={contractor}
                        onPress={() => push("contractorDetail", {
                            data: { user_id: contractor_id },
                            showFooter: false
                        })}
                    />
                    <View style={{ marginHorizontal: 12, marginVertical: 8, flexDirection: 'row', justifyContent: 'space-between' }}>
                        <InfoRoundBox
                            heading={'Total Shift Hours'}
                            subHeading={`${pendingContract.total_hours}`}
                            style={{ width: Metrics.screenWidth / 2.5 }}
                        />

                        <InfoRoundBox
                            heading={'Hour Rate'}
                            subHeading={`$${this._getRate()}`}
                            style={{ width: Metrics.screenWidth / 4 }}

                        />
                        <InfoRoundBox
                            heading={' Total '}
                            subHeading={`$${pendingContract.total_amount}`}
                            style={{ width: Metrics.screenWidth / 4, borderColor: '#d93636' }}
                        // headingStyle={{ color: '#d93636' }}
                        // subHeadingStyle={{ color: '#d93636' }}
                        />
                    </View>

                    {
                        contract_status == "active" && this._acceptRejectBtn()
                    }
                </ScrollView>
                {this.renderModal()}
            </Container>
        );
    }
}
const Styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: '#f7f7fa',
        padding: 16
    }, item: {
        marginVertical: 16,
        flexDirection: 'row',
    }, heading: {
        color: colors.ActiveTabTitle,
        fontSize: 16,
        fontWeight: 'bold'
    }, sub_heading: {
        color: colors.BlackColor,
        fontSize: 16,
        fontWeight: 'bold'
    }
});

const actions = { generalAction };

const mapStateToProps = ({ user }) => {
    return {
        user: user.data
    };
};

const ComposeContractSchedule = compose(
    connect(mapStateToProps, actions)(WithFetching(ContractSchedule))
);

export default ComposeContractSchedule;
