import React, { Component, Fragment } from "react";
import { View, Text, ScrollView, Image, TouchableOpacity } from "react-native";
import {
    Separator,
    AppButton,
    TextLabel,
    RequestsCard,
    FlatListHandler,
    CommentCard,
    Loader,Supporticon
} from "../../components";
import { pop, push } from "../../services/NavigationService";
import { icons, colors, Images } from "../../assets";
import { connect } from "react-redux";
import {
    API_GET_CONTRACTOR,
    API_GET_COMMENTS_LIST,API_DOCUMENTLIST
} from "../../services/WebService";
import styles from "./styles";
import { DUMP,DOC_DATA } from "../../actions/ActionTypes";
import { generalAction } from "../../actions/GeneralActions";

class ContractorDetail extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={icons.ic_arrow_backward_black}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };

    constructor(props, context) {
        super(props, context);
        const showBtn = this.props.navigation.getParam("showFooter");
        const { id, user_id } = this.props.navigation.getParam("data");
        this.state = {
            id: showBtn ? id : user_id,
            data: {},
            dob: "",
            about_me: "",
            qualifitcation: "",
            category_name: "",
            reviewComments: false,
            commentsList: [],
            isFetching: false,
            images:[]
        };

        this.Getdata();
    }

    Getdata = () => {
        this.props.generalAction(
            API_DOCUMENTLIST,
            {},
            DOC_DATA.SUCCESS,
            DOC_DATA.FAILURE,
            (data) => {
                this.setState({ addedImages: data })
                
            },
            () => { },
            true

        );
    }
   
    componentDidMount() {
        this.fetchData(API_GET_CONTRACTOR);
        this.fetchData(API_GET_COMMENTS_LIST);
    }

    fetchData = (api, isConcat: boolean = false, page: Number = 1) => {
        const { id } = this.state;

        this.setState({ isFetching: true });

        this.props.generalAction(
            api,
            {
                user_id: id,
                facility_id: this.props.user.id
            },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            data => {
                if (api == API_GET_CONTRACTOR) {

                    this.setState({
                        isFetching: false,
                        data: data,
                        dob: data.dob,
                        about_me: data.about_me,
                        qualifitcation: data.qualifitcation,
                        category_name: data.category_name,
                        category_id: data.category_id
                    });

                    this.setimagedata();
                } else {
                    this.setState({ commentsList: data });
                }
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    setimagedata = () => {

        const data = this.state.data.documents;
       
        let imagearray = [];
        for (var i = 0; i <= this.state.addedImages.length; i++) {
            var documentsource = this.state.addedImages[i].source;
            var documenttitle = this.state.addedImages[i].title;
            var documenterror = this.state.addedImages[i].validation;
            var documentSourceType = this.state.addedImages[i].source_type;


            for (let passdata in data) {


                if (passdata == documentsource) {

                    var documentdata = {};
                    documentdata["title"] = documenttitle;
                    documentdata["images"] = [...data[passdata]];
                    documentdata["key"] = documentsource + "[]";
                    documentdata["source_type"] = documentSourceType;
                    documentdata["isError"] = false;

                    imagearray.push(documentdata);

                    this.setState({ images: JSON.stringify(imagearray) })

                }

            }

        }

    }


  
    tapOnHeading(label, callBack) {
        return (
            <TouchableOpacity
                style={styles.reviewCommentsContainer}
                onPress={callBack}
            >
                <Text style={styles.boldText}>{label}</Text>
            </TouchableOpacity>
        );
    }

    heading(label, obj) {
        return (
            <TextLabel color={"black"} style={[styles.boldText, obj]}>
                {label}
            </TextLabel>
        );
    }

    rateLabel = rate => {
        return (
            <View style={styles.rateLabel}>
                <Image source={Images.img_star} />
                <Text style={styles.rateStyle}>{rate}</Text>
            </View>
        );
    };

    reviewComments() {
        const { reviewComments, isFetching, commentsList } = this.state;
        if (commentsList.length == 0) return null;
        return (
            <View style={{ marginBottom: 50 }}>
                {this.tapOnHeading("Review Comments", () =>
                    this.setState({
                        reviewComments: !reviewComments
                    })
                )}
                {reviewComments ? (
                    <FlatListHandler
                        onRefresh={() => this.fetchData(API_GET_COMMENTS_LIST)}
                        fetchRequest={() =>
                            this.fetchData(API_GET_COMMENTS_LIST)
                        }
                        data={commentsList}
                        renderItem={item => <CommentCard data={item} />}
                    />
                ) : null}
                
            </View>
        );
    }

    render() {
        const {
                dob,
                about_me,
                qualifitcation,
                category_name,
                id,
                data,
                isFetching,
                category_id,
                images
            } = this.state,
            showBtn = this.props.navigation.getParam("showFooter");
        if (isFetching) return <Loader />;
        return (
            <Fragment>
                <ScrollView style={{ flex: 1, backgroundColor: "#f7f7fa" }}>
                    <RequestsCard
                        request={"received"}
                        item={data}
                        goTo={() => null}
                        showSeperator={true}
                    />
                    {this.heading("About", { marginTop: 30 })}
                    <Text
                        numberOfLines={3}
                        style={styles.descriptionDocumentStyle}
                    >
                        {about_me}
                    </Text>
                    {/*<Separator style={styles.seperatorStyle} />*/}
                    {/*this.heading("Date of Birth")*/}
                    {/*<Text numberOfLines={1} style={styles.textStyle}>
                            {dob}
                    </Text>*/}
                    <Separator style={styles.seperatorStyle} />
                    {this.heading("Qualifications")}
                    <Text numberOfLines={1} style={styles.textStyle}>
                        {qualifitcation}
                    </Text>
                    <Separator style={styles.seperatorStyle} />
                    {this.heading("Speciality")}
                    <Text numberOfLines={1} style={styles.textStyle}>
                        {category_name}
                    </Text>
                    {<Separator style={styles.seperatorStyle} />}
                    {/*this.heading("Documents")*/}
                    {/*
                        <TouchableOpacity
                            style={[
                                styles.categoryStyle,
                                styles.actionSheetView
                            ]}
                            onPress={this.onDocuments}
                        >
                            <Text
                                numberOfLines={2}
                                style={[
                                    styles.descriptionDocumentStyle,
                                    { width: "80%" }
                                ]}
                            >
                                Lorem ipsum dolor sit amet, consectetur
                                adipiscing elit, sed do eiusmod tempor
                                incididunt
                            </Text>
                            <Image
                                style={styles.imageIcon}
                                source={icons.expand_farward}
                            />
                        </TouchableOpacity>
                    */}
                    {data && data.id
                        ? this.tapOnHeading("Review Documents", () =>
                              push("viewDocuments", { data,images })
                          )
                        : null}
                    {/*  */}

                    <Separator style={styles.seperatorStyle} />
                    {this.reviewComments()}
                </ScrollView>
                {showBtn && (
                    <AppButton
                        buttonTitle="INVITE STAFF"
                        style={styles.footerStyle}
                        btnColor={colors.cardColor}
                        onPress={() => {
                            push("selectShiftContract", { id, category_id });
                        }}
                    />
                )}

<Supporticon style={{bottom:60}}
                 clickBtn={() =>push("Support")}/> 
            </Fragment>
        );
    }
}

mapStateToProps = ({ user }) => {
    return {
        user: user.data
    };
};

const actions = { generalAction };

export default connect(mapStateToProps, actions)(ContractorDetail);