import { StyleSheet, Platform } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";

export default StyleSheet.create({

    footerStyle: {
        backgroundColor: colors.ActiveTabTitle,
        width: "100%",
        position: "absolute",
        bottom: 0,
        borderRadius: 0
    },
    boldText: {
        ...UIFont.font(fonts.semiBold, 12, colors.BlackColor),
        marginTop: 10,
        marginBottom: -10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    seperatorStyle: {
        backgroundColor: "#dde3f6",
        marginTop: 20
    },

    descriptionDocumentStyle: {
        ...UIFont.font(fonts.reqular, 13, "#4e4e4e"),
        paddingHorizontal: 20,
        paddingTop: 25,
        letterSpacing: 0
    },
    textStyle: {
        ...UIFont.font(fonts.reqular, 18, "#606060"),
        paddingHorizontal: 20,
        paddingTop: 25,
        letterSpacing: 0
    },
    imageIcon: {
        marginTop: Metrics.baseMargin,
        marginRight: Metrics.baseMargin
    },
    categoryStyle: {
        width: "100%",
        flexDirection: "row",
        alignItems: "center"
    },
    actionSheetView: {
        flex: 1,
        justifyContent: "space-between",
        paddingBottom: Metrics.baseMargin
    },
    headerTitle: {
        color: colors.BlackColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.HeaderColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    rateLabel: {
        width: 30,
        flexDirection: "row",
        marginTop: 5,
        marginLeft: 5
    },
    rateStyle: {
        ...UIFont.font(fonts.regular, 13, colors.BlackColor),
        paddingHorizontal: 3
    },
    reviewCommentsContainer: {
        marginVertical: 20,
        flexDirection: "row",
        justifyContent: "space-between"
    }
});
