// import React, { Component, Fragment } from "react";
// import {
//     View,
//     Text,
//     Image,
//     StyleSheet, Modal,
//     TouchableOpacity,
//     TouchableWithoutFeedback, BackHandler,
//     ScrollView, Platform, PermissionsAndroid
// } from "react-native";
// import { connect } from "react-redux";
// import { NavigationEvents } from "react-navigation";
// import { generalAction, generalSaveAction, generalDispatchType } from "../../actions/GeneralActions";
// import { push } from "../../services/NavigationService";
// import {
//     API_NOTIFICATION_COUNT, API_INACTIVE, BASE_URL, GET_UPDATE,
//     API_PERCENTAGE,
// } from "../../services/WebService";
// import { DUMP, ADMIN_FEE_AMOUNT, USER, LOGOUT } from "../../actions/ActionTypes";
// import { Images, icons, colors, UIFont, fonts, fontSize, } from "../../assets";
// import { SquareCard, NetInfoModal, ReusableModal, Supporticon } from "../../components";
// import { WithNetInfoListener } from "../../HOC";
// import Metrics from "../../services/Metrics";
// import { AppStyles } from "../../services";
// import { compose } from "redux";
// import Utils from "../../Utils";
// import { AppUpdate } from '../../containers';
// import Geolocation from '@react-native-community/geolocation';
// import axios from "axios";

// class ContractorHome extends Component {
//     constructor(props) {
//         super(props);
//         this.state = {
//             bothWarning:
//                 "Please verify your profile, account details to apply, bid or accept requests",
//             profileWarning:
//                 "Please verify your profile to apply, bid or accept requests",
//             accountDetailWarning:
//                 "Please provide account details to apply, bid or accept requests",
//             didFocus: false, intervalId: '',
//             isupdate_store: false,
//             isupdate_popup: false,
//             isupdate_logout: false,
//             messageval: '',
//             updateval: '',
//             urlvalue: Utils.isPlatformAndroid() ?
//                 'https://play.google.com/store/apps/details?id=com.medicashifts' :
//                 'https://apps.apple.com/in/app/medicashift-facility/id1481440009',

//         };

//     }

//     componentDidMount() {
//         if (Object.keys(this.props.user).length > 0) {
//             const {
//                 is_personnel_file_status,
//                 is_profile_verified,
//             } = this.props.user;
//             !is_profile_verified && this.showModal();

//         }

//         this.getPercentageValue();
//         this.checkPermission();
//         this.appUpdateApi();

//     }

//     appUpdateApi = () => {

//         let self = this;

//         axios.get(BASE_URL + GET_UPDATE, {
//             headers: {
//                 token: "api.Pd*!(5675",
//                 api_version: '1.0',
//                 api_client: 'android'

//             }
//         })
//             .then(function (response) {

//                 const codeval = response.data.success;
//                 const val = response.data.message;

//                 if (codeval == 200) {

//                     var codetype = response.data.code;

//                     if (codetype == "store") {

//                         self.setState({ isupdate_store: true, messageval: val })

//                     } else if (codetype == "popup") {

//                         self.setState({ isupdate_popup: true, messageval: val })

//                     } else if (codetype == "logout ") {

//                         self.setState({ isupdate_logout: true, messageval: val })

//                     }
//                     else {

//                         Utils.showError(response.data.message)
//                     }

//                 } else {



//                 }

//             })
//             .catch(function (error) {
//                 console.log(error);
//                 //alert(error);
//             })
//     }

//     checkPermission = async () => {
//         if (Platform.OS === 'ios') {
//             this.getOneTimeLocation();
//         } else {
//             try {
//                 const granted = await PermissionsAndroid.request(
//                     PermissionsAndroid.PERMISSIONS.ACCESS_FINE_LOCATION,
//                     {
//                         title: 'Location Access Required',
//                         message: 'This App needs to Access your location',
//                     },
//                 );
//                 if (granted === PermissionsAndroid.RESULTS.GRANTED) {
//                     //To Check, If Permission is granted
//                     this.getOneTimeLocation();
//                 } else {
//                     // setLocationStatus('Permission Denied');
//                 }
//             } catch (err) {
//             }

//         }

//     }


//     getOneTimeLocation = () => {
//         Geolocation.getCurrentPosition(
//             (position) => {

//             },
//             (error) => {
//                 // setLocationStatus(error.message);
//                 console.log(error.message)

//             },
//             {
//                 enableHighAccuracy: false,
//                 timeout: 30000,
//                 maximumAge: 1000
//             },
//         );
//     };

//     CheckstatustSuccess = (response) => {
//         const { CheckstatusFailure_value } = response;
//         Utils.showError(response.data);
//     };

//     CheckstatusFailure = (response) => { };
//     getPercentageValue = () => {
//         this.props.generalAction(
//             API_PERCENTAGE,
//             null,
//             DUMP.SUCCESS,
//             DUMP.FAILURE,
//             this.cbSuccess,
//             this.cbFailure,
//             true
//         );

//     };
//     cbSuccess = (response) => {
//         const { percentage_value } = response;

//         this.props.generalSaveAction(ADMIN_FEE_AMOUNT, {
//             amount: percentage_value,
//         });
//         Utils.setAdminFee(percentage_value);
//     };

//     cbFailure = (response) => {


//     };

//     componentDidUpdate(prevProps, prevState) {
//         if (this.state.didFocus && this.props.user !== prevProps.user) {
//             const {
//                 is_personnel_file_status,
//                 is_profile_verified,
//             } = this.props.user;

//             !is_profile_verified && this.showModal();

//         }
//     }

//     onNavigationFocus = () => {
//         setTimeout(this.fetchNotificationCount, 1500);
//         this.setState({ didFocus: true });
//     };

//     onNavigationBlur = () => this.setState({ didFocus: false });

//     fetchNotificationCount = () => {
//         this.props.generalAction(
//             API_NOTIFICATION_COUNT,
//             { user_id: this.props.user.id },
//             DUMP.SUCCESS,
//             DUMP.FAILURE,
//             ({ notification_count }) => {
//                 this.props.navigation.setParams({
//                     showInfo: +notification_count > 0 ? true : false,
//                 });
//             },
//             () => { },
//             true
//         );
//         this.loadData();
//         let intervalId = setInterval(this.loadData, 5000);
//         this.setState({ intervalId: intervalId });
//     };

//     loadData = () => {

//         this.props.generalAction(
//             API_INACTIVE,
//             { user_id: this.props.user.id },
//             DUMP.SUCCESS,
//             DUMP.FAILURE,
//             data => {

//                 data.map(item => {
//                     item.is_account_active == 0 ? (
//                         this.sendData()
//                     ) : null

//                     Utils.setLunchValue(item.Lunch_value)
//                     Utils.setHelpLine(item.help_line)
//                 })
//             },
//             () => {


//             },
//             true
//         );
//     };
//     sendData = () => {

//         push("login")
//         Utils.showError("Your account is inactive, please contact medicashift")
//         clearInterval(this.state.intervalId)

//     }

//     sendDataLogout = () => {

//         push("login")
//         this.props.generalDispatchType(LOGOUT);
//         clearInterval(this.state.intervalId)

//     }
//     renderWarning() {
//         const { is_stripe_key, is_personnel_file_status } = this.props.user;
//         return (
//             <Fragment>
//                 {!is_stripe_key &&
//                     is_personnel_file_status !== 2 &&
//                     this.renderWarningText("bothWarning")}
//                 {is_stripe_key &&
//                     is_personnel_file_status !== 2 &&
//                     this.renderWarningText("profileWarning")}
//                 {!is_stripe_key &&
//                     is_personnel_file_status == 2 &&
//                     this.renderWarningText("accountDetailWarning")}

//             </Fragment>
//         );
//     }

//     renderWarningText(warningText) {
//         return (
//             <View style={styles.containerWarning}>
//                 <Text style={{ color: "white" }}>
//                     {this.state[warningText]}
//                 </Text>
//             </View>
//         );
//     }

//     showModal = (modal) => {

//         this.Modal.setModalVisible(true);
//     };

//     hideModal = () => {
//         this.Modal.setModalVisible(false);
//     };

//     renderModal = () => {
//         return (
//             <TouchableWithoutFeedback>
//                 <Fragment>
//                     <View style={styles.modelBody}>
//                         <Text style={{ marginBottom: 30 }}>
//                             Please get the following documents ready as you will
//                             need to upload them on the MedicaShift app before
//                             you can get verified and start bidding on shifts.
//                             These documents are mandatory:
//                         </Text>
//                         <Text>1. TB test/Chest x-ray</Text>
//                         <Text>2. Valid Driver's License</Text>
//                         <Text>3. Copy of your SSN</Text>
//                         <Text>4. Your Resume</Text>
//                         <Text>
//                             5. Copy of your Professional License/Certification
//                         </Text>
//                         <Text>6. Copy of your immunizations</Text>
//                         <Text>7. Hepatitis B Vaccine (Not Mandatory)</Text>
//                     </View>
//                     <View style={styles.modelFooter}>
//                         <Text>Ok</Text>
//                     </View>
//                 </Fragment>
//             </TouchableWithoutFeedback>
//         );
//     };


//     render() {
//         const { isNetworkConnected } = this.props.networkInfo;
//         const { isupdate_store, isupdate_logout, messageval, isupdate_popup } = this.state;


//         return (
//             <View style={{ flex: 1 }}>

//                 <ScrollView style={styles.container}>
//                     <NavigationEvents
//                         onDidFocus={this.onNavigationFocus}
//                         onDidBlur={this.onNavigationBlur}
//                     />

//                     {this.renderWarning()}
//                     <Image source={Images.bgHome} />
//                     <View
//                         style={{
//                             width: "85%",
//                             alignSelf: "center",
//                             marginBottom: 30,
//                         }}
//                     >
//                         <View
//                             style={{
//                                 flexDirection: "row",
//                                 justifyContent: "space-between",
//                             }}
//                         >
//                             <SquareCard
//                                 text="MY SCHEDULE"
//                                 icon={Images.MySchedule}
//                                 onClick={() => push("mySchedule")}
//                             />
//                             <SquareCard
//                                 text="AVAILABLE SHIFT"
//                                 icon={Images.AvailableJobs}
//                                 onClick={() => push("availableJobs")}
//                             />
//                         </View>
//                         <View
//                             style={{
//                                 flexDirection: "row",
//                                 justifyContent: "space-between",
//                             }}
//                         >
//                             <SquareCard
//                                 text="SHIFT / CONTRACT INVITATION"
//                                 icon={Images.ShiftContractInvitation}
//                                 onClick={() => push("contractorInvitation")}
//                             />
//                             <SquareCard
//                                 text="AVAILABILITY"
//                                 icon={Images.Availablity}
//                                 onClick={() => push("availability")}
//                             />
//                         </View>
//                     </View>

//                     <ReusableModal ref={(ref) => (this.Modal = ref)}>
//                         <TouchableWithoutFeedback onPress={this.hideModal}>
//                             <View blurRadius={1} style={styles.modalContainer}>
//                                 <View style={styles.modalInnerView}>
//                                     {this.renderModal()}
//                                 </View>
//                             </View>

//                         </TouchableWithoutFeedback>
//                     </ReusableModal>

//                     {isupdate_store ?
//                         <Modal transparent >
//                             <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }} >
//                                 <View style={{
//                                     backgroundColor: "white",
//                                     paddingVertical: Metrics.ratio(50),
//                                     paddingHorizontal: Metrics.baseMargin,
//                                     borderRadius: Metrics.baseMargin,
//                                     ...AppStyles.centerAligned, marginHorizontal: Metrics.doubleBaseMargin
//                                 }}>
//                                     <AppUpdate {...this.props} valueset={this.state.urlvalue} />

//                                 </View>
//                             </View>
//                         </Modal> : null}

//                     {isupdate_logout ?
//                         <Modal transparent >
//                             <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }} >
//                                 <View style={{
//                                     backgroundColor: "white",
//                                     paddingVertical: Metrics.ratio(50),
//                                     paddingHorizontal: Metrics.baseMargin,
//                                     borderRadius: Metrics.baseMargin,
//                                     ...AppStyles.centerAligned, marginHorizontal: Metrics.doubleBaseMargin
//                                 }}>
//                                     <View style={styles.updateview} >
//                                         <Text style={{
//                                             padding: 10, fontFamily: 'Gibson',
//                                             ...UIFont.font(fonts.semiBold, fontSize.xLarge, colors.BlackColor),
//                                             fontSize: 20, alignSelf: 'center'
//                                         }}>Reason for Logout</Text>

//                                         <Text style={{
//                                             color: 'black', padding: 10, fontFamily: 'Gibson',
//                                             ...UIFont.font(fonts.regular, fontSize.medium, colors.BlackColor),
//                                             fontSize: 20, alignSelf: 'baseline'
//                                         }}>
//                                             {messageval}
//                                         </Text>

//                                         <TouchableOpacity
//                                             activeOpacity={1.0}
//                                             style={styles.modalverifyFooter}
//                                             onPress={() =>
//                                                 this.sendDataLogout()
//                                             } >

//                                             <Text style={{
//                                                 color: '#ffff',
//                                                 textAlign: 'center',
//                                                 ...UIFont.font(fonts.semiBold, fontSize.medium, colors.WhiteColor),
//                                                 padding: 10,
//                                             }}>
//                                                 OK
//                                             </Text>

//                                         </TouchableOpacity>
//                                     </View>

//                                 </View>
//                             </View>
//                         </Modal> : null}

//                     {isupdate_popup ?
//                         <Modal transparent >
//                             <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }} >
//                                 <View style={{
//                                     backgroundColor: "white",
//                                     paddingVertical: Metrics.ratio(50),
//                                     paddingHorizontal: Metrics.baseMargin,
//                                     borderRadius: Metrics.baseMargin,
//                                     ...AppStyles.centerAligned, marginHorizontal: Metrics.doubleBaseMargin
//                                 }}>
//                                     <View style={styles.updateview} >
//                                         <Text style={{
//                                             padding: 10, fontFamily: 'Gibson',
//                                             ...UIFont.font(fonts.semiBold, fontSize.xLarge, colors.BlackColor),
//                                             fontSize: 20, alignSelf: 'center'
//                                         }}>Reason for Maintenance</Text>

//                                         <Text style={{
//                                             color: 'black', padding: 10, fontFamily: 'Gibson',
//                                             ...UIFont.font(fonts.regular, fontSize.medium, colors.BlackColor),
//                                             fontSize: 20, alignSelf: 'baseline'
//                                         }}>
//                                             {messageval}
//                                         </Text>

//                                         <TouchableOpacity
//                                             activeOpacity={1.0}
//                                             style={styles.modalverifyFooter}
//                                             onPress={() => BackHandler.exitApp()} >

//                                             <Text style={{
//                                                 color: '#ffff',
//                                                 textAlign: 'center',
//                                                 ...UIFont.font(fonts.semiBold, fontSize.medium, colors.WhiteColor),
//                                                 padding: 10,
//                                             }}>
//                                                 OK
//                                             </Text>

//                                         </TouchableOpacity>
//                                     </View>

//                                 </View>
//                             </View>
//                         </Modal> : null}



//                     <NetInfoModal isNetworkConnected={isNetworkConnected} />


//                 </ScrollView>

//                 <Supporticon
//                     clickBtn={() => push("Support")} />

//             </View>

//         );
//     }
// }

// const actions = { generalAction, generalSaveAction, generalDispatchType };
// const mapStateToProps = ({ user, networkInfo }) => {
//     return { user: user.data, networkInfo };
// };

// const composeContractorHome = compose(
//     connect(mapStateToProps, actions)(WithNetInfoListener(ContractorHome))
// );

// export default composeContractorHome;

// composeContractorHome.navigationOptions = ({ navigation }) => {
//     const { state } = navigation;
//     const params = state.params || {};
//     return {
//         headerRight: (

//             <TouchableOpacity onPress={() => push("notifications")}>
//                 <Image
//                     style={{ margin: 10 }}
//                     resizeMode="contain"
//                     source={!params.showInfo ? icons.bell : icons.notification}
//                 />
//             </TouchableOpacity>

//         ),
//     };
// }

// const styles = StyleSheet.create({
//     container: {
//         flex: 1,
//     },
//     containerWarning: {
//         height: 40,
//         width: "100%",
//         backgroundColor: "red",
//         justifyContent: "center",
//         alignItems: "center",
//         paddingHorizontal: 20,
//     },
//     modalContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
//     modalInnerView: {
//         flex: 1,
//         justifyContent: "center",
//         alignItems: "center",
//     },
//     modelBody: {
//         width: "85%",
//         backgroundColor: "white",
//         padding: 20,
//         borderTopLeftRadius: 10,
//         borderTopRightRadius: 10,
//     },
//     modelFooter: {
//         width: "85%",
//         height: 50,
//         justifyContent: "center",
//         alignItems: "center",
//         backgroundColor: "red",
//         borderBottomLeftRadius: 10,
//         borderBottomRightRadius: 10,
//         backgroundColor: "white",
//         borderTopColor: "black",
//         borderTopWidth: 1,
//     },
//     updateview: {
//         justifyContent: 'flex-end',
//         width: "85%",
//         backgroundColor: "white",
//         padding: 5,
//         borderTopLeftRadius: 5,
//         borderTopRightRadius: 5,
//     },
//     modalverifyFooter: {
//         backgroundColor: "#bb050c",
//         borderRadius: 5,
//         margin: 30,
//     },

// });
import React, { Component, Fragment } from "react";
import {
    View,
    Text,
    Image,
    StyleSheet,
    Modal,
    TouchableOpacity,
    TouchableWithoutFeedback,
    BackHandler,
    ScrollView,
    Platform,
    PermissionsAndroid
} from "react-native";
import { connect } from "react-redux";
import { generalAction, generalSaveAction, generalDispatchType } from "../../actions/GeneralActions";
import { push } from "../../services/NavigationService";
import {
    API_NOTIFICATION_COUNT,
    API_INACTIVE,
    BASE_URL,
    GET_UPDATE,
    API_PERCENTAGE,
} from "../../services/WebService";
import { DUMP, ADMIN_FEE_AMOUNT, USER, LOGOUT } from "../../actions/ActionTypes";
import { Images, icons, colors, UIFont, fonts, fontSize } from "../../assets";
import { SquareCard, NetInfoModal, ReusableModal, Supporticon } from "../../components";
import { WithNetInfoListener } from "../../HOC";
import Metrics from "../../services/Metrics";
import { AppStyles } from "../../services";
import { compose } from "redux";
import Utils from "../../Utils";
import { AppUpdate } from "../../containers";
import Geolocation from "@react-native-community/geolocation";
import axios from "axios";
import { useFocusEffect } from "@react-navigation/native";

//
// ✅ Helper HOC to replace old <NavigationEvents>
//
function withNavigationFocus(WrappedComponent) {
    return function (props) {
        useFocusEffect(
            React.useCallback(() => {
                if (props.onNavigationFocus) props.onNavigationFocus();
                return () => {
                    if (props.onNavigationBlur) props.onNavigationBlur();
                };
            }, [])
        );
        return <WrappedComponent {...props} />;
    };
}

class ContractorHome extends Component {
    constructor(props) {
        super(props);
        this.state = {
            bothWarning:
                "Please verify your profile, account details to apply, bid or accept requests",
            profileWarning:
                "Please verify your profile to apply, bid or accept requests",
            accountDetailWarning:
                "Please provide account details to apply, bid or accept requests",
            didFocus: false,
            intervalId: "",
            isupdate_store: false,
            isupdate_popup: false,
            isupdate_logout: false,
            messageval: "",
            updateval: "",
            urlvalue: Utils.isPlatformAndroid()
                ? "https://play.google.com/store/apps/details?id=com.medicashifts"
                : "https://apps.apple.com/in/app/medicashift-facility/id1481440009",
        };
    }

    componentDidMount() {
        if (Object.keys(this.props.user).length > 0) {
            const { is_profile_verified } = this.props.user;
            !is_profile_verified && this.showModal();
        }

        this.getPercentageValue();
        this.checkPermission();
        this.appUpdateApi();

        // ✅ Replace old static navigationOptions
        this.props.navigation.setOptions({
            headerRight: () => (
                <TouchableOpacity onPress={() => push("notifications")}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={icons.notification}
                    />
                </TouchableOpacity>
            ),
        });
    }

    appUpdateApi = () => {
        axios
            .get(BASE_URL + GET_UPDATE, {
                headers: {
                    token: "api.Pd*!(5675",
                    api_version: "1.0",
                    api_client: "android",
                },
            })
            .then((response) => {
                const codeval = response.data.success;
                const val = response.data.message;

                if (codeval == 200) {
                    var codetype = response.data.code;

                    if (codetype == "store") {
                        this.setState({ isupdate_store: true, messageval: val });
                    } else if (codetype == "popup") {
                        this.setState({ isupdate_popup: true, messageval: val });
                    } else if (codetype == "logout") {
                        this.setState({ isupdate_logout: true, messageval: val });
                    } else {
                        Utils.showError(response.data.message);
                    }
                }
            })
            .catch(function (error) {
                console.log(error);
            });
    };

    checkPermission = async () => {
        if (Platform.OS === "ios") {
            this.getOneTimeLocation();
        } else {
            try {
                const granted = await PermissionsAndroid.request(
                    PermissionsAndroid.PERMISSIONS.ACCESS_FINE_LOCATION,
                    {
                        title: "Location Access Required",
                        message: "This App needs to Access your location",
                    }
                );
                if (granted === PermissionsAndroid.RESULTS.GRANTED) {
                    this.getOneTimeLocation();
                }
            } catch (err) {
                console.log(err);
            }
        }
    };

    getOneTimeLocation = () => {
        Geolocation.getCurrentPosition(
            (position) => {},
            (error) => {
                console.log(error.message);
            },
            {
                enableHighAccuracy: false,
                timeout: 30000,
                maximumAge: 1000,
            }
        );
    };

    getPercentageValue = () => {
        this.props.generalAction(
            API_PERCENTAGE,
            null,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbSuccess,
            this.cbFailure,
            true
        );
    };

    cbSuccess = (response) => {
        const { percentage_value } = response;
        this.props.generalSaveAction(ADMIN_FEE_AMOUNT, { amount: percentage_value });
        Utils.setAdminFee(percentage_value);
    };

    cbFailure = (response) => {};

    componentDidUpdate(prevProps, prevState) {
        if (this.state.didFocus && this.props.user !== prevProps.user) {
            const { is_profile_verified } = this.props.user;
            !is_profile_verified && this.showModal();
        }
    }

    onNavigationFocus = () => {
        setTimeout(this.fetchNotificationCount, 1500);
        this.setState({ didFocus: true });
    };

    onNavigationBlur = () => this.setState({ didFocus: false });

    fetchNotificationCount = () => {
        this.props.generalAction(
            API_NOTIFICATION_COUNT,
            { user_id: this.props.user.id },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            ({ notification_count }) => {
                this.props.navigation.setParams({
                    showInfo: +notification_count > 0 ? true : false,
                });
            },
            () => {},
            true
        );
        this.loadData();
        let intervalId = setInterval(this.loadData, 5000);
        this.setState({ intervalId });
    };

    loadData = () => {
        this.props.generalAction(
            API_INACTIVE,
            { user_id: this.props.user.id },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            (data) => {
                data.map((item) => {
                    if (item.is_account_active == 0) {
                        this.sendData();
                    }
                    Utils.setLunchValue(item.Lunch_value);
                    Utils.setHelpLine(item.help_line);
                });
            },
            () => {},
            true
        );
    };

    sendData = () => {
        push("login");
        Utils.showError("Your account is inactive, please contact medicashift");
        clearInterval(this.state.intervalId);
    };

    sendDataLogout = () => {
        push("login");
        this.props.generalDispatchType(LOGOUT);
        clearInterval(this.state.intervalId);
    };

    renderWarning() {
        const { is_stripe_key, is_personnel_file_status } = this.props.user;
        return (
            <Fragment>
                {!is_stripe_key &&
                    is_personnel_file_status !== 2 &&
                    this.renderWarningText("bothWarning")}
                {is_stripe_key &&
                    is_personnel_file_status !== 2 &&
                    this.renderWarningText("profileWarning")}
                {!is_stripe_key &&
                    is_personnel_file_status == 2 &&
                    this.renderWarningText("accountDetailWarning")}
            </Fragment>
        );
    }

    renderWarningText(warningText) {
        return (
            <View style={styles.containerWarning}>
                <Text style={{ color: "white" }}>{this.state[warningText]}</Text>
            </View>
        );
    }

    showModal = () => {
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.Modal.setModalVisible(false);
    };

    renderModal = () => {
        return (
            <TouchableWithoutFeedback>
                <Fragment>
                    <View style={styles.modelBody}>
                        <Text style={{ marginBottom: 30 }}>
                            Please get the following documents ready as you will need to
                            upload them on the MedicaShift app before you can get verified
                            and start bidding on shifts.
                        </Text>
                        <Text>1. TB test/Chest x-ray</Text>
                        <Text>2. Valid Driver's License</Text>
                        <Text>3. Copy of your SSN</Text>
                        <Text>4. Your Resume</Text>
                        <Text>5. Copy of your Professional License/Certification</Text>
                        <Text>6. Copy of your immunizations</Text>
                        <Text>7. Hepatitis B Vaccine (Not Mandatory)</Text>
                    </View>
                    <View style={styles.modelFooter}>
                        <Text>Ok</Text>
                    </View>
                </Fragment>
            </TouchableWithoutFeedback>
        );
    };

    render() {
        const { isNetworkConnected } = this.props.networkInfo;
        const { isupdate_store, isupdate_logout, messageval, isupdate_popup } =
            this.state;

        return (
            <View style={{ flex: 1 }}>
                <ScrollView style={styles.container}>
                    {this.renderWarning()}
                    <Image source={Images.bgHome} />
                    <View
                        style={{
                            width: "85%",
                            alignSelf: "center",
                            marginBottom: 30,
                        }}
                    >
                        <View
                            style={{
                                flexDirection: "row",
                                justifyContent: "space-between",
                            }}
                        >
                            <SquareCard
                                text="MY SCHEDULE"
                                icon={Images.MySchedule}
                                onClick={() => push("mySchedule")}
                            />
                            <SquareCard
                                text="AVAILABLE SHIFT"
                                icon={Images.AvailableJobs}
                                onClick={() => push("availableJobs")}
                            />
                        </View>
                        <View
                            style={{
                                flexDirection: "row",
                                justifyContent: "space-between",
                            }}
                        >
                            <SquareCard
                                text="SHIFT / CONTRACT INVITATION"
                                icon={Images.ShiftContractInvitation}
                                onClick={() => push("contractorInvitation")}
                            />
                            <SquareCard
                                text="AVAILABILITY"
                                icon={Images.Availablity}
                                onClick={() => push("availability")}
                            />
                        </View>
                    </View>

                    <ReusableModal ref={(ref) => (this.Modal = ref)}>
                        <TouchableWithoutFeedback onPress={this.hideModal}>
                            <View blurRadius={1} style={styles.modalContainer}>
                                <View style={styles.modalInnerView}>
                                    {this.renderModal()}
                                </View>
                            </View>
                        </TouchableWithoutFeedback>
                    </ReusableModal>

                    {isupdate_store && (
                        <Modal transparent>
                            <View
                                style={{
                                    flex: 1,
                                    ...AppStyles.centerAligned,
                                    backgroundColor: "rgba(0,0,0,0.2)",
                                }}
                            >
                                <View
                                    style={{
                                        backgroundColor: "white",
                                        paddingVertical: Metrics.ratio(50),
                                        paddingHorizontal: Metrics.baseMargin,
                                        borderRadius: Metrics.baseMargin,
                                        ...AppStyles.centerAligned,
                                        marginHorizontal: Metrics.doubleBaseMargin,
                                    }}
                                >
                                    <AppUpdate
                                        {...this.props}
                                        valueset={this.state.urlvalue}
                                    />
                                </View>
                            </View>
                        </Modal>
                    )}

                    {isupdate_logout && (
                        <Modal transparent>
                            <View
                                style={{
                                    flex: 1,
                                    ...AppStyles.centerAligned,
                                    backgroundColor: "rgba(0,0,0,0.2)",
                                }}
                            >
                                <View
                                    style={{
                                        backgroundColor: "white",
                                        paddingVertical: Metrics.ratio(50),
                                        paddingHorizontal: Metrics.baseMargin,
                                        borderRadius: Metrics.baseMargin,
                                        ...AppStyles.centerAligned,
                                        marginHorizontal: Metrics.doubleBaseMargin,
                                    }}
                                >
                                    <View style={styles.updateview}>
                                        <Text
                                            style={{
                                                padding: 10,
                                                fontFamily: "Gibson",
                                                ...UIFont.font(
                                                    fonts.semiBold,
                                                    fontSize.xLarge,
                                                    colors.BlackColor
                                                ),
                                                fontSize: 20,
                                                alignSelf: "center",
                                            }}
                                        >
                                            Reason for Logout
                                        </Text>

                                        <Text
                                            style={{
                                                color: "black",
                                                padding: 10,
                                                fontFamily: "Gibson",
                                                ...UIFont.font(
                                                    fonts.regular,
                                                    fontSize.medium,
                                                    colors.BlackColor
                                                ),
                                                fontSize: 20,
                                                alignSelf: "baseline",
                                            }}
                                        >
                                            {messageval}
                                        </Text>

                                        <TouchableOpacity
                                            activeOpacity={1.0}
                                            style={styles.modalverifyFooter}
                                            onPress={() => this.sendDataLogout()}
                                        >
                                            <Text
                                                style={{
                                                    color: "#ffff",
                                                    textAlign: "center",
                                                    ...UIFont.font(
                                                        fonts.semiBold,
                                                        fontSize.medium,
                                                        colors.WhiteColor
                                                    ),
                                                    padding: 10,
                                                }}
                                            >
                                                OK
                                            </Text>
                                        </TouchableOpacity>
                                    </View>
                                </View>
                            </View>
                        </Modal>
                    )}

                    {isupdate_popup && (
                        <Modal transparent>
                            <View
                                style={{
                                    flex: 1,
                                    ...AppStyles.centerAligned,
                                    backgroundColor: "rgba(0,0,0,0.2)",
                                }}
                            >
                                <View
                                    style={{
                                        backgroundColor: "white",
                                        paddingVertical: Metrics.ratio(50),
                                        paddingHorizontal: Metrics.baseMargin,
                                        borderRadius: Metrics.baseMargin,
                                        ...AppStyles.centerAligned,
                                        marginHorizontal: Metrics.doubleBaseMargin,
                                    }}
                                >
                                    <View style={styles.updateview}>
                                        <Text
                                            style={{
                                                padding: 10,
                                                fontFamily: "Gibson",
                                                ...UIFont.font(
                                                    fonts.semiBold,
                                                    fontSize.xLarge,
                                                    colors.BlackColor
                                                ),
                                                fontSize: 20,
                                                alignSelf: "center",
                                            }}
                                        >
                                            Reason for Maintenance
                                        </Text>

                                        <Text
                                            style={{
                                                color: "black",
                                                padding: 10,
                                                fontFamily: "Gibson",
                                                ...UIFont.font(
                                                    fonts.regular,
                                                    fontSize.medium,
                                                    colors.BlackColor
                                                ),
                                                fontSize: 20,
                                                alignSelf: "baseline",
                                            }}
                                        >
                                            {messageval}
                                        </Text>

                                        <TouchableOpacity
                                            activeOpacity={1.0}
                                            style={styles.modalverifyFooter}
                                            onPress={() => BackHandler.exitApp()}
                                        >
                                            <Text
                                                style={{
                                                    color: "#ffff",
                                                    textAlign: "center",
                                                    ...UIFont.font(
                                                        fonts.semiBold,
                                                        fontSize.medium,
                                                        colors.WhiteColor
                                                    ),
                                                    padding: 10,
                                                }}
                                            >
                                                OK
                                            </Text>
                                        </TouchableOpacity>
                                    </View>
                                </View>
                            </View>
                        </Modal>
                    )}

                    <NetInfoModal isNetworkConnected={isNetworkConnected} />
                </ScrollView>

                <Supporticon clickBtn={() => push("Support")} />
            </View>
        );
    }
}

const actions = { generalAction, generalSaveAction, generalDispatchType };
const mapStateToProps = ({ user, networkInfo }) => {
    return { user: user.data, networkInfo };
};

const ContractorHomeWithFocus = withNavigationFocus(ContractorHome);

export default compose(
    connect(mapStateToProps, actions),
    WithNetInfoListener
)(ContractorHomeWithFocus);

const styles = StyleSheet.create({
    container: {
        flex: 1,
    },
    containerWarning: {
        height: 40,
        width: "100%",
        backgroundColor: "red",
        justifyContent: "center",
        alignItems: "center",
        paddingHorizontal: 20,
    },
    modalContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
    modalInnerView: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
    },
    modelBody: {
        width: "85%",
        backgroundColor: "white",
        padding: 20,
        borderTopLeftRadius: 10,
        borderTopRightRadius: 10,
    },
    modelFooter: {
        width: "85%",
        height: 50,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "white",
        borderTopColor: "black",
        borderTopWidth: 1,
    },
    updateview: {
        justifyContent: "flex-end",
        width: "85%",
        backgroundColor: "white",
        padding: 5,
        borderTopLeftRadius: 5,
        borderTopRightRadius: 5,
    },
    modalverifyFooter: {
        backgroundColor: "#bb050c",
        borderRadius: 5,
        margin: 30,
    },
});
