import React, { Component } from "react";
import { View, Text } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, MainCard } from "../../components";
import { API_CONTRACTOR_INVITATION } from "../../services/WebService";
import { push } from "../../services/NavigationService";
import styles from "./styles";
import { generalAction } from "../../actions/GeneralActions";
import { LIST_ACTIVE_REQUESTS } from "../../actions/ActionTypes";

class InvitationReceived extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isFetching: false,
            isrefresh:false

        };
    }

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { user } = this.props;
        this.setState({ isFetching: true });
        this.setState({ isrefresh: true });

        this.props.generalAction(
            API_CONTRACTOR_INVITATION,
            {
                user_id: user.id,
                invitation_type: "sent",
                invitation_status: "pending",
                is_onboarded: 0,
                is_onboarded: "active",
                page
            },
            LIST_ACTIVE_REQUESTS.SUCCESS,
            LIST_ACTIVE_REQUESTS.FAILURE,
            () => {
                this.setState({ isFetching: false });
                this.setState({ isrefresh: false });

            },
            () => {
                this.setState({ isFetching: false });
                this.setState({ isrefresh: false });

            },
            true,
            isConcat
        );
    };

    renderItem = ({ item, index }, onDelete, goTo) => {

        return (
            <MainCard
                item={item}
                onDelete={onDelete}
                goTo={goTo}
                routeName={true}
            />
        );
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isrefresh}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.activeRequests}
                    renderItem={item =>
                        this.renderItem(item, this.props.onDelete, data =>
                            push("availableJobsDetail", {
                                data,
                                screen: "received"
                            })
                        )
                    }
                />
              
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, activeRequests }) => ({
    user: user.data,
    activeRequests: activeRequests.data
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    InvitationReceived
);
