import React, { Component } from "react";
import { View, Text } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, MainCard } from "../../components";
import { API_REJECTED_INVITATION } from "../../services/WebService";
import { push } from "../../services/NavigationService";
import styles from "./styles";

import { generalAction } from "../../actions/GeneralActions";
import { LIST_REJECT_REQUESTS } from "../../actions/ActionTypes";

class InvitationRejected extends Component {
    state = {
        isFetching: false
    };

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {



        const { user } = this.props;
        this.setState({ isFetching: true });


        this.props.generalAction(
            API_REJECTED_INVITATION,
            {
                user_id: user.id,
                user_type: "contractor"
            },
            LIST_REJECT_REQUESTS.SUCCESS,
            LIST_REJECT_REQUESTS.FAILURE,
            () => this.setState({ isFetching: false }),
            () => this.setState({ isFetching: false }),
            true,
            isConcat
        );
    };

    renderItem = ({ item, index }, goTo) => {

        return (
            <MainCard
                item={item}
                onDelete={() => {}}
                isClosedItem
                goTo={goTo}
                pending={"Rejected"}
                routeName={true}
            />
        );
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.rejectRequests}
                    renderItem={item =>
                        this.renderItem(item, data =>
                            push("rejectedDetail", {
                                contract_id: data.contract_id,
                                invitation_id: data.invitation_id
                            })
                        )
                    }
                />
              
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, rejectRequests }) => ({
    user: user.data,
    rejectRequests: rejectRequests.data
});

export default connect(mapStateToProps, actions)(InvitationRejected);
