import React, { Component } from "react";
import { View, Text } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, MainCard } from "../../components";
import { API_CONTRACTOR_INVITATION } from "../../services/WebService";
import { push } from "../../services/NavigationService";
import styles from "./styles";

import { generalAction } from "../../actions/GeneralActions";
import { LIST_CLOSE_REQUESTS } from "../../actions/ActionTypes";

class InvitationSent extends Component {
    state = {
        isFetching: false,

    };

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { user } = this.props;
        this.setState({ isFetching: true });

        this.props.generalAction(
            API_CONTRACTOR_INVITATION,
            {
                user_id: user.id,
                invitation_type: "received",
                invitation_status: "pending",
                is_onboarded: 0,
                is_onboarded: "active",
                page
            },
            LIST_CLOSE_REQUESTS.SUCCESS,
            LIST_CLOSE_REQUESTS.FAILURE,
            () => this.setState({ isFetching: false }),
            () => this.setState({ isFetching: false }),
            true,
            isConcat
        );


    };

    renderItem = ({ item, index }, goTo) => {

        return (
            
            <MainCard
                item={item}
                onDelete={() => {}}
                isClosedItem
                goTo={goTo}
                pending={"Pending..."}
                routeName={true}
            />

        );
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.closeRequests}
                    renderItem={item =>
                        this.renderItem(item, data =>
                            push("contractorInvitationDetail", {
                                data,
                                screen: "received"
                            })
                        )
                    }
                />
              
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, closeRequests }) => ({
    user: user.data,
    closeRequests: closeRequests.data
});

export default connect(mapStateToProps, actions)(InvitationSent);
