import React, { Component } from "react";
import {
    View,
} from "react-native";
import { connect } from "react-redux";
import { compose } from "redux";
import { HeaderTabs,Supporticon } from "../../components";
import styles from "./styles";
import { push } from "../../services/NavigationService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { WithFetching } from "../../HOC";
import InvitationReceived from "./InvitationReceived";
import InvitationSent from "./InvitationSent";
import InvitationRejected from "./InvitationRejected";

class ContractorInvitation extends Component {
    constructor(props) {
        super(props);
        this.activeTab = React.createRef();
        this.filterCategories = this.filterCategories.bind(this);
        this.state = {
            showInput: false
        };
    }

    componentDidMount() {
        this.props.navigation.setParams({
            filterCategories: this.filterCategories
        });
    }

    filterCategories = () => {
        this.setState({ showInput: !this.state.showInput });
    };

    render() {
        return (
            <View style={styles.container}>
                <HeaderTabs>
                    <InvitationRejected tabLabel="REJECTED" />
                    <InvitationReceived
                        tabLabel="RECEIVED"
                        onDelete={this.onDelete}
                        ref={ref => (this.activeTab = ref)}
                    />
                    <InvitationSent tabLabel="SENT" />
                </HeaderTabs>

                <Supporticon
                 clickBtn={() =>push("Support")}/>
            </View>
        );
    }
}

const actions = { generalAction, generalSaveAction };

const DetailComponentCompose = compose(
    connect(mapStateToProps, actions)(WithFetching(ContractorInvitation))
);

export default DetailComponentCompose;

DetailComponentCompose.navigationOptions = ({ navigation }) => {
    const { state } = navigation;
    const params = state.params || {};
    return {
        headerStyle: styles.header,
        headerRight: null
    };
};
