import _ from "lodash";
import PropTypes from "prop-types";
import { connect } from "react-redux";
import React, { Component } from "react";
import {
    View,
    Image,
    FlatList,
    StatusBar,
    ScrollView,
    Text
} from "react-native";
import { ButtonView, DrawerCard, Separator } from "../../components";
import { ProfileImage } from "../../appComponents";
import styles from "./styles";
import { Images, icons, colors, fonts, fontSize } from "../../assets";
import { pop, push, popToTop } from "../../services/NavigationService";
import {
    generalAction,
    generalDispatchType,
    generalSaveAction
} from "../../actions/GeneralActions";
import { DUMP, LOGOUT, ADMIN_FEE_AMOUNT } from "../../actions/ActionTypes";
import { API_LOGOUT, IMAGE_BASE_URL } from "../../services/WebService";

import Utils from "../../Utils";
import Colors from "../../services/Colors";
//navigation
class CustomDrawerContainer extends Component {
    constructor(props) {
        super(props);
        const userData = props.user.data;

        this.state = {
            image: Images.bgContractor,
            name: userData && userData.name ? userData.name : "",
            email: userData && userData.email ? userData.email : "",
            isActiveId: "1",
            errors: {},
            routes: [
                {
                    id: "1",
                    title: "Home",
                    route: "CustomerHomeStack",
                    lhsImage: icons.drawer_home,
                    IsActive: true
                },
                {
                    id: "3",
                    title: "My Profile",
                    route: "profile",
                    lhsImage: icons.ic_perm_identity,
                    IsActive: false
                },
                {
                    id: "4",
                    title: "Settings",
                    route: "settings",
                    lhsImage: icons.ic_settings,
                    IsActive: false
                },
                {
                    id: "5",
                    title: "Payment Method",
                    route: "paymentMethod",
                    lhsImage: icons.ic_settings,
                    IsActive: false
                },
                {
                    id: "6",
                    title: "Logout",
                    route: "login",
                    lhsImage: icons.ic_exit_to_app,
                    IsActive: false
                }
            ]
        };
    }

    componentDidMount() {
        this.setDrawer();
    }

    setDrawer() {
        const { user, navigation } = this.props;
        let { routes } = this.state,
            loginUser = navigation.getParam("user") || user.data,
            contractor = {
                id: "2",
                title: "My Earnings",
                route: "myEarnings",
                lhsImage: icons.ic_payment,
                IsActive: false
            },
            facility = {
                id: "2",
                title: "Find Staff",
                route: "findHealthContractors",
                lhsImage: icons.search_icon_white,
                IsActive: false
            };
        if (loginUser.user_type === "Facility") {
            routes.splice(1, 0, facility);
        } else if (loginUser.user_type === "Contractor") {
            routes.splice(1, 0, contractor);
        }
        this.setState({ routes });
    }

    shouldComponentUpdate(nextProps: Object, nextState: Object) {
        return (
            !_.isEqual(nextProps, this.props) ||
            !_.isEqual(nextState, this.state)
        );
    }

    _renderItems = item => {
        return (
            <View style={{ flexDirection: "row" }}>
                <DrawerCard
                    //backgroundColor={this.state.isActiveId === item.id ? 'rgba(52, 52, 52, 0.2)' : 'transparent'}
                    backgroundColor={"transparent"}
                    title={item.title}
                    lhsImage={item.lhsImage}
                    onPress={() => this.onItemPress(item)}
                    badgeValue={null}
                />
            </View>
        );
    };

    onItemPress(item) {
        this.setState({ isActiveId: item.id });
        this.props.navigation.closeDrawer();
        this.props.navigation.navigate(item.route);

        if (item.title === "Logout") {
            const { user, navigation } = this.props;
            let loginUser = navigation.getParam("user") || user.data;

            this.props.generalSaveAction(ADMIN_FEE_AMOUNT, { amount: 0})

            let payload = new FormData();
            payload.append("user_id", loginUser.id);

            this.props.generalAction(
                API_LOGOUT,
                payload,
                DUMP.SUCCESS,
                DUMP.FAILURE,
                () => {
                    this.props.generalDispatchType(LOGOUT);
                },
                () => { }
            );
        }
    }

    render() {
        const { navigation, user } = this.props;
        const { image, name, email, errors, routes } = this.state;
        const userData = user.data;

        return (
            <ScrollView
                style={styles.scroll}
                contentContainerStyle={{
                    height: 736
                }}
                overScrollMode="always"
                keyboardShouldPersistTaps="never"
                showsVerticalScrollIndicator={false}
                ref={ref => {
                    this.scrollView = ref;
                }}
            >
                <View style={styles.container}>
                    <View
                        style={{
                            flex: 2.8,
                            justifyContent: "center"
                        }}
                    >
                        <View
                            style={{ alignItems: "flex-start", marginLeft: 20 }}
                        >
                            <ProfileImage
                                nameColor={colors.WhiteColor}
                                emailColor={"#5D8FB2"}
                                nameType={fonts.bold}
                                nameSize={fontSize.xxLarge}
                                emailType={fonts.regular}
                                emailSize={fontSize.small}
                                btnViewStyle={{}}
                                textStyle={{ textAlign: "left" }}
                                onPress={() => navigation.navigate("profile")}
                                data={user.data}
                                imageValidation
                                imageSize={styles.acceptRideImageSize}
                            />
                        </View>
                    </View>
                    <Separator
                        style={{
                            backgroundColor: "#5D8FB2",
                            marginHorizontal: 20,
                            marginBottom: 25
                        }}
                    />

                    <View
                        style={{
                            flex: 7,
                            justifyContent: "center",
                            marginHorizontal: 20
                        }}
                    >
                        <FlatList
                            extraData={this.state}
                            data={this.state.routes}
                            showsVerticalScrollIndicator={false}
                            keyExtractor={(item, index) =>
                                "" + item.title + index
                            }
                            renderItem={({ item }) => this._renderItems(item)}
                        />
                    </View>
                </View>
            </ScrollView>
        );
    }
}

const mapStateToProps = state => ({
    networkInfo: state.networkInfo,
    user: state.user
});

const actions = { generalAction, generalDispatchType, generalSaveAction };

export default connect(mapStateToProps, actions)(CustomDrawerContainer);
