import React, { Component } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    ScrollView,
    TouchableWithoutFeedback
} from "react-native";
import { connect } from "react-redux";
import PostTypeSelection from "../ShiftHome/postTypeSelection";
import { compose } from "redux";
import { pop, push, popToTop } from "../../services/NavigationService";
import { Images, icons, colors ,UIFont, fonts, fontSize } from "../../assets";
import {
    DetailCard,
    Separator,
    TextLabel,
    FooterDetail,
    LappingProfile,
    ReusableModal,
    RequestsCard,Supporticon
} from "../../components";
import StarRating from "react-native-star-rating";
import {
    API_DELETE_CONTRACT,
    API_GET_CONTRACTOR,
    API_USER_RATING_CHECK
} from "../../services/WebService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import { WithFetching } from "../../HOC";
import { IMAGE_BASE_URL } from "../../services/WebService";
import {
    DeleteModal,
    InfoModal,
    InfoMileage,
    AllInfo
} from "../../appComponents/ModalComponents";
import Utils from "../../Utils";
import moment from "moment";
import styles from "./styles";
import { API_KEY_GOOGLE } from "../../constants";
import { selectPostDetails } from "../../reduxSelectors";

class DetailScreen extends Component {
    constructor(props) {
        super(props);
        this.state = {
            whichModal: "",
            maxRadius: props.route.params.data.maximum_radius,
            contractor: {},
            ratingUser: 0
        };

    }

    componentDidMount() {
        this.fetchData();
        this.fetchRating();
        const { data, isClosedItem } = this.props.route.params,
            { contract_type, cost_per_mile } = data;
        this.props.navigation.setParams({
            infoRDelete: this.infoRDelete,
            boo:
                contract_type == "Shift" && cost_per_mile == null
                    ? null
                    : cost_per_mile,
            showDeleteIcon: isClosedItem ? false : true
        });
    }

    infoRDelete = whichModal => {
        this.setState({ whichModal }, () => {
            this.showModal();
        });
    };

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { contractor_id } = this.props.route.params.data;
        this.setState({ isFetching: true });
        this.props.generalAction(
            API_GET_CONTRACTOR,
            {
                user_id: contractor_id
            },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            data => {
                this.setState({
                    isFetching: false,
                    contractor: data
                });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    fetchRating = (isConcat: boolean = false, page: Number = 1) => {
        const { contract_id } = this.props.route.params.data,
            { data } = this.props.user;
        this.props.generalAction(
            API_USER_RATING_CHECK,
            {
                user_id: data.id,
                contract_id: contract_id,
                user_role: "facility"
            },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            data => {
                this.setState({
                    ratingUser: +data[0].rating
                });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    DeleteContract = () => {
        const { contract_id } = this.props.route.params.data;
        this.props.generalAction(
            API_DELETE_CONTRACT,
            { id: contract_id },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.onDeleteSuccess,
            this.onDeleteFailure,
            true
        );
        this.props.cbShowLoader(true);
        pop();
    };

    onDeleteSuccess = user => {
        this.props.cbShowLoader(false);
        Utils.showMessage(
            "Success",
            "Contract deleted successfully",
            "success"
        );
    };

    onDeleteFailure = err => {
        this.props.cbShowLoader(false);
        Utils.showError(err);
    };

    showModal = modal => {
        this.setState({ modal });
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.setState({ boo: false });
        this.Modal.setModalVisible(false);
    };

    renderModal = () => {
        const { whichModal, maxRadius } = this.state;
        const {
            contract_type,
            cost_per_mile,
            contract_invitations,
            latitude,
            longitude,
            contract_status,
            shift_end_time,
            shift_start_time,
            hourly_pay_rate,
            contract_rate,
            total_hours
        } = this.props.route.params.data;
        let totalRadius = maxRadius;
        let rate =
            hourly_pay_rate === null
                ? contract_rate &&
                contract_rate.slice(0, contract_rate.indexOf("."))
                : hourly_pay_rate &&
                hourly_pay_rate.slice(0, hourly_pay_rate.indexOf("."));
        if (contract_status == "close") {
            if (Array.isArray(contract_invitations)) {
                let dist = Utils.distance(
                    latitude,
                    longitude,
                    contract_invitations[0].invitation_latitude,
                    contract_invitations[0].invitation_longitude
                );
                totalRadius = dist > maxRadius ? maxRadius : dist;
            } else {
                let dist =
                    contract_invitations.invitation_latitude == null
                        ? maxRadius
                        : Utils.distance(
                            contract_invitations.invitation_latitude,
                            contract_invitations.invitation_longitude,
                            contract_invitations.latitude,
                            contract_invitations.longitude
                        );
                totalRadius = dist > maxRadius ? maxRadius : dist;
            }
        }

        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={styles.modalContainer}>
                        <View style={styles.modalInner}>
                            {whichModal == "delete" && (
                                <DeleteModal
                                    deleteContract={this.DeleteContract}
                                    hideModal={this.hideModal}
                                    text1={"Are you sure you want to delete"}
                                    text2={`this ${contract_type}?`}
                                />
                            )}
                            {whichModal == "allInfo" && (
                                <AllInfo note={this.props.note} />
                            )}
                            {whichModal == "info" && (
                                <InfoModal
                                    costMile={cost_per_mile}
                                    maxRadius={totalRadius}
                                    contract_status={"close"}
                                />
                            )}
                            {whichModal == "mileage" && (
                                <InfoMileage
                                    rate={rate}
                                    contract_type={contract_type}
                                    diffTime={total_hours}
                                />
                            )}
                        </View>
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };

    heading(label) {
        return (
            <TextLabel
                type="medium"
                size="medium"
                color={"black"}
                style={styles.boldText}
            >
                {label}
            </TextLabel>
        );
    }

    footer(data, isClosedItem) {
        return (
            <FooterDetail
                style={{ position: "absolute", bottom: 0 }}
                text={isClosedItem ? null : "INVITE STAFF"}
                backgroundColor={
                    isClosedItem ? null : { backgroundColor: "#08548c" }
                }
                textColor={{ color: "#ffffff" }}
                clickBtn={() =>
                    isClosedItem
                        ? () => { }
                        : push("inviteContractors", { id: data.contract_id })
                }
            />
        );
    }

    paragraph(para, style, numberOfLines) {
        return (
            <Text style={style} numberOfLines={numberOfLines}>
                {para}
            </Text>
        );
    }

    renderMap = (latitude, longitude) => {
        const baseUrl = "https://maps.googleapis.com/maps/api/staticmap";
        const markerCenter = `center=${latitude},${longitude}`;
        const API_KEY = `key=${API_KEY_GOOGLE}`;
        const zoomLevel = "zoom=16";
        const imageSize = `size=400x400`;
        const customMarkerIcon = `markers=icon:https://assets.mapquestapi.com/icon/v2/circle.png%7Clabel:C%7C${latitude},${longitude}`;
        const mapImageUrl = `${baseUrl}?${markerCenter}&${zoomLevel}&${imageSize}&${API_KEY}&${customMarkerIcon}`;
        return (
            <View style={styles.mapStyle}>
                <Image
                    source={{ uri: mapImageUrl }}
                    style={{ width: "100%", height: "100%", borderRadius: 6 }}
                />
            </View>
        );
    };

    rateCard = () => {
        const { data, isClosedItem } = this.props.route.params,
            { contract_id, contractor_id, user_id } = data,
            { ratingUser } = this.state;
        return (
            <View
                style={{
                    height: 60,
                    width: "100%",
                    flexDirection: "row",
                    paddingHorizontal: 20,
                    paddingTop: 25,
                    justifyContent: "space-between"
                }}
            >
                <TouchableOpacity
                    onPress={() =>
                        ratingUser > 0
                            ? null
                            : push("rating", {
                                userType: "facility",
                                contract_id,
                                contractor_id,
                                facility_id: user_id
                            })
                    }
                >
                    <Text style={styles.rateText}>
                        {ratingUser > 0 ? "Average Rating" : "Rate Clinician"}
                    </Text>
                </TouchableOpacity>
                {ratingUser > 0 ? (
                    <View style={{ flex: 0.3 }}>
                        <StarRating
                            disabled={true}
                            maxStars={5}
                            rating={ratingUser}
                            starSize={14}
                            fullStarColor={"rgb(255,186,73)"}
                        />
                    </View>
                ) : null}
            </View>
        );
    };

    calculateDiffTime = (b, a) => {
        let dif = moment(b, "HH:mm:a").diff(moment(a, "HH:mm:a"));
        let diffTime = moment.duration(dif).hours();
        return +diffTime == 0 ? 1 : diffTime;
    };

    render() {
        const { data, isClosedItem } = this.props.route.params,
            { user } = this.props;
        let rate =
            data.hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0, data.contract_rate.indexOf("."))
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0,
                    data.hourly_pay_rate.indexOf(".")
                );
        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * data.total_hours;

        if (
            data.contract_invitations[0] !== undefined &&
            data.contract_invitations[0].bid_amount !== null &&
            data.contract_invitations[0].bid_amount !== "0.00"
        ) {
            let dist = Utils.distance(
                data.latitude,
                data.longitude,
                data.contract_invitations[0].invitation_latitude,
                data.contract_invitations[0].invitation_longitude
            );
            let totalRadius =
                dist > data.maximum_radius ? data.maximum_radius : dist;
            rate =
                data.contract_type === "Contract"
                    ? data.contract_invitations[0].bid_amount
                    : data.contract_invitations[0].bid_amount /
                    data.total_hours;

            let bidsAmount = data.contract_invitations[0].bid_amount;
            bidAmount = +bidsAmount + totalRadius * +data.cost_per_mile;
        }
        if (
            data.contract_invitations[0] !== undefined &&
            data.contract_invitations[0].bid_amount !== null &&
            data.contract_invitations[0].bid_amount == "0.00"
        ) {
            let dist = Utils.distance(
                data.latitude,
                data.longitude,
                data.contract_invitations[0].invitation_latitude,
                data.contract_invitations[0].invitation_longitude
            );
            let totalRadius =
                dist > data.maximum_radius ? data.maximum_radius : dist;

            bidAmount += +totalRadius;
        }
        if (
            data.contract_invitations[0] !== undefined &&
            data.contract_invitations[0].bid_amount == null &&
            data.contract_type === "Shift"
        ) {
            let dist = Utils.distance(
                data.latitude,
                data.longitude,
                data.contract_invitations[0].invitation_latitude,
                data.contract_invitations[0].invitation_longitude
            );
            let totalRadius =
                dist > data.maximum_radius ? data.maximum_radius : dist;

            bidAmount += +totalRadius * +data.cost_per_mile;
        }
        return (
            <React.Fragment>
                <ScrollView>
                    <DetailCard
                        data={data}
                        user={user.data}
                        cbMileage={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.infoRDelete("info")
                        }
                        cbTotal={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.infoRDelete("mileage")
                        }
                        style={{ backgroundColor: "#ffffff" }}
                    />
                    <Separator style={styles.separatorStyle} />
                    {this.heading("Description")}
                    {this.paragraph(
                        data.description,
                        styles.descriptionStyle,
                        2
                    )}
                    <Separator style={styles.separatorStyle} />
                    {!isClosedItem &&
                        data.contract_invitations.length > 0 &&
                        this.heading("Requests")}
                    {!isClosedItem && data.contract_invitations.length > 0 && (
                        <View
                            style={{ marginVertical: 20, marginHorizontal: 15 }}
                        >
                            <LappingProfile
                                requests={data.contract_invitations.map(
                                    elem => IMAGE_BASE_URL + elem.image_url
                                )}
                                onRequests={() =>
                                    push("requests", { id: data.contract_id,userid:data.contract_invitations[0].user_id })
                                }
                            />
                        </View>
                    )}
                    {!isClosedItem && data.contract_invitations.length > 0 && (
                        <Separator style={styles.separatorStyle} />
                    )}
                    {/*isClosedItem && (
            <RequestsCard
              style={{ backgroundColor: "#ffffff" }}
              request={"received"}
              item={this.state.contractor}
              bidAmount={bidAmount}
              showSeperator={true}
              goTo={() =>
                push("contractorDetail", {
                  data: { user_id: data.contractor_id },
                  showFooter: false
                })
              }
            />
            )*/}

                    {isClosedItem && this.rateCard()}
                    {/*isClosedItem && <Separator style={styles.separatorStyle} />*/}
                    {this.paragraph(
                        data.location_address,
                        styles.locationStyle,
                        1
                    )}
                    {this.renderMap(data.latitude, data.longitude)}
                </ScrollView>
                {this.footer(data, isClosedItem)}
                {this.renderModal()}

                <Supporticon
                 clickBtn={() =>push("Support")}/>
            </React.Fragment>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ user, infoContent }, ownProps) => {
    return {
        data: selectPostDetails(ownProps),
        user,
        note: infoContent.data.content
    };
};

const DetailComponentCompose = compose(
    connect(mapStateToProps, actions)(WithFetching(DetailScreen))
);

export default DetailComponentCompose;

DetailComponentCompose.navigationOptions = ({ navigation }) => {
    const { state } = navigation;
    const params = state.params || {};
    return {
        headerStyle: styles.header,
        headerRight: (
            <View style={{ flexDirection: "row" }}>
                {params.showDeleteIcon && (
                    <TouchableOpacity
                        onPress={() =>
                            params.infoRDelete && params.infoRDelete("delete")
                        }
                    >
                        <Image
                            style={{ margin: 10 }}
                            resizeMode="contain"
                            source={Images.Trash}
                        />
                    </TouchableOpacity>
                )}
                {params.boo && (
                    <TouchableOpacity
                        onPress={() =>
                            params.infoRDelete && params.infoRDelete("allInfo")
                        }
                    >
                        <Image
                            style={{ margin: 10 }}
                            resizeMode="contain"
                            source={icons.ic_info}
                        />
                    </TouchableOpacity>
                )}
            </View>
        )
    };
};
