import React, { Component } from "react";
import { connect } from "react-redux";
import { View, StyleSheet, TouchableOpacity, Text, Image } from "react-native";
import _, { thru } from "lodash";
import { DocumentImages, AppButton } from "../../components";
import { pop, popToTop, push } from "../../services/NavigationService";
import { Images, colors, icons } from "../../assets";
import { WithFetching } from "../../HOC";
import { UPLOAD_TYPE_IMAGE, UPLOAD_TYPE_DOC } from "../../constants";
import { compose } from "redux";

import { DUMP, USER } from "../../actions/ActionTypes";
import { generalAction } from "../../actions/GeneralActions";
import {
    API_DOCUMENTLIST, POST_API_RESGISTER_STEP3,
    API_DELETE_CONTRACTOR_MEDIA
} from "../../services/WebService";
import Utils from "../../Utils";

class DocumentRegister extends Component {
    constructor(props) {
        super(props);

        const { user } = this.props;

        this.state = {
            expiryDate: '',
            showdate: false,
            isError: false,
            isDetailsEdited: false,
            user_id: this.props.route.params.user_ID,
            deletedImagesIds: [],
            addedImages: [],
            isHepatitisMarked: '',
            images: [],
            length:0,
            documentdata: this.props.route.params.documents_val == undefined ?
                user.documents : this.props.route.params.documents_val,

        };

    }

    componentDidMount() {

        this.Getdata();


    }

    Getdata = () => {

        this.props.generalAction(
            API_DOCUMENTLIST,
            {},
            USER.SUCCESS,
            USER.FAILURE,
            (data) => {

                this.setState({ addedImages: data })
                this.setState({ length: this.state.addedImages.length })

                this.setimagedata();
            },
            (response) => {
            },
            true

        );
    }


    setimagedata = () => {

        const data = this.state.documentdata;
        let imagearray = [];

        for (var i = 0; i <= this.state.addedImages.length; i++) {
            var documentsource = this.state.addedImages[i].source;
            var documenttitle = this.state.addedImages[i].title;
            var documenterror = this.state.addedImages[i].validation;
            var documentSourceType = this.state.addedImages[i].source_type;

            for (let passdata in data) {


                var documentdata = {};

                if (passdata == documentsource) {

                    documentdata["title"] = documenttitle;
                    documentdata["images"] = [{ uri: Images.addImage }, ...data[passdata]];
                    documentdata["key"] = documentsource + "[]";
                    documentdata["validation"] = JSON.parse(documenterror);
                    documentdata["source_type"] = documentSourceType;
                    documentdata["isError"] = false;

                    imagearray.push(documentdata);
                    this.setState({ images: imagearray })
                }
            }


        }

      

    }

    uploadDocuments = payload => {

        this.props.cbShowLoader(true);
        this.props.generalAction(
            POST_API_RESGISTER_STEP3,
            payload,
            USER.SUCCESS,
            DUMP.FAILURE,
            (data) => {

                this.props.cbShowLoader(false);
                setTimeout(() => {
                    Utils.showMessage(
                        "Success",
                        "Documents uploaded successfully",
                        "success"
                    );


                }, 500);
                setTimeout(() => {
                    // popToTop();

                    const user_ID = this.state.user_id;

                    push("bankDetails", { user_ID });
                }, 1000);
            },
            () => this.props.cbShowLoader(false)
        );
    };

    createUploadDocumentPayload = () => {
        const { expiryDate, images, isHepatitisMarked, user_id } = this.state;


        if (expiryDate) {
            const payload = new FormData();
            images.map(categories =>
                categories.images.map(
                    (imgObj, index) =>
                        index &&
                        !imgObj.id &&
                        payload.append(categories.key, {
                            uri: imgObj.uri,
                            type:
                                imgObj.type === UPLOAD_TYPE_DOC
                                    ? UPLOAD_TYPE_DOC
                                    : UPLOAD_TYPE_IMAGE,
                            name: "image"
                        })
                )
            );
            payload.append("medical_license_expiry_date", expiryDate);
            payload.append("user_id", user_id);
            payload.append(
                "hepatitis_b_vaccine",
                isHepatitisMarked ? "yes" : "no"
            );


            this.uploadDocuments(payload);
        } else {

            this.setState({ isError: true });

        }


    };

    deleteImagesOnServer = () => {
        const { userId } = this.props;
        const { deletedImagesIds, user_id } = this.state;
        const payload = new FormData();
        payload.append("user_id", user_id);

        deletedImagesIds.map((id, index) =>
            payload.append(`media_id[${index}]`, id)
        );
        payload.append("delete_type", "other");

        this.props.cbShowLoader(true);
        this.props.generalAction(
            API_DELETE_CONTRACTOR_MEDIA,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            () => {
                this.props.cbShowLoader(false);
                setTimeout(() => {
                    this.createUploadDocumentPayload();
                }, 500);
            },
            () => {
                this.props.cbShowLoader(false);
                setTimeout(() => {
                    Utils.showMessage(
                        "Error",
                        "Failed to delete images press submit again"
                    );
                }, 500);
            }
        );
    };

    validateFields = () => {
        let isError = false;
        const docsErrorIndexes = [];
        const { images } = this.state;
        const tempImages = _.cloneDeep(images);

        tempImages.map((docsImages, index) => {
            if (docsImages.images.length == 1) {
                if (docsImages.validation == true) {
                    tempImages[index].isError = true;
                    isError = true;
                }
            }
        });

        if (isError) this.setState({ images: tempImages });

        return !isError;
    };

    popToPreviousScreen = () => {

        if (this.validateFields()) {

            const { deletedImagesIds } = this.state;

            if (deletedImagesIds.length) {

                this.deleteImagesOnServer();


            } else {


                this.createUploadDocumentPayload();
            }

        }

    };

    cbOnHepatitisStateChange = () => this.setState({});

    cbOnDateChange = (expiryDate) => {

        this.setState({ expiryDate, isError: false });

    }



    onChangeState = (images, removedItem) => {

        removedItem &&
            removedItem.length &&
            removedItem[0].id &&
            this.state.deletedImagesIds.push(removedItem[0].id);

        this.setState({ images, isDetailsEdited: true });

    };

    agreementPart = () => {
        return (
            <View
                style={{
                    flexDirection: "row",
                    marginHorizontal: 20,
                    marginBottom: 60
                }}
            >
                <TouchableOpacity
                    style={{ padding: 5, marginTop: 20 }}
                    onPress={() => {
                        this.setState({
                            isHepatitisMarked: !this.state.isHepatitisMarked,
                            isDetailsEdited: true
                        });
                    }}
                >
                    <Image
                        source={
                            this.state.isHepatitisMarked
                                ? icons.ic_check
                                : icons.ic_uncheck
                        }
                    />
                </TouchableOpacity>

                <Text style={[styles.otherDocument, { marginTop: 28 }]}>
                    Hepatitis B Vaccine (Not Mandatory)
                </Text>
            </View>
        );
    };

    render() {
        const { expiryDate, isDetailsEdited,length, images, isError } = this.state;

        return (
            <View style={styles.container}>

                {images.length > length -1  ?
                    <DocumentImages
                        data={{
                            expiryDate,
                            isError,
                            images
                        }}
                        onChangeState={this.onChangeState}
                        cbOnDateChange={this.cbOnDateChange}
                        showLicenceAndDeleteIcons={true}
                    />
                    : null}
                {this.agreementPart()}

                <View style={{
                    flexDirection: "row", alignItems: 'center', alignSelf: 'center',
                    alignContent: 'center'
                }}>

                    <View style={styles.buttonStyle}>
                        <AppButton
                            buttonTitle="Next"
                            style={{
                                backgroundColor: colors.ActiveTabTitle,
                                width: "100%", alignItems: 'center'
                            }}
                            btnColor={colors.cardColor}
                            onPress={this.popToPreviousScreen}

                        />

                    </View>
                </View>

            </View>
        );
    }
}

const mapStateToProps = ({ categories, user }) => {
    return {
        categories: categories.data,
        user: user.data
    };
};


const actions = { generalAction };

const ComponentWithComposeFunc = compose(
    connect(
        mapStateToProps,
        actions
    )(WithFetching(DocumentRegister))
);

export default ComponentWithComposeFunc;
ComponentWithComposeFunc.navigationOptions = ({ navigation }) => {
    return {
        title: "Documentation",
        headerStyle: styles.header,
        headerTitleStyle: styles.toolbarTitle,
        headerLeft: (
            <TouchableOpacity onPress={() => popToTop()}>
                <Image
                    style={{ margin: 10 }}
                    resizeMode="contain"
                    source={Images.backArrow}
                />
            </TouchableOpacity>
        ),
        headerRight: (
            <View
                style={{
                    backgroundColor: colors.HeaderColor,
                    width: "10%"
                }}
            />
        )
    };
};
const styles = StyleSheet.create({
    container: { flex: 1 },
    footerStyle: {
        backgroundColor: colors.ActiveTabTitle,
        width: "100%",
        position: "absolute",
        bottom: 0,
        borderRadius: 0
    },
    buttonStyle: {
        width: "40%",
        alignItems: 'center',
        marginLeft: 10,
        marginBottom: 30
    },

    buttonStyleback: {
        width: "40%",
        alignItems: 'center',
        marginRight: 10,
        marginBottom: 30
    },
    toolbarTitle: {
        color: colors.WhiteColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },

    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
});