 import React, { Component } from "react";
import { connect } from "react-redux";
import { View, StyleSheet, TouchableOpacity, Text, Image } from "react-native";
import _ from "lodash";
import { DocumentImages, AppButton } from "../../components";
import { pop,popToTop } from "../../services/NavigationService";
import { Images, colors, icons } from "../../assets";
import { WithFetching } from "../../HOC";
import { UPLOAD_TYPE_IMAGE, UPLOAD_TYPE_DOC ,POST_API_RESGISTER_STEP3} from "../../constants";

import { DUMP, USER } from "../../actions/ActionTypes";
import { generalAction } from "../../actions/GeneralActions";
import {
    API_DOCUMENTLIST,
    API_UPDATE_CONTRACTOR_DOC,
    API_DELETE_CONTRACTOR_MEDIA
} from "../../services/WebService";
import Utils from "../../Utils";

class Documents extends Component {
    constructor(props) {
        super(props);
        const { data } = props.route.params;

        
        const imagesdata = this.props.navigation.getParam("imagesdata");
        const {
            hepatitis_b_vaccine } = data;

        this.state = {
            expiryDate: data.medical_license_expiry_date,
            isError: false,
            isDetailsEdited: false,
            deletedImagesIds: [],
            addedImages: [],
            isHepatitisMarked: hepatitis_b_vaccine === "yes",
            images: JSON.parse(imagesdata)  
        };

    }
   
    getData = () => this.props.route.params.data;

    uploadDocuments = payload => {

        this.props.cbShowLoader(true);
        this.props.generalAction(
            API_UPDATE_CONTRACTOR_DOC,
            payload,
            USER.SUCCESS,
            DUMP.FAILURE,
            (data) => {

                this.props.cbShowLoader(false);
                setTimeout(() => {
                    Utils.showMessage(
                        "Success",
                        "Documents uploaded successfully",
                        "success"
                    );
                }, 500);
                setTimeout(() => {
                    popToTop();
                }, 1000);
            },
            () => this.props.cbShowLoader(false)
        );
    };

    createUploadDocumentPayload = () => {
        const { expiryDate, images, isHepatitisMarked } = this.state;

        if (expiryDate) {
            const payload = new FormData();
            images.map(categories =>
                categories.images.map(
                    (imgObj, index) =>
                        index &&
                        !imgObj.id &&
                        payload.append(categories.key, {
                            uri: imgObj.uri,
                            type:
                                imgObj.type === UPLOAD_TYPE_DOC
                                    ? UPLOAD_TYPE_DOC
                                    : UPLOAD_TYPE_IMAGE,
                            name: "image"
                        })
                )
            );
            payload.append("medical_license_expiry_date", expiryDate);
            payload.append("user_id", this.props.userId);
            payload.append(
                "hepatitis_b_vaccine",
                isHepatitisMarked ? "yes" : "no"
            );

            
            this.uploadDocuments(payload);
        } else {
            this.setState({ isError: true });
        }
       

    };

    deleteImagesOnServer = () => {
        const { userId } = this.props;
        const { deletedImagesIds } = this.state;
        const payload = new FormData();
        payload.append("user_id", userId);

        deletedImagesIds.map((id, index) =>
            payload.append(`media_id[${index}]`, id)
        );
        payload.append("delete_type", "other");

        this.props.cbShowLoader(true);
        this.props.generalAction(
            API_DELETE_CONTRACTOR_MEDIA,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            () => {
                this.props.cbShowLoader(false);
                setTimeout(() => {
                    this.createUploadDocumentPayload();
                }, 500);
            },
            () => {
                this.props.cbShowLoader(false);
                setTimeout(() => {
                    Utils.showMessage(
                        "Error",
                        "Failed to delete images press submit again"
                    );
                }, 500);
            }
        );
    };

    validateFields = () => {
        let isError = false;
        const docsErrorIndexes = [];
        const { images } = this.state;
        const tempImages = _.cloneDeep(images);

        tempImages.map((docsImages, index) => {
            if (docsImages.images.length == 1) {
                if(docsImages.validation == true){    
                    tempImages[index].isError = true;
                    isError = true;
                   }
            }
        });

        if (isError) this.setState({ images: tempImages });

        return !isError;
    };

    popToPreviousScreen = () => {
        if (this.validateFields()) {


            const { deletedImagesIds } = this.state;

            if (deletedImagesIds.length) {

                this.deleteImagesOnServer();

            } else {

                this.createUploadDocumentPayload();
            }

        }

    };

    cbOnHepatitisStateChange = () => this.setState({});

    cbOnDateChange = expiryDate =>
        this.setState({ expiryDate, isDetailsEdited: true });

    onChangeState = (images, removedItem) => {
        removedItem &&
            removedItem.length &&
            removedItem[0].id &&
            this.state.deletedImagesIds.push(removedItem[0].id);

        this.setState({ images, isDetailsEdited: true });

    };

    agreementPart = () => {
        return (
            <View
                style={{
                    flexDirection: "row",
                    marginHorizontal: 20,
                    marginBottom: 60
                }}
            >
                <TouchableOpacity
                    style={{ padding: 5, marginTop: 20 }}
                    onPress={() => {
                        this.setState({
                            isHepatitisMarked: !this.state.isHepatitisMarked,
                            isDetailsEdited: true
                        });
                    }}
                >
                    <Image
                        source={
                            this.state.isHepatitisMarked
                                ? icons.ic_check
                                : icons.ic_uncheck
                        }
                    />
                </TouchableOpacity>

                <Text style={[styles.otherDocument, { marginTop: 28 }]}>
                    Hepatitis B Vaccine (Not Mandatory)
                </Text>
            </View>
        );
    };

    render() {
        const { expiryDate, isDetailsEdited, images, isError } = this.state;
        return (
            <View style={styles.container}>
                <DocumentImages
                    data={{
                        expiryDate,
                        isError,
                        images
                    }}
                    onChangeState={this.onChangeState}
                    cbOnDateChange={this.cbOnDateChange}
                    showLicenceAndDeleteIcons={true}
                />
                {this.agreementPart()}
                {isDetailsEdited && (
                    <AppButton
                        buttonTitle="Submit"
                        style={styles.footerStyle}
                        btnColor={colors.cardColor}
                        onPress={this.popToPreviousScreen}
                    />
                )}
            </View>
        );
    }
}

const mapStateToProps = ({ categories, user }) => {
    return {
        categories: categories.data,
        userId: user.data.id
    };
};

const actions = { generalAction };

export default connect(mapStateToProps, actions)(WithFetching(Documents));

const styles = StyleSheet.create({
    container: { flex: 1 },
    footerStyle: {
        backgroundColor: colors.ActiveTabTitle,
        width: "100%",
        position: "absolute",
        bottom: 0,
        borderRadius: 0
    }
});
