import React, { Component } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    ScrollView,
    TouchableWithoutFeedback
} from "react-native";
import { connect } from "react-redux";
import { TextLabel, Separator, Slider, AppButton ,Supporticon} from "../../components";
import ActionSheet from "react-native-actionsheet";
import { colors, icons } from "../../assets";
import { pop } from "../../services/NavigationService";
import DatePicker from "react-native-datepicker";
import moment from "moment";
import styles from "./styles";

class Filters extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={icons.ic_arrow_backward_black}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };

    constructor(props, context) {
        super(props, context);
        this.state = {
            categories: [
                { value: "Select...", id: 0 },
                { value: "Male", id: 1 },
                { value: "Female", id: 2 },
                { value: "cancel" }
            ],
            listShiftContract: [
                { value: "Select...", id: 0 },
                { value: "Shift", id: 1 },
                { value: "Contract", id: 2 },
                { value: "cancel" }
            ],
            isError: false,
            indexCategory: 0,
            indexShiftContract: 1,
            category_id: "",
            rating: 1,
            hourly_rate: 1,
            shift_start_date: "",
            shift_end_date: ""
        };
    }

    componentDidMount() {
        const { categories } = this.props;
        let arrForDropdown = [];
        categories.map(elem => {
            if (elem.child_categories_count === "0") {
                arrForDropdown.push({
                    value: elem.parent_category.category_name,
                    id: elem.parent_category.id
                });
            }
            if (typeof elem.child_categories_count == "number") {
                elem.child_categories.map(el => {
                    arrForDropdown.push({ value: el.category_name, id: el.id });
                });
            }
        });
        arrForDropdown.push({ value: "cancel" });
        arrForDropdown.unshift({ value: "Categories..." });
        this.setState({
            categories: arrForDropdown
        });
    }

    popToPreviousScreen = () => {
        const { cbOnApplyFilters, screen } = this.props.route.params,
            {
                category_id,
                rating,
                hourly_rate,
                shift_start_date,
                shift_end_date,
                listShiftContract,
                indexShiftContract
            } = this.state;
        let shiftContractValue = listShiftContract[indexShiftContract].value;
        cbOnApplyFilters && screen === "availableJobs"
            ? cbOnApplyFilters({
                  hourly_rate:
                      shiftContractValue == "Shift" && hourly_rate > 1
                          ? hourly_rate
                          : null,
                  shift_start_date,
                  contract_type: shiftContractValue,
                  contract_rate:
                      shiftContractValue == "Contract" && hourly_rate > 1
                          ? hourly_rate
                          : null,
                  shift_end_date
              })
            : cbOnApplyFilters({
                  category_id,
                  rating: rating == 1 ? null : rating,
                  hourly_rate: hourly_rate == 1 ? null : hourly_rate
              });
        pop();
    };

    showActionSheet = func => {
        func.show();
    };

    dropDown(arr, index, stateName, func, callBack) {
        return (
            <React.Fragment>
                <TouchableOpacity
                    style={[styles.categoryStyle, styles.actionSheetView]}
                    onPress={() => this.showActionSheet(func)}
                >
                    <Text
                        style={
                            index == 0
                                ? styles.zeroIndexCategoryStyle
                                : styles.textCategoryStyle
                        }
                    >
                        {arr[index].value}
                    </Text>
                    <Image style={styles.imageIcon} source={icons.ic_expand} />
                </TouchableOpacity>
                <Separator style={styles.seperatorStyle} />
                <ActionSheet
                    ref={o => (func = o)}
                    options={arr.map(elem => elem.value)}
                    cancelButtonIndex={arr.length - 1}
                    onPress={i => {
                        if (i !== arr.length - 1 && i !== 0) {
                            callBack(i);
                        }
                    }}
                />
                {this.state[stateName] === 0 &&
                    this.renderError(
                        `${
                            stateName == "indexCategory" ? "Category" : "Gender"
                        } is required`,
                        { paddingHorizontal: 20 }
                    )}
            </React.Fragment>
        );
    }

    validateStartDate(date) {
        !this.state.shift_end_date
            ? this.setState({ shift_start_date: date })
            : this.state.shift_end_date && this.state.shift_end_date < date
            ? this.setState({ startDateErr: "select valid end date" })
            : this.setState({ shift_start_date: date }, () =>
                  this.calculateDiffDate(this.state.shift_end_date, date)
              );
    }

    validateEndDate(date) {
        !this.state.shift_start_date
            ? this.setState({ shift_end_date: date })
            : this.state.shift_start_date && this.state.shift_start_date < date
            ? this.setState({ shift_end_date: date }, () =>
                  this.calculateDiffDate(date, this.state.shift_start_date)
              )
            : this.setState({ endDateErr: "select valid end date" });
    }

    calculateDiffDate(b, a) {
        var ms = moment(b, "YYYY-MM-DD").diff(moment(a, "YYYY-MM-DD"));
        let diffDays = moment.duration(ms).days();
        this.setState({ diffDays });
    }

    renderError(err, obj) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    heading(label, labelStyle) {
        return <TextLabel style={labelStyle}>{label}</TextLabel>;
    }

    datePicker(setPickedDate, dateVlue) {
        return (
            <View>
                <DatePicker
                    style={styles.datePickerInput}
                    date={dateVlue}
                    mode="date"
                    placeholder="YYYY-MM-DD"
                    format="YYYY-MM-DD"
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    showIcon={false}
                    customStyles={{
                        dateInput: styles.dateInput,
                        dateText: { color: "#040404" }
                    }}
                    onDateChange={setPickedDate}
                />
            </View>
        );
    }

    dateColumn() {
        return (
            <React.Fragment>
                <View style={{ flexDirection: "row", flex: 1, marginTop: 30 }}>
                    <View
                        style={{
                            flex: 1,
                            paddingHorizontal: 10,
                            flexDirection: "column"
                        }}
                    >
                        {this.heading("Start Date", [
                            styles.categoryLabel,
                            { marginLeft: 5 }
                        ])}
                        {this.datePicker(
                            date => this.validateStartDate(date),
                            this.state.shift_start_date
                        )}
                        {!this.state.shift_start_date &&
                            this.renderError("Start Date is required", {
                                paddingHorizontal: 5
                            })}
                        {this.state.startDateErr &&
                            this.renderError(this.state.startDateErr, {
                                paddingHorizontal: 5
                            })}
                    </View>
                    <View
                        style={{
                            flex: 1,
                            paddingHorizontal: 10,
                            flexDirection: "column"
                        }}
                    >
                        {this.heading("End Date", [
                            styles.categoryLabel,
                            { marginLeft: 5 }
                        ])}
                        {this.datePicker(
                            date => this.validateEndDate(date),
                            this.state.shift_end_date
                        )}
                        {!this.state.shift_end_date &&
                            this.renderError("End Date is required", {
                                paddingHorizontal: 5
                            })}
                        {this.state.endDateErr &&
                            this.renderError(this.state.endDateErr, {
                                paddingHorizontal: 5
                            })}
                    </View>
                </View>
            </React.Fragment>
        );
    }

    render() {
        const {
            listShiftContract,
            indexShiftContract,
            rating,
            hourly_rate,
            categories,
            indexCategory
        } = this.state;
        const screen = this.props.navigation.getParam("screen");

        return (
            <View style={styles.container}>
                {screen !== "availableJobs" &&
                    this.heading("Category", [
                        styles.categoryLabel,
                        { marginBottom: -5 }
                    ])}
                {screen !== "availableJobs" &&
                    this.dropDown(
                        categories,
                        indexCategory,
                        "indexCategory",
                        this.category,
                        i =>
                            this.setState({
                                indexCategory: i,
                                category_id: categories[i].id
                            })
                    )}
                {screen == "availableJobs" &&
                    this.heading("Select Shift or Category", [
                        styles.categoryLabel,
                        { marginBottom: -5 }
                    ])}
                {screen == "availableJobs" &&
                    this.dropDown(
                        listShiftContract,
                        indexShiftContract,
                        "indexShiftContract",
                        this.category,
                        i => this.setState({ indexShiftContract: i })
                    )}
                {screen !== "availableJobs" &&
                    this.heading("Ratings", styles.boldText)}
                {screen !== "availableJobs" && (
                    <Slider
                        minimumValue={1}
                        maximumValue={5}
                        value={rating}
                        thumbImage={icons.thumb_rating}
                        onValueChange={rating => this.setState({ rating })}
                    />
                )}
                {this.heading(
                    listShiftContract[indexShiftContract].value == "Shift"
                        ? "Hourly Rates"
                        : "Contract Rate",
                    styles.boldText
                )}
                <Slider
                    minimumValue={1}
                    maximumValue={500}
                    value={hourly_rate}
                    thumbImage={icons.thumb_dollar}
                    onValueChange={hourly_rate =>
                        this.setState({ hourly_rate })
                    }
                />
                {screen === "availableJobs" && this.dateColumn()}
                <AppButton
                    buttonTitle="APPLY"
                    style={styles.footerStyle}
                    btnColor={colors.cardColor}
                    onPress={this.popToPreviousScreen}
                />

<Supporticon style={{bottom:60}}
                 clickBtn={() =>push("Support")}/> 
            </View>
        );
    }
}

const mapStateToProps = ({ categories }) => {
    return {
        categories: categories.data
    };
};

const actions = {};

export default connect(mapStateToProps, actions)(Filters);
