import { StyleSheet, Platform } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";

export default StyleSheet.create({
    headerTitle: {
        color: colors.BlackColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#f7f7fa",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    container: {
        flex: 1,
        backgroundColor: "#f7f7fa",
        paddingTop: 30
    },
    categoryStyle: {
        width: "100%",
        flexDirection: "row",
        alignItems: "center"
    },
    seperatorStyle: {
        backgroundColor: "#707070",
        width: "95%",
        alignSelf: "center"
    },
    actionSheetView: {
        justifyContent: "space-between",
        paddingBottom: Metrics.baseMargin
    },
    zeroIndexCategoryStyle: {
        ...UIFont.font(fonts.reqular, 15, Colors.textfieldBorder),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    textCategoryStyle: {
        ...UIFont.font(fonts.reqular, 15, "#040404"),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    imageIcon: {
        marginTop: Metrics.baseMargin,
        marginRight: Metrics.baseMargin
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    categoryLabel: {
        ...UIFont.font(fonts.semiBold, 12, "#08548c"),
        marginTop: 10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    categoryValue: {
        ...UIFont.font(fonts.regular, 14, "#08548c"),
        flex: 1,
        marginTop: 45,
        marginHorizontal: 20,
        textAlign: "right",
        lineHeight: 16,
        letterSpacing: 0
    },
    boldText: {
        ...UIFont.font(fonts.semiBold, 15, colors.BlackColor),
        marginTop: 10,
        marginBottom: -10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0,
        paddingVertical: 30
    },
    footerStyle: {
        backgroundColor: colors.ActiveTabTitle,
        width: "100%",
        position: "absolute",
        bottom: 0,
        borderRadius: 0
    },
    datePickerInput: {
        width: "90%",
        borderBottomWidth: 1,
        borderColor: Colors.textfieldBorder
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6
    }
});
