import React, { Component } from "react";
import { View, StyleSheet, TouchableOpacity, Image } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, RequestsCard, SearchBox ,Supporticon} from "../../components";
import { API_GET_REQUESTS } from "../../services/WebService";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { pop, push, popToTop } from "../../services/NavigationService";

import { generalAction } from "../../actions/GeneralActions";
import { LIST_ACTIVE_REQUESTS } from "../../actions/ActionTypes";

class FindHealthContractors extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            title: "Find Health Contractors",
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={icons.ic_arrow_backward_black}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };
    constructor(props) {
        super(props);
        this.state = {
            isFetching: false
        };
    }

    componentDidMount() {
        this.fetchData();
    }

    componentDidUpdate(prevProps, prevState) {
        if (this.props.id !== prevProps.id) {
            this.fetchData();
        }
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        this.setState({ isFetching: true });
        this.props.generalAction(
            API_GET_REQUESTS,
            { contract_id: this.props.id, page },
            LIST_ACTIVE_REQUESTS.SUCCESS,
            LIST_ACTIVE_REQUESTS.FAILURE,
            () => {
                this.setState({ isFetching: false });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    renderItem = ({ item }, goTo) => {
        return (
            <RequestsCard item={"received"} goTo={goTo} showSeperator={false} />
        );
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <SearchBox />
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.activeRequests}
                    renderItem={item =>
                        this.renderItem(item, data =>
                            push("contractorDetail", { showBtn: true })
                        )
                    }
                />

<Supporticon 
                 clickBtn={() =>push("Support")}/> 
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, activeRequests }) => ({
    user: user.data,
    activeRequests: activeRequests.data
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    FindHealthContractors
);

const styles = StyleSheet.create({
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: colors.bgLightGrey
    },
    headerTitle: {
        color: colors.BlackColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.HeaderColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    }
});
