import React, { Component } from "react";
import { connect } from "react-redux";
import { compose } from "redux";
import { WithFetching, WithNetInfoListener } from "../../HOC";
import {
    View,
    Text,
    ImageBackground,
    TouchableOpacity,
    Image
} from "react-native";
import {
    TextFieldBorder,
    AppButton,
    FormHandler,
    Input,
    NetInfoModal
} from "../../components";
import { pop, push, popToTop } from "../../services/NavigationService";
import { Images, icons, colors } from "../../assets";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import { API_FORGOT_PASS } from "../../services/WebService";
import { generalAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import Utils from "../../Utils";
import styles from "./styles";

class ForgotPassword extends Component {
    state = {
        email: ""
    };

    onSubmit = () => {
        const formResponse = this.formHandler.onSubmitForm();
        formResponse &&
            Object.keys(formResponse).length &&
            this.requestForgotPass(formResponse);
    };

    requestForgotPass = formResponse => {
        this.props.cbShowLoader(true);
        let payload = new FormData();
        payload.append("email", formResponse.email);
        this.props.generalAction(
            API_FORGOT_PASS,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.onForgotPassSuccess,
            this.onForgotPassFailure
        );
    };

    onForgotPassSuccess = (response) => {

        this.props.cbShowLoader(false);

        Utils.showMessage(
            "Success",
            "Please check your email, follow the link and change your password",
            "success"
        );
        pop();
    };

    onForgotPassFailure = err => {
        Utils.showError(err);
        this.props.cbShowLoader(false);
    };

    render() {
        const { isNetworkConnected } = this.props.networkInfo;
        return (
            <ImageBackground
                source={Images.forgetPassBg}
                style={styles.bgImage}
            >
                <View style={styles.divForUpperSpace} />
                <View style={{ flexDirection: "row", alignSelf: "flex-start" }}>
                    <Text style={[styles.heading, styles.boldHeading]}>
                        Forgot
                    </Text>
                    <Text style={styles.heading}> Password</Text>
                </View>
                <View style={styles.divForMidSpace} />
                <View elevation={15} style={styles.inputWrapper}>
                    <FormHandler ref={ref => (this.formHandler = ref)}>
                        <Input
                            placeholder="Email"
                            error="Email is required"
                            type={INPUT_TYPES.EMAIL}
                            identifier="email"
                            blurOnSubmit={false}
                            value={""}
                            textFieldStyle={[styles.emailAddressTextField]}
                            rightTextFieldImage={icons.email}
                        />
                    </FormHandler>
                    <View style={styles.divForButtonSpace} />
                    <AppButton
                        buttonTitle="Submit"
                        style={{
                            backgroundColor: colors.ActiveTabTitle,
                            width: "100%"
                        }}
                        btnColor={colors.cardColor}
                        onPress={() => {
                            this.onSubmit();
                        }}
                    />
                </View>
                <View style={styles.divForAnotherSpace} />
                <View style={styles.divForBottomSpace} />
                <NetInfoModal isNetworkConnected={isNetworkConnected} />
            </ImageBackground>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ networkInfo }) => ({ networkInfo });
const ForgotComposeFunc = compose(
    connect(
        mapStateToProps,
        actions
    )(WithFetching(WithNetInfoListener(ForgotPassword)))
);

export default ForgotComposeFunc;

ForgotComposeFunc.navigationOptions = props => {
    return {
        headerStyle: styles.header,
        headerTitleStyle: styles.headerTitle,
        headerLeft: (
            <TouchableOpacity onPress={() => pop()}>
                <Image
                    style={{ margin: 10 }}
                    resizeMode="contain"
                    source={Images.backArrow}
                />
            </TouchableOpacity>
        ),
        headerRight: null
    };
};
