import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";

export default StyleSheet.create({
    headerTitle: {
        color: colors.HeaderTitleColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    bgImage: {
        width: "100%",
        height: "100%",
        justifyContent: "center",
        alignItems: "center",
        flexDirection: "column",
        flex: 1
    },
    inputWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        paddingBottom: Metrics.xDoubleBaseMargin,
        height: "auto",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        padding: 20
    },
    heading: {
        ...UIFont.font(fonts.regular, fontSize.huge, colors.WhiteColor),
        lineHeight: 39,
        letterSpacing: 0,
        alignSelf: "flex-start"
    },
    boldHeading: {
        ...UIFont.font(fonts.semiBold, fontSize.huge, colors.WhiteColor),
        marginLeft: 25
    },
    divForUpperSpace: {
        flex: 0.5
    },
    divForMidSpace: {
        flex: 0.2
    },
    divForButtonSpace: {
        margin: Metrics.baseMargin
    },
    bottomText: {
        color: colors.LoginBottomText,
        fontSize: 16
    },
    registerText: {
        color: colors.BlackColor
    },
    divForAnotherSpace: {
        flex: 1.5
    },
    divForBottomSpace: {
        flex: 1.5
    },
    emailAddressTextField: {
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
        borderColor: Colors.textfieldBorder,
        borderBottomWidth: 1
    },
    backArrow: {
        flex: 0.45,
        justifyContent: "center",
        marginLeft: 10,
        alignSelf: "flex-start"
    }
});
