import React, { Component } from "react";
import {
    View,
    Image,
    StyleSheet,
    TextInput,
    TouchableOpacity
} from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, RequestsCard, SearchBox, Supporticon } from "../../components";
import {
    API_GET_CONTRACTORS,
    API_FACILITY_INVITATION
} from "../../services/WebService";
import { colors, icons } from "../../assets";
import { pop, push, popToTop } from "../../services/NavigationService";
import { generalAction, notificationBar } from "../../actions/GeneralActions";
import {
    CONTRACTORS,
    SHOW_BAR,
    HIDE_BAR,
    DUMP
} from "../../actions/ActionTypes";
import Utils from "../../Utils";

class InviteContractors extends Component {

    static navigationOptions = ({ navigation }) => {
        return {
            title:
                navigation.state.routeName === "inviteContractors"
                    ? "Invite Staff"
                    : "Find Staff",
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={icons.ic_arrow_backward_black}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };
    
        state = {
            isFetching: false
        };
   

    componentDidMount() {

       // this.props.cbShowLoader(true);

       this.fetchData();

    }

    componentDidUpdate(prevProps, prevState) {
        if (this.props.id !== prevProps.id) {
            this.fetchData();
        }
    }

    fetchData = (isConcat: boolean = false, page: Number = 1, obj = {}) => {
        let searchObj =
            this.props.route.params == undefined
                ? {}
                : { contract_id: this.props.route.params.id };

        this.props.generalAction(
            API_GET_CONTRACTORS,
            { ...obj, ...searchObj },
            CONTRACTORS.SUCCESS,
            CONTRACTORS.FAILURE,
            success => {
                //this.setState({ isFetching: false });
            },
            () => {
                //this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    goTo = data => {

        const { navigation } = this.props;
        if (navigation.state.routeName === "inviteContractors") {
            let payload = new FormData();
            payload.append("user_id", data.id);
            payload.append("contract_id", navigation.getParam("id"));
            payload.append("invitation_status", "pending");
            payload.append("invitation_type", "sent");

            this.props.generalAction(
                API_FACILITY_INVITATION,
                payload,
                DUMP.SUCCESS,
                DUMP.FAILURE,
                (response) => {

                    this.invitationSent(data);
                },
                (response) => {

                    Utils.showError(response);
                }
            );


        } else if (navigation.state.routeName === "findHealthContractors") {
            push("contractorDetail", { data, showFooter: true });
        }
    };

    invitationSent({ image_url, full_name }) {

        let obj = {
            image_url,
            full_name,
            message: "Your request has been sent"
        };
        this.props.notificationBar(SHOW_BAR, obj);
        setTimeout(() => {
            this.props.notificationBar(HIDE_BAR);
        }, 3000);
    }

    renderItem = ({ item, index }) => {
        return (
            <RequestsCard
                request={"received"}
                item={item}
                goTo={data => this.goTo(data)}
                showSeperator={true}
            />
        );
    };

    applyFilters = () => {
        push("filters", { cbOnApplyFilters: this.cbOnApplyFilters });
    };

    cbOnApplyFilters = obj => {
        this.fetchData(false, 1, obj);
    };

    onChangeText = keyword => {
        this.fetchData(false, 1, { keyword });
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <SearchBox
                    value={this.state.val}
                    onChangeText={this.onChangeText}
                    onPress={this.applyFilters}
                />
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.contractors}
                    renderItem={item => this.renderItem(item)}
                />

                <Supporticon
                    clickBtn={() => push("Support")} />
            </View>
        );
    }
}

const actions = { generalAction, notificationBar };
const mapStateToProps = ({ contractors }) => ({
    contractors: contractors.data
});

export default connect(mapStateToProps, actions)(InviteContractors);


const styles = StyleSheet.create({
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: colors.bgLightGrey
    },
    searchInput: {
        flexDirection: "row",
        width: "90%",
        borderRadius: 5,
        backgroundColor: "yellow",
        textAlign: "center"
    },
    headerTitle: {
        color: colors.BlackColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.HeaderColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    }
});
