import React, { PureComponent } from "react";
import { GooglePlacesAutocomplete } from "react-native-google-places-autocomplete"; // use version 1.3.0 of this library
import { View, Text, Image } from "react-native";
import PropTypes from "prop-types";
import { ButtonView } from "../../../components";
import { Images, Metrics, Colors, AppStyles } from "../../../services";
import { API_KEY_GOOGLE } from "../../../constants";
import Utils from "../../../Utils";

export default class GooglePlacesAutoComplete extends PureComponent {
    static propTypes = {
        address: PropTypes.string,
      //  cbOnLocationPicked: PropTypes.func,
    };

    constructor(props) {
        super(props);
        // this.onItemSelected = this.onItemSelected.bind(this);

        this.changeData = this.changeData.bind(this);

         this.state = {
           Usrname: '',
         };
     }
    componentDidMount() {
        this.props.address &&
            this.props.address.length &&
            this.setAddress(this.props.address);
    }

    renderRow(row) {
        return (
            <View style={styles.containerListItem}>
                <Image source={Images.icLocation} style={styles.icLocation} />
                <Text style={styles.txtPlaces} numberOfLines={1}>
                    {row.description}
                </Text>
            </View>
        );
    }

    setAddress = address => {
        this.googlePlacesAutocomplete.setAddressText(address);
    };

    onClear = () => {
        this.googlePlacesAutocomplete.setAddressText("");
    };

    renderRightButton = () => {
        return Utils.isPlatformAndroid() ? (
            <ButtonView onPress={this.onClear} style={styles.containerClear}>
                <Image
                    source={Images.searchCloseCircle}
                    style={styles.icClear}
                />
            </ButtonView>
        ) : null;
    };

    changeData(data){

        const specialChars = /[`!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?~]/;
        var val_address;
        // this.setState({Usrname: data})
        // this.props.referenceCallback(data);

        const address_val = data.formatted_address;

        const split_string = address_val.split(",");

        if(specialChars.test(split_string[0]))
        {

            val_address = split_string.slice(1).toString();


        } else {


            val_address = data.formatted_address;
            
        }


    
        data &&
        data.geometry &&
        data.geometry.location &&
        data.geometry.location.lat &&
        this.props.cbOnLocationPicked &&
        this.props.cbOnLocationPicked({
            ...data.geometry.location,
            address: val_address
        });
      }
    onItemSelected = (data, details = null) => {

       this.changeData(details);

        // details &&
        //     details.geometry &&
        //     details.geometry.location &&
        //     details.geometry.location.lat &&
        //     this.props.cbOnLocationPicked &&
        //     this.props.cbOnLocationPicked({
        //         ...details.geometry.location,
        //         address: details.formatted_address
        //     });

            
    };

    render() {
        return (
            <GooglePlacesAutocomplete
                ref={ref => (this.googlePlacesAutocomplete = ref)}
                placeholder="Search"
                debounce={200}
                minLength={2}
                autoFocus={true}
                listViewDisplayed="auto"
                fetchDetails
                keyboardShouldPersistTaps="always"
                renderRow={this.renderRow}
                getDefaultValue={() => ""}
                keepResultsAfterBlur={true}
                onPress={this.onItemSelected}
                query={{
                    key: API_KEY_GOOGLE,
                    language: "en"
                }}
                styles={styles.placesInput}
                nearbyPlacesAPI="GooglePlacesSearch"
                GoogleReverseGeocodingQuery={{}}
                GooglePlacesSearchQuery={{}}
                GooglePlacesDetailsQuery={{
                    fields: "formatted_address,geometry",
                }}
                filterReverseGeocodingByTypes={[
                    "locality",
                    "sublocality",
                    "postal_code",
                    "country",
                    "administrative_area_level_1",
                    "administrative_area_level_2",
                    "administrative_area_level_3"
                ]}
                renderRightButton={this.renderRightButton}
                enablePoweredByContainer={false}
            />
        );
    }
}

const styles = {
    placesInput: {
        textInputContainer: {
            width: "100%"
        },
        description: {
            fontWeight: "bold"
        },
        row: {
            backgroundColor: Colors.background.secondary,
            paddingRight: Metrics.baseMargin
        },
        container: { flex: 0, position: "absolute", width: "100%", zIndex: 1 }
    },
    containerClear: {
        ...AppStyles.centerAligned,
        paddingHorizontal: Metrics.smallMargin
    },
    icClear: {
        width: Metrics.ratio(30),
        height: Metrics.ratio(30)
    },
    icLocation: {
        paddingTop: Metrics.ratio(18),
        width: Metrics.ratio(15),
        height: Metrics.ratio(15),
        resizeMode: "contain"
    },
    containerListItem: {
        flexDirection: "row",
        height: Metrics.ratio(30),
        justifyContent: "center",
        backgroundColor: Colors.background.secondary
    },
    txtPlaces: {
        ...AppStyles.robotoRe(),
        marginRight: Metrics.smallMargin,
        marginLeft: Metrics.smallMargin,
        backgroundColor: Colors.background.secondary
    }
};
