import React, { Component } from "react";
import { View, StyleSheet } from "react-native";
import PropTypes from "prop-types";
import _ from "lodash";
import GooglePlacesAutocomplete from "./GooglePlacesAutoComplete";
import Utils from "../../Utils";
import { pop } from "../../services/NavigationService";
import { Metrics, AppStyles } from "../../services";
import { API_KEY_GOOGLE } from "../../constants";

class LocationPicker extends Component {
    static propTypes = {
        location: PropTypes.object,
       // cbOnLocationPicked: PropTypes.func,
        isKeyboardVisible: PropTypes.bool
    };

    constructor(props) {
        super(props);

        this.cbOnLocationPicked = this._cbOnLocationPicked.bind(this);

        this.callbackFromB = this.callbackFromB.bind(this);
        this.state = {
            Usrname: '',
            };
    }

    callbackFromB = data => {

        this.setState({ Usrname: data});

        
      }
    renderPlacesInput() {
        return (
            <GooglePlacesAutocomplete
            ref={ref => (this.child = ref)}      //<--- By using ref you can call child class method
        //  referenceCallback = {this.callbackFromB.bind(this)}
                cbOnLocationPicked={this._cbOnLocationPicked.bind(this)}
               // cbOnLocationPicked={this._cbOnLocationPicked}
            />
        );
    }
 
    _cbOnLocationPicked (objLocation){
      //  cbOnLocationPicked = objLocation => {

        const { params } = this.props.route;


        if (params.cbOnLocationPicked) params.cbOnLocationPicked(objLocation);
        pop();
    };

    popToPreviousScreen = () => {
        const { cbOnLocationPicked } = this.props.route.params;
        cbOnLocationPicked && cbOnLocationPicked({ ...this.state });
        pop();
    };

    getAddress = () => {
        fetch(
            `https://maps.googleapis.com/maps/api/geocode/json?latlng=${this.state.latitude},${this.state.longitude}&key=${API_KEY_GOOGLE}`,
            {
                method: "get",
                dataType: "json",
                headers: {
                    Accept: "application/json",
                    "Content-Type": "application/json"
                }
            }
        )
            .then(response => response.json())
            .then(({ results }) => {
                if (results.length) {
                    for (i = 0; i < results.length; i++) {
                        if (results[i].formatted_address) {
                            this.state.address = results[i].formatted_address;
                            this.popToPreviousScreen();
                            break;
                        }
                    }
                } else {
                    Utils.showMessage(
                        "Failed to fetch address",
                        "Press done button again"
                    );
                }
            })
            .catch(err =>
                Utils.showMessage(
                    "Failed to fetch address",
                    "Press done button again"
                )
            );
    };

    mapRef = ref => (this.map = ref);
    render() {
        return <View style={styles.container}>{this.renderPlacesInput()}</View>;
    }
}

export default LocationPicker;

const styles = {
    container: { flex: 1 },
    map: {
        width: Metrics.screenWidth,
        height: Metrics.screenHeight,
        ...StyleSheet.absoluteFillObject
    },
    containerAppButton: {
        flexDirection: "row",
        padding: Metrics.baseMargin,
        backgroundColor: "transparent",
        position: "absolute",
        bottom: 0
    },
    containerPointer: {
        width: Metrics.screenWidth,
        height: Metrics.screenHeight,
        position: "absolute",
        ...AppStyles.centerAligned
    },
    icPointer: {
        width: Metrics.ratio(35),
        height: Metrics.ratio(35),
        resizeMode: "contain",
        marginBottom: Metrics.ratio(50)
    }
};
