import React, { Component } from "react";
import { connect } from "react-redux";
import { WithFetching, WithNetInfoListener } from "../../HOC";
import {
    View,
    Text,
    ImageBackground,
    TouchableOpacity,
    Platform
} from "react-native";
import { NetInfoModal, AppButton, FormHandler, Input, Supporticon,TextLabel} from "../../components";
import { pop, push, popToTop } from "../../services/NavigationService";
import { Images, icons, UIFont, colors } from "../../assets";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import {
    API_LOGIN, BASE_URL,
    API_CATEGORIES_LIST,
    CHECK_SOCIAL_LOGIN,
    API_SIGN_UP_FACILITY,
    API_SIGN_UP_CONTRACTOR,
    API_INFO_CONTENT, REGISTER_CHECK,
} from "../../services/WebService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { USER, CATEGORIES, INFO_CONTENT } from "../../actions/ActionTypes";
import Notification from "../../services/Notification";
import Utils from "../../Utils";
import SocialLogin from "../SocialLogin";
import styles from "./styles";
import messaging from '@react-native-firebase/messaging';
import UserType from "../UserType";
import axios from "axios";
import {appleAuth, 
    AppleAuthCredentialState,
    AppleAuthRequestOperation,
    AppleAuthRequestScope,
    AppleButton,
} from "@invertase/react-native-apple-authentication";


class Login extends Component {
    state = {
        email: "",
        data_gmail: '',
    };

    componentDidMount() {

        this.callStaticData(
            API_CATEGORIES_LIST,
            CATEGORIES.SUCCESS,
            CATEGORIES.FAILURE
        );
        this.callStaticData(
            API_INFO_CONTENT,
            INFO_CONTENT.SUCCESS,
            INFO_CONTENT.FAILURE
        );

    }


    callStaticData(api, success, failure) {
        this.props.generalAction(
            api,
            {},
            success,
            failure,
            (response,message) => {

               Utils.setHelpLine(response.help_line)

            },
            (response) => {

            },
            true
        );
    }

    onSubmit = () => {
        const formData = this.formHandlerUser.onSubmitForm();
        formData && this.loginRequest(formData);
    };


    loginRequest = formData => {
        Notification.fcmToken(token => {
            let payload = new FormData();
            payload.append("email", formData.email);
            payload.append("password", formData.password);
            payload.append(
                "device_type",
                Utils.isPlatformAndroid() ? "android" : "ios"
            );
            payload.append("device_token", token);
console.log("payload",payload,API_LOGIN,token)
            this.props.generalAction(
                API_LOGIN,
                payload,
                USER.SUCCESS,
                USER.FAILURE,
                this.onLoginSuccess,
                this.onLoginFailure
            );

            this.props.cbShowLoader(true);
        });
    };

    socialLogin = ({ user }) => {

        Notification.fcmToken(token => {
            let payload = new FormData();
            payload.append("full_name", user.name);
            payload.append("email", user.email);
            payload.append("social_id", user.id);
            payload.append("social_type", user.social_type);
            payload.append("device_token", token);
            payload.append("device_type", Utils.getDeviceType());

            this.props.cbShowLoader(true);

            this.ApiSocialLogin(payload,user)
           
        });
    };


    ApiSocialLogin = (payload,user) =>{

        console.log("gmailLogindev",user);

        this.props.generalAction(
            CHECK_SOCIAL_LOGIN,
            payload,
            USER.SUCCESS,
            USER.FAILURE,
            data => {
                this.setState({ user: payload });

                    if (typeof data && data.length == 0) {

                    this.props.cbShowLoader(false);

                    this.setState({ data_gmail: user });

                    console.log("gmailLogindev", user.social_type);

                    push("userType", {
                        cbOnSelectUser: this.cbOnSelectUser,
                        selectUser: true
                    });

                } else {

                    this.props.cbShowLoader(false);

                    data.user_type == "Facility" ? this.onLoginSuccess(data)  :
                    this.checkstatusregister(data);

                }
            },
            this.onLoginFailure
        );
    }

    checkstatusregister = (data) => {

        let self = this;

        axios.get(BASE_URL + REGISTER_CHECK + '?user_id=' + data.id, {
            headers: {
                token: "api.Pd*!(5675"
            }
        })
            .then(function (response) {

                var step1 = response.data.data[0].step1;
                var step2 = response.data.data[0].step2;
                var step3 = response.data.data[0].step3;
                var step4 = response.data.data[0].step4;
                var user_ID = response.data.data[0].user_id;
                var documents_val = response.data.data[0].documents;

                if (step1 == "f") {

                }
                else if (step2 == "f") {

                    self.props.cbShowLoader(false);

                    push("professionalDetails",{user_ID});

                }
                else if (step3 == "f") {

                    self.props.cbShowLoader(false);

                    push("documentRegister",{ user_ID,documents_val });

                } else if (step4 == "f") {

                    self.props.cbShowLoader(false);

                    push("bankDetails",{user_ID});

                }
                else {
                    self.props.cbShowLoader(false);

                    // Set user data in Utils for social login
                    Utils.setUserLoggedIn(true);
                    Utils.setUserToken(data.token);
                    Utils.setUserType(data.user_type);
                }


            })
            .catch(function (error) {
                console.log(error);
            })


    }


    cbOnSelectUser = userType => {
        let { user, data_gmail } = this.state;

        user.append("user_type", userType);

        let api = API_SIGN_UP_FACILITY;

        this.props.cbShowLoader(false);

        userType == "Contractor" ? push("signUpContractor", { data_gmail, userType }) :

            this.props.generalAction(
                api,
                user,
                USER.SUCCESS,
                USER.FAILURE,
                this.onLoginSuccess,
                this.onLoginFailure
            );

        // this.props.cbShowLoader(true);

    };

    onLoginSuccess = user => {
        console.log('=== LOGIN: onLoginSuccess called ===');
        console.log('User data:', user);

        Utils.setUserLoggedIn(true);
        Utils.setUserToken(user.token);
        Utils.setUserType(user.user_type);

        // Navigation will automatically switch when Redux user state updates
        // No need to manually push to facilityStack/contractorStack
        // Just hide the loader after state is ready
        setTimeout(() => {
            console.log('=== LOGIN: Hiding loader ===');
            this.props.cbShowLoader(false);
        }, 300);
    };

    onLoginFailure = err => {
        this.props.cbShowLoader(false);

        var step1 = err.step1;
        var step2 = err.step2;
        var step3 = err.step3;
        var step4 = err.step4;
        var user_ID = err.user_id;
        var documents_val = err.documents;

        if (step1 == "f") {

        }
        else if (step2 == "f") {

            push("professionalDetails",{user_ID});

        }
        else if (step3 == "f") {

            push("documentRegister",{ user_ID,documents_val });

        } else if (step4 == "f") {

            push("bankDetails",{user_ID});

        }
        else {

            Utils.showError(err);

        }

    };

    CardGap = obj => <View style={obj} />;


    appleSignIn = async () => {

    
        const appleAuthRequestResponse = await appleAuth.performRequest({
            requestedOperation: appleAuth.Operation.LOGIN,
            requestedScopes: [appleAuth.Scope.EMAIL, appleAuth.Scope.FULL_NAME],
          });
        
        // appleAuth.onCredentialRevoked(async () => {
        //     console.warn('If this function executes, User Credentials have been Revoked');
        // });
        // get current authentication state for user
        // /!\ This method must be tested on a real device. On the iOS simulator it always throws an error.
        const credentialState = await appleAuth.getCredentialStateForUser(appleAuthRequestResponse.user);

        // use     credentialState response to ensure the user is authenticated
        if (credentialState === appleAuth.State.AUTHORIZED) {
            // user is authenticated

            // const params = {
            //     email: ,
            //     social_id: ,
            //     social_type: "apple",
            // };

            Notification.fcmToken(token => {
                let payload = new FormData();
                payload.append("full_name",  _.isNull(fullName) ? "" : fullName.familyName);
                payload.append("email", _.isNull(email) ? "" : email);
                payload.append("social_id", user);
                payload.append("social_type", "apple");
                payload.append("device_token", token);
                payload.append("device_type", Utils.getDeviceType());
    
                Utils.showMessage("Social ", user);
    
                this.ApiSocialLogin(payload,appleAuthRequestResponse)
               
            });

        }
        else{


        }


        try {

        } catch (error) {
          if (error.code === AppleAuthError.CANCELED) {
            // user cancelled Apple Sign-in
        
          } else {
            // other unknown error
          }
        }

    }

    loginCard = () => {
        return (
            <View elevation={15} style={styles.inputWrapper}>
                <FormHandler ref={ref => (this.formHandlerUser = ref)}>
                    <Input
                        placeholder="Email"
                        error="Email is required"
                        type={INPUT_TYPES.EMAIL}
                        identifier="email"
                        blurOnSubmit={false}
                        // value={"jacob@yopmail.com"}
                        textFieldStyle={[styles.emailAddressTextField]}
                        rightTextFieldImage={icons.email}
                    />
                    <Input
                        placeholder="Password"
                        error="Password is required"
                        type={INPUT_TYPES.PASSWORD}
                        identifier="password"
                        blurOnSubmit
                        textFieldStyle={[styles.emailAddressTextField]}
                        rightTextFieldImage={icons.key}
                    // value={"123456"}
                    />
                </FormHandler>
                <AppButton
                    buttonTitle="Log In"
                    style={{
                        backgroundColor: colors.ActiveTabTitle,
                        marginTop: 20,
                        width: "100%"
                    }}
                    btnColor={colors.cardColor}
                    onPress={() => {
                        this.onSubmit();
                    }}
                />

                <SocialLogin
                    socialLogin={this.socialLogin}
                    cbShowLoader={this.props.cbShowLoader}
                />
                
                {Utils.isPlatformAndroid() ?null:
                <AppleButton
                    buttonStyle={AppleButton.Style.WHITE}
                    buttonType={AppleButton.Type.SIGN_IN}
                    style={{
                        width: 160, // You must specify a width
                        height: 45, // You must specify a height
                    }}
                    onPress={() => this.appleSignIn()}
                /> }

            </View>
        );
    };

    heading() {
        return (
            <React.Fragment>
                <View style={{ flexDirection: "row", alignSelf: "flex-start" }}>
                    <Text style={[styles.heading, styles.boldHeading]}>
                        Login
                    </Text>
                    <Text style={styles.heading}> with your</Text>
                </View>
                <Text style={[styles.heading, { marginLeft: 25 }]}>email</Text>
            </React.Fragment>
        );
    }

    footer() {
        return (
            <React.Fragment>
                <TouchableOpacity onPress={() => push("forgotPassword")}>
                    <Text style={styles.bottomText}>Forgot your password?</Text>
                </TouchableOpacity>
                <TouchableOpacity
                    style={{ marginTop: 8 }}
                    onPress={() => push("userType")}
                >
                    <Text style={styles.bottomText}>
                        Don't have an account yet?{" "}
                        <Text style={[styles.bottomText, styles.registerText]}>
                            Register
                        </Text>
                    </Text>
                </TouchableOpacity>
            </React.Fragment>
        );
    }

    labelText = (label, topMargin = {}) => {
        return (
            <TextLabel color={"black"} style={[styles.textLabelgender, topMargin]}>
                {label}
            </TextLabel>
        );
    };
    render() {
        const { isNetworkConnected } = this.props.networkInfo;
        const { generalAction, cbShowLoader } = this.props;

        return (
            <ImageBackground source={Images.bgImage} style={styles.bgImage}>
                {this.CardGap(styles.divForUpperSpace)}
                {this.heading()}
                {this.CardGap(styles.divForMidSpace)}
                {this.loginCard()}
                {this.CardGap(styles.divForBottomSpace)}

                {this.CardGap(styles.divForAnotherSpace)}
                {this.footer()}
                {this.CardGap(styles.divForBottomSpace)}
                <NetInfoModal isNetworkConnected={isNetworkConnected} />

                <Supporticon
                    clickBtn={() => push("SupportLogin")} />
            </ImageBackground>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ networkInfo }) => ({ networkInfo });

export default connect(
    mapStateToProps,
    actions
)(WithFetching(WithNetInfoListener(Login)));


// import React, { Component } from "react";
// import { connect } from "react-redux";
// import { WithFetching, WithNetInfoListener } from "../../HOC";
// import {
//     View,
//     Text,
//     ImageBackground,
//     TouchableOpacity,
//     Platform,
// } from "react-native";
// import { NetInfoModal, AppButton, FormHandler, Input, Supporticon, TextLabel } from "../../components";
// import { pop, push, popToTop } from "../../services/NavigationService";
// import { Images, icons, UIFont, colors } from "../../assets";
// import { INPUT_TYPES } from "../../components/FormHandler/Constants";
// import {
//     API_LOGIN, BASE_URL,
//     API_CATEGORIES_LIST,
//     CHECK_SOCIAL_LOGIN,
//     API_SIGN_UP_FACILITY,
//     API_SIGN_UP_CONTRACTOR,
//     API_INFO_CONTENT, REGISTER_CHECK,
// } from "../../services/WebService";
// import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
// import { USER, CATEGORIES, INFO_CONTENT } from "../../actions/ActionTypes";
// import Notification from "../../services/Notification";
// import Utils from "../../Utils";
// import SocialLogin from "../SocialLogin";
// import styles from "./styles";
// import messaging from '@react-native-firebase/messaging';
// import UserType from "../UserType";
// import axios from "axios";
// import {
//     appleAuth,
//     AppleAuthCredentialState,
//     AppleAuthRequestOperation,
//     AppleAuthRequestScope,
//     AppleButton,
// } from "@invertase/react-native-apple-authentication";


// class Login extends Component {
//     state = {
//         email: "",
//         data_gmail: '',
//     };

//     componentDidMount() {

//         this.callStaticData(
//             API_CATEGORIES_LIST,
//             CATEGORIES.SUCCESS,
//             CATEGORIES.FAILURE
//         );
//         this.callStaticData(
//             API_INFO_CONTENT,
//             INFO_CONTENT.SUCCESS,
//             INFO_CONTENT.FAILURE
//         );

//     }


//     callStaticData(api, success, failure) {
//         this.props.generalAction(
//             api,
//             {},
//             success,
//             failure,
//             (response, message) => {

//                 Utils.setHelpLine(response.help_line)

//             },
//             (response) => {

//             },
//             true
//         );
//     }

//     onSubmit = () => {
//         // console.log(";;;;;;;;;;;;;;;;");
        
//         // console.log(API_LOGIN,"api url")
//         const formData = this.formHandlerUser.onSubmitForm();
//         formData && this.loginRequest(formData);
//     };

// loginRequest = (formData) => {
//   try {
//     console.log(API_LOGIN, "api url", formData);

//     Notification.fcmToken((token) => {
//       console.log(token, "token");

//       try {
//         let payload = new FormData();
//         payload.append("email", formData.email);
//         payload.append("password", formData.password);
//         payload.append(
//           "device_type",
//           Utils.isPlatformAndroid() ? "android" : "ios"
//         );
//         payload.append("device_token", token);

//         // Show loader before dispatching API action
//         console.log('=== LOGIN: Showing loader ===');
       

//         // Dispatch Redux action - the API call happens in Redux Saga
//         // The loader will be hidden in onLoginSuccess or onLoginFailure callbacks
//         console.log('=== LOGIN: Dispatching action ===');
//         console.log('API_LOGIN:', API_LOGIN);
//         console.log('USER.SUCCESS:', USER.SUCCESS);
//         console.log('USER.FAILURE:', USER.FAILURE);
//         console.log('onLoginSuccess:', typeof this.onLoginSuccess);
//         console.log('onLoginFailure:', typeof this.onLoginFailure);
//         console.log('generalAction type:', typeof this.props.generalAction);

//         const actionResult = this.props.generalAction(
//           API_LOGIN,
//           payload,
//         USER.SUCCESS,
//           USER.FAILURE,
//           this.onLoginSuccess,
//           this.onLoginFailure
//         );
//  this.props.cbShowLoader(true);
//         console.log('=== LOGIN: Action dispatched ===');
//         console.log('Action result:', actionResult);
//       } catch (innerError) {
//         console.error("Login inner error:", innerError);
//         this.props.cbShowLoader(false);
//       }
//     });
//   } catch (error) {
//     console.error("Login outer error:", error);
//     this.props.cbShowLoader(false);
//   }
// };

//     // loginRequest = formData => {
//     //     console.log(API_LOGIN,"api url")
//     //     Notification.fcmToken(token => {
//     //         let payload = new FormData();
//     //         payload.append("email", formData.email);
//     //         payload.append("password", formData.password);
//     //         payload.append(
//     //             "device_type",
//     //             Utils.isPlatformAndroid() ? "android" : "ios"
//     //         );
//     //         payload.append("device_token", token);

//     //         this.props.generalAction(
//     //             API_LOGIN,
//     //             payload,
//     //             USER.SUCCESS,
//     //             USER.FAILURE,
//     //             this.onLoginSuccess,
//     //             this.onLoginFailure
//     //         );

//     //         this.props.cbShowLoader(true);
//     //     });
//     // };

//     socialLogin = ({ user }) => {

//         Notification.fcmToken(token => {
//             let payload = new FormData();
//             payload.append("full_name", user.name);
//             payload.append("email", user.email);
//             payload.append("social_id", user.id);
//             payload.append("social_type", user.social_type);
//             payload.append("device_token", token);
//             payload.append("device_type", Utils.getDeviceType());

//             this.props.cbShowLoader(true);
//             this.props.generalAction(
//                 CHECK_SOCIAL_LOGIN,
//                 payload,
//                 USER.SUCCESS,
//                 USER.FAILURE,
//                 data => {
//                     this.setState({ user: payload });

//                     if (typeof data && data.length == 0) {

//                         this.setState({ data_gmail: user });

//                         this.props.cbShowLoader(false);

//                         push("userType", {
//                             cbOnSelectUser: this.cbOnSelectUser,
//                             selectUser: true
//                         });

//                     } else {

//                         this.props.cbShowLoader(false);

//                         data.user_type == "Facility" ? this.onLoginSuccess(data) :
//                             this.checkstatusregister(data);

//                     }
//                 },
//                 this.onLoginFailure
//             );
//         });
//     };

//     checkstatusregister = (data) => {

//         let self = this;

//         axios.get(BASE_URL + REGISTER_CHECK + '?user_id=' + data.id, {
//             headers: {
//                 token: "api.Pd*!(5675",
//                 api_version: '1.0',
//                 api_client: 'android'
//             }
//         })
//             .then(function (response) {

//                 var step1 = response.data.data[0].step1;
//                 var step2 = response.data.data[0].step2;
//                 var step3 = response.data.data[0].step3;
//                 var step4 = response.data.data[0].step4;
//                 var user_ID = response.data.data[0].user_id;
//                 var documents_val = response.data.data[0].documents;

//                 if (step1 == "f") {

//                 }
//                 else if (step2 == "f") {

//                     self.props.cbShowLoader(false);

//                     push("professionalDetails", { user_ID });

//                 }
//                 else if (step3 == "f") {

//                     self.props.cbShowLoader(false);

//                     push("documentRegister", { user_ID, documents_val });

//                 } else if (step4 == "f") {

//                     self.props.cbShowLoader(false);

//                     push("bankDetails", { user_ID });

//                 }
//                 else {

//                     self.props.cbShowLoader(false);
//                     self.onLoginSuccess(data);
//                 }


//             })
//             .catch(function (error) {
//                 console.log(error);
//             })


//     }


//     cbOnSelectUser = userType => {
//         let { user, data_gmail } = this.state;

//         user.append("user_type", userType);

//         let api = API_SIGN_UP_FACILITY;

//         this.props.cbShowLoader(false);

//         userType == "Contractor" ? push("signUpContractor", { data_gmail, userType }) :

//             this.props.generalAction(
//                 api,
//                 user,
//                 USER.SUCCESS,
//                 USER.FAILURE,
//                 this.onLoginSuccess,
//                 this.onLoginFailure
//             );

//         // this.props.cbShowLoader(true);


//     };

//     onLoginSuccess = user => {

//         console.log('Login onLoginSuccess called with user:', user);
//         Utils.setUserLoggedIn(true);
//         Utils.setUserToken(user.token);
//         Utils.setUserType(user.user_type);

//         // Wait for Redux state to update and navigation to trigger before hiding loader
//         // The navigation happens automatically when Redux user state is updated
//         // Give enough time for the navigation stack to switch
//         setTimeout(() => {
//             console.log('Login hiding loader after successful login');
//             this.props.cbShowLoader(false);
//         }, 500);

//     };

//     onLoginFailure = err => {
//         console.log('=== LOGIN: onLoginFailure called ===');
//         console.log('Error received:', err);

//         // ALWAYS hide loader first
//         this.props.cbShowLoader(false);

//         // Handle incomplete registration steps (specific API error structure)
//         if (err && typeof err === 'object' && (err.step1 || err.step2 || err.step3 || err.step4)) {
//             var step1 = err.step1;
//             var step2 = err.step2;
//             var step3 = err.step3;
//             var step4 = err.step4;
//             var user_ID = err.user_id;
//             var documents_val = err.documents;

//             if (step1 == "f") {
//                 // Step 1 incomplete - stay on login or show message
//                 Utils.showError("Please complete your registration");
//             }
//             else if (step2 == "f") {
//                 push("professionalDetails", { user_ID });
//             }
//             else if (step3 == "f") {
//                 push("documentRegister", { user_ID, documents_val });
//             }
//             else if (step4 == "f") {
//                 push("bankDetails", { user_ID });
//             }
//         } else {
//             // Show the error message (network errors, validation errors, etc.)
//             // Utils.showError now handles all error formats and shows Alert box
//             Utils.showError(err || "Login failed. Please try again.");
//         }

//         console.log('=== LOGIN: Error handled, loader hidden ===');
//     };

//     CardGap = obj => <View style={obj} />;


//     appleSignIn = async () => {

//         const appleAuthRequestResponse = await appleAuth.performRequest({
//             requestedOperation: appleAuth.Operation.LOGIN,
//             requestedScopes: [appleAuth.Scope.EMAIL, appleAuth.Scope.FULL_NAME],
//         });

//         // get current authentication state for user
//         // /!\ This method must be tested on a real device. On the iOS simulator it always throws an error.
//         const credentialState = await appleAuth.getCredentialStateForUser(appleAuthRequestResponse.user);

//         if (credentialState === appleAuth.State.AUTHORIZED) {
//             // user is authenticated


//         }
//         else {


//         }


//         try {


//         } catch (error) {
//             if (error.code === AppleAuthError.CANCELED) {
//                 // user cancelled Apple Sign-in

//             } else {
//                 // other unknown error
//             }
//         }

//     }

//     loginCard = () => {
//         return (
//             <View elevation={15} style={styles.inputWrapper}>
//                 <FormHandler ref={ref => (this.formHandlerUser = ref)}>
//                     <Input
//                         placeholder="Email"
//                         error="Email is required"
//                         type={INPUT_TYPES.EMAIL}
//                         identifier="email"
//                         blurOnSubmit={false}
//                         // value={"jacob@yopmail.com"}
//                         textFieldStyle={[styles.emailAddressTextField]}
//                         rightTextFieldImage={icons.email}
//                     />
//                     <Input
//                         placeholder="Password"
//                         error="Password is required"
//                         type={INPUT_TYPES.PASSWORD}
//                         identifier="password"
//                         blurOnSubmit
//                         textFieldStyle={[styles.emailAddressTextField]}
//                         rightTextFieldImage={icons.key}
//                     // value={"123456"}
//                     />
//                 </FormHandler>
//                 <AppButton
//                     buttonTitle="Log In"
//                     style={{
//                         backgroundColor: colors.ActiveTabTitle,
//                         marginTop: 20,
//                         width: "100%"
//                     }}
//                     btnColor={colors.cardColor}
//                     onPress={() => {
//                         this.onSubmit();
//                     }}
//                 />

//                 <SocialLogin
//                     socialLogin={this.socialLogin}
//                     cbShowLoader={this.props.cbShowLoader}
//                 />

//                 {Utils.isPlatformAndroid ? null :
//                     <AppleButton
//                         buttonStyle={AppleButton.Style.WHITE}
//                         buttonType={AppleButton.Type.SIGN_IN}
//                         style={{
//                             width: 160, // You must specify a width
//                             height: 45, // You must specify a height
//                         }}
//                         onPress={() => this.appleSignIn()}
//                     />}

//             </View>
//         );
//     };

//     heading() {
//         return (
//             <React.Fragment>
//                 <View style={{ flexDirection: "row", alignSelf: "flex-start" }}>
//                     <Text style={[styles.heading, styles.boldHeading]}>
//                         Login
//                     </Text>
//                     <Text style={styles.heading}> with your</Text>
//                 </View>
//                 <Text style={[styles.heading, { marginLeft: 25 }]}>email</Text>
//             </React.Fragment>
//         );
//     }

//     footer() {
//         return (
//             <React.Fragment>
//                 <TouchableOpacity onPress={() => push("forgotPassword")}>
//                     <Text style={styles.bottomText}>Forgot your password?</Text>
//                 </TouchableOpacity>
//                 <TouchableOpacity
//                     style={{ marginTop: 8 }}
//                     onPress={() => push("userType")}
//                 >
//                     <Text style={styles.bottomText}>
//                         Don't have an account yet?{" "}
//                         <Text style={[styles.bottomText, styles.registerText]}>
//                             Register
//                         </Text>
//                     </Text>
//                 </TouchableOpacity>
//             </React.Fragment>
//         );
//     }

//     labelText = (label, topMargin = {}) => {
//         return (
//             <TextLabel color={"black"} style={[styles.textLabelgender, topMargin]}>
//                 {label}
//             </TextLabel>
//         );
//     };
//     render() {
//         const { isNetworkConnected } = this.props.networkInfo;
//         const { generalAction, cbShowLoader } = this.props;

//         return (
//             <ImageBackground source={Images.bgImage} style={styles.bgImage}>
//                 {this.CardGap(styles.divForUpperSpace)}
//                 {this.heading()}
//                 {this.CardGap(styles.divForMidSpace)}
//                 {this.loginCard()}
//                 {this.CardGap(styles.divForBottomSpace)}

//                 {this.CardGap(styles.divForAnotherSpace)}
//                 {this.footer()}
//                 {this.CardGap(styles.divForBottomSpace)}
//                 <NetInfoModal isNetworkConnected={isNetworkConnected} />



//                 <Supporticon
//                     clickBtn={() => push("SupportLogin")} />
//             </ImageBackground>
//         );
//     }
// }

// const actions = { generalAction, generalSaveAction };
// const mapStateToProps = ({ networkInfo }) => ({ networkInfo });

// export default connect(
//     mapStateToProps,
//     actions
// )(WithFetching(WithNetInfoListener(Login)));
