import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";

export default StyleSheet.create({
    bgImage: {
        width: "100%",
        height: "100%",
        justifyContent: "center",
        alignItems: "center",
        flexDirection: "column",
        flex: 1
    },
    inputWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        paddingBottom: Metrics.xDoubleBaseMargin,
        height: "auto",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        padding: 20
    },
    heading: {
        ...UIFont.font(fonts.regular, fontSize.huge, colors.WhiteColor),
        lineHeight: 39,
        letterSpacing: 0,
        alignSelf: "flex-start"
    },
    boldHeading: {
        ...UIFont.font(fonts.semiBold, fontSize.huge, colors.WhiteColor),
        marginLeft: 25
    },
    divForUpperSpace: {
        flex: 2
    },
    divForMidSpace: {
        flex: 0.7
    },
    bottomText: {
        ...UIFont.font(fonts.regular, fontSize.xSmall, colors.LoginBottomText),
        lineHeight: 16,
        letterSpacing: 0
    },
    registerText: {
        ...UIFont.font(fonts.semiBold, fontSize.xSmall, colors.BlackColor)
    },
    divForAnotherSpace: {
        flex: 2.5
    },
    divForBottomSpace: {
        flex: 0.5
    },
    emailAddressTextField: {
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
        borderColor: Colors.textfieldBorder,
        borderBottomWidth: 1
    }


    
});
