import React, { Component } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    StyleSheet,
    TouchableWithoutFeedback
} from "react-native";
import {
    TextLabel,
    FooterDetail,
    MileagePaidBidRate,
    AppButton
} from "../../components";
import Utils from "../../Utils";
import { pop, push, popToTop } from "../../services/NavigationService";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";

class MileagePaid extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={icons.ic_arrow_backward_black}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };
    state = {
        address: "",
        totalMileage: 0,
        latitude: 0,
        longitude: 0
    };

    cbOnApplyFilters = obj => {
        this.popToPreviousScreen(obj);
    };

    popToPreviousScreen = (obj = {}) => {

        const { cbOnApplyFilters } = this.props.route.params;
        cbOnApplyFilters && cbOnApplyFilters({ ...this.state, ...obj });
    };

    onLocation = () => {
        push("locationPicker", { cbOnLocationPicked: this.cbOnLocationPicked });
    };

    cbOnLocationPicked = objLoc => {
        const {
            cost_per_mile,
            latitude,
            longitude,
            maximum_radius
        } = this.props.route.params;

        if (objLoc.address.length) {
            let dist = Utils.distance(
                objLoc.lat,
                objLoc.lng,
                latitude,
                longitude
            );
            let totalDistance = dist > maximum_radius ? maximum_radius : dist;

            this.setState({
                totalMileage: cost_per_mile ? totalDistance * cost_per_mile : 0,
                address: objLoc.address,
                latitude: objLoc.lat,
                longitude: objLoc.lng
            });

        }
    };

    heading(label, labelStyle) {
        return <TextLabel style={labelStyle}>{label}</TextLabel>;
    }

    footer(style, text, bgColor, textColor, callBack) {
        return (
            <FooterDetail
                style={style}
                text={text}
                backgroundColor={bgColor}
                textColor={{ color: textColor }}
                clickBtn={callBack}
            />
        );
    }

    renderError(radius) {
        return (
            <Text style={styles.error}>
                `Maximum Mileage will be paid for {radius} miles`
            </Text>
        );
    }

    render() {
        const {
                is_mileage_paid,
                location_address,
                shift_end_time,
                shift_start_time,
                contract_type,
                maximum_radius,
                total_hours,
                btn,
                data
            } = this.props.route.params,
            { totalMileage } = this.state;
        return (
            <View style={styles.container}>
                {this.heading("Mileage Paid", [
                    styles.categoryLabel,
                    { marginBottom: -5 }
                ])}
                <MileagePaidBidRate
                    onPress={this.onLocation}
                    val1={location_address}
                    val2={this.state.address}
                />
                <View style={{ flex: 1, backgroundColor: colors.HeaderColor }}>
                    {this.renderError(maximum_radius)}
                </View>
                {this.footer(
                    [styles.footerStyle, { bottom: 55 }],
                    `Mileage Total: $${totalMileage.toFixed(2)}`,
                    {
                        backgroundColor: "#959dad"
                    },
                    colors.BlackColor,
                    () => null
                )}
                {this.footer(
                    [styles.footerStyle, { bottom: 0 }],
                    "NEXT",
                    {
                        backgroundColor: "#08548c"
                    },
                    "#ffffff",
                    this.state.address
                        ? !is_mileage_paid || btn == "Request"
                            ? () => {
                                  this.popToPreviousScreen();
                                  pop();
                              }
                            : () =>
                                  push("bidRate", {
                                      cbOnApplyFilters: this.cbOnApplyFilters,
                                      screen: "mileagePaid",
                                      shift_end_time,
                                      shift_start_time,
                                      contract_type,
                                      total_hours,
                                      data
                                  })
                        : () =>
                              Utils.showAlert(
                                  "Location Required",
                                  `location is required`,
                                  () => {}
                              )
                )}
            </View>
        );
    }
}

export default MileagePaid;

const styles = StyleSheet.create({
    headerTitle: {
        color: colors.BlackColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.cardColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    container: {
        flex: 1,
        backgroundColor: colors.cardColor
    },
    categoryLabel: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor),
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    footerStyle: {
        position: "absolute",
        justifyContent: "flex-end",
        alignItems: "center",
        paddingHorizontal: 10
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start",
        paddingHorizontal: 20,
        paddingTop: 10
    }
});
