import React, { Component } from "react";
import {
    View,
    StyleSheet,
    TouchableOpacity,
    Image,
    ImageBackground,
    Text
} from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, MainCard ,Supporticon} from "../../components";
import { API_CONTRACTOR_CONTRACTS ,BASE_URL, TOTAL_API,} from "../../services/WebService";
import { push, pop } from "../../services/NavigationService";
import { Images, UIFont, fonts, fontSize, colors } from "../../assets";
import Metrics from "../../services/Metrics";
import Utils from "../../Utils";
import moment from "moment";
import axios from "axios";
import { generalAction } from "../../actions/GeneralActions";
import { LIST_CLOSE_CONTRACTS } from "../../actions/ActionTypes";

class MyEarnings extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            title: "My Earnings",
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={Images.backArrow}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };

    state = {
        isFetching: false,
        totalProjects: 0,
        totalPayment: 0
    };

    componentDidMount() {
        this.fetchData();
        this.fetchShift()
    }


    fetchShift = () => {

         const { user } = this.props;

         let self = this;

        axios.get(BASE_URL + TOTAL_API + "?user_id=" + user.id, {
            headers: {
                token: "api.Pd*!(5675",
                api_version:'1.0',
                api_client:'android'
            }
        })
            .then(function (response) {

                const codeval = response.data.success;
                const val = response.data.message;
                // {
                //     "success": "200",
                //     "total_amount": "6841.42",
                //     "total_complete_contracts": 152
                // }                
                if (codeval == 200) {

                    self.setState({  totalProjects: response.data.total_complete_contracts,
                        totalPayment:response.data.total_amount })

                } else {



                }

            })
            .catch(function (error) {
                console.log(error);
                
            })


    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { user } = this.props;
        this.setState({ isFetching: true });
        this.props.generalAction(
            API_CONTRACTOR_CONTRACTS,
            {
                user_id: user.id,
                contract_status: "close",
                is_contract_complete: "complete",
                invitation_status: "accepted",
                is_onboarded: 1,
                page
            },
            LIST_CLOSE_CONTRACTS.SUCCESS,
            LIST_CLOSE_CONTRACTS.FAILURE,
            this.retrivedList,
            () => this.setState({ isFetching: false }),
            true,
            isConcat
        );
    };

    retrivedList = data => {
        let totalPayment = 0;

        data.length > 0 &&
            data.map(elem => {
                totalPayment += +elem.my_earrings.contractor_amount;
            });
        this.setState({
            isFetching: false,
           
        });
    };

    renderItem = ({ item, index }, goTo) => {

        return <MainCard item={item} isClosedItem goTo={goTo} />;
    };

    eachCard = (style, text1, text2) => {
        return (
            <View style={styles.headerBox}>
                <Text style={style}>{text1}</Text>
                <View style={styles.cardStyle}>
                    <Text style={styles.cardTextStyle}>{text2}</Text>
                </View>
            </View>
        );
    };

    renderHeader = () => {
        const { totalPayment, totalProjects } = this.state;
        return (
            <View style={{ marginTop: 20 }}>
                {this.eachCard(
                    styles.headerBoxStyle,
                    totalProjects,
                    "TOTAL SHIFTS"
                )}
                {this.eachCard(
                    styles.headerBoxStyle2,
                    `$${totalPayment}`,
                    "TOTAL PAYMENT"
                )}
            </View>
        );
    };

    render() {
        return (
            <ImageBackground source={Images.bgImage} style={styles.bgImage}>
                <FlatListHandler
                    ListHeaderComponent={this.renderHeader}
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.closeContracts}
                    renderItem={item => this.renderItem(item, () => push())}
                />

                <Supporticon
                    clickBtn={() => push("Support")} />
            </ImageBackground>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, closeContracts }) => ({
    user: user.data,
    closeContracts: closeContracts.data
});

export default connect(mapStateToProps, actions)(MyEarnings);

const styles = StyleSheet.create({
    bgImage: {
        width: "100%",
        height: "100%",
        justifyContent: "center",
        alignItems: "center",
        flexDirection: "column",
        flex: 1
    },
    headerTitle: {
        color: colors.cardColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.ActiveTabTitle,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    headerBox: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        backgroundColor: "#26699A",
        borderRadius: 8,
        paddingHorizontal: 20,
        paddingVertical: 25,
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        marginBottom: 10
    },
    headerBoxStyle: {
        ...UIFont.font(fonts.regular, 50, "#fefeff"),
        lineHeight: 60,
        letterSpacing: 0,
        textAlign: "center"
    },
    headerBoxStyle2: {
        ...UIFont.font(fonts.regular, 30, "#0aff00"),
        lineHeight: 60,
        letterSpacing: 0,
        textAlign: "center"
    },
    cardStyle: {
        height: 40,
        paddingHorizontal: 40,
        justifyContent: "center",
        backgroundColor: colors.cardColor,
        borderRadius: 25
    },
    cardTextStyle: {
        ...UIFont.font(fonts.semiBold, 12, colors.ActiveTabTitle),
        lineHeight: 15,
        letterSpacing: 0.02,
        textAlign: "center"
    }
});
