import React, { Component } from "react";
import { View, Text } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, MainCard } from "../../components";
import { API_CONTRACTOR_CONTRACTS, GET_ADDRESS, BASE_URL } from "../../services/WebService";
import { push } from "../../services/NavigationService";
import styles from "./styles";
import Geolocation from '@react-native-community/geolocation';
import { generalAction } from "../../actions/GeneralActions";
import { LIST_ACTIVE_CONTRACTS } from "../../actions/ActionTypes";
import axios from "axios";

class Active extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isFetching: false,
            address_loc: ''
        };
    }

    componentDidMount() {

        this.fetchData();

        this.getOneTimeLocation();

    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { user } = this.props;
        this.setState({ isFetching: true });
        this.props.generalAction(
            API_CONTRACTOR_CONTRACTS,
            {
                user_id: user.id,
                contract_status: "active",
                is_contract_complete: "incomplete",
                invitation_status: "accepted",
                is_onboarded: 1,
                page
            },
            LIST_ACTIVE_CONTRACTS.SUCCESS,
            LIST_ACTIVE_CONTRACTS.FAILURE,
            () => {


                this.setState({ isFetching: false });
            },
            () => {


                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );

    };

    getOneTimeLocation = () => {
        Geolocation.getCurrentPosition(
            (position) => {

                const currentLongitude =
                    JSON.stringify(position.coords.longitude);

                const currentLatitude =
                    JSON.stringify(position.coords.latitude);

                this.getAddress(currentLatitude, currentLongitude);
            },
            (error) => {
                // setLocationStatus(error.message);

                console.log(error.message)

            },
            {
                enableHighAccuracy: false,
                timeout: 30000,
                maximumAge: 1000
            },
        );
    };

    getAddress = (lat, lng) => {

        let self = this;

        let params = {
            latitude: lat,
            longitude: lng
        }

        axios.get(BASE_URL + GET_ADDRESS + "?latitude=" + lat + "&longitude=" + lng, {
            headers: {
                token: "api.Pd*!(5675",
                api_version: '1.0',
                api_client: 'android'
            }
        })
            .then(function (response) {

                const checkval = response.data.failure;
                const val = response.data.data;

                if (checkval != 200) {


                    self.setState({ address_loc: val })


                } else {


                    self.setState({ address_loc: "" })


                }


            })
            .catch(function (error) {
                console.log(error);
            })
    }

    renderItem = ({ item, index }, goTo) => {

        return <MainCard item={item} goTo={goTo} />;
    };

    render() {

        const address_val = this.state.address_loc;

        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.activeContracts}
                    renderItem={item =>
                        this.renderItem(item, (data, isClosedItem) =>
                            push("myScheduleDetail", { data, isClosedItem, address_val })
                        )

                    }
                />
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, activeContracts }) => ({
    user: user.data,
    activeContracts: activeContracts.data
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    Active
);
