import React, { Component } from "react";
import { View, Text } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, MainCard } from "../../components";
import { API_CONTRACTOR_CONTRACTS } from "../../services/WebService";
import { push } from "../../services/NavigationService";
import styles from "./styles";

import { generalAction } from "../../actions/GeneralActions";
import { LIST_CLOSE_CONTRACTS } from "../../actions/ActionTypes";

class Active extends Component {
    state = {
        isFetching: false
    };

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { user } = this.props;
        this.setState({ isFetching: true });
        this.props.generalAction(
            API_CONTRACTOR_CONTRACTS,
            {
                user_id: user.id,
                contract_status: "close",
                is_contract_complete: "complete",
                invitation_status: "accepted",
                is_onboarded: 1,
                page
            },
            LIST_CLOSE_CONTRACTS.SUCCESS,
            LIST_CLOSE_CONTRACTS.FAILURE,
            () => this.setState({ isFetching: false }),
            () => this.setState({ isFetching: false }),
            true,
            isConcat
        );
    };

    renderItem = ({ item, index }, goTo) => {

        return <MainCard item={item} isClosedItem goTo={goTo} />;
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.closeContracts}
                    renderItem={item =>
                        this.renderItem(item, (data, isClosedItem) =>
                            push("myScheduleDetail", { data, isClosedItem })
                        )
                    }
                />
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, closeContracts }) => ({
    user: user.data,
    closeContracts: closeContracts.data
});

export default connect(mapStateToProps, actions)(Active);
