// import React, { Component } from "react";
// import {
//     View,
//     TouchableOpacity,
//     Image,
//     Text, Button,
//     Modal, TextInput
// } from "react-native";
// import { Icon } from "react-native-elements";
// import { connect } from "react-redux";
// import ScrollableTabView from "react-native-scrollable-tab-view";
// import { HeaderTabs, Supporticon, TextLabel } from "../../components";
// import { Images, icons, colors } from "../../assets";
// import styles from "./styles";
// import { push, getCurrentRouteName } from "../../services/NavigationService";
// import PostTypeSelection from "../ShiftHome/postTypeSelection";
// import { API_DELETE_CONTRACT } from "../../services/WebService";
// import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
// import { DUMP } from "../../actions/ActionTypes";
// import { WithFetching } from "../../HOC";
// import Utils from "../../Utils";
// import Active from "./Active";
// import Closed from "./Closed";

// class MySchedule extends Component {
//     constructor(props) {
//         super(props);

//         this.state = {
//             ismodal: false,
//             Modal: true,
//         }

//     }

//     static navigationOptions = ({ navigation }) => {
//         return {
//             headerRight: (
//                 <TouchableOpacity>
//                     <Image
//                         style={{ margin: 10 }}
//                         resizeMode="contain"
//                         source={icons.search_icon_black}
//                     />
//                 </TouchableOpacity>
//             )
//         };
//     };

//     labelText = (label, topMargin = {}) => {
//         return (
//             <TextLabel color={"black"} style={[styles.textLabelgender, topMargin]}>
//                 {label}
//             </TextLabel>
//         );
//     };

//     renderError(err, obj = { marginTop: 4 }) {
//         //  if (this.state.isError) {
//         return <TextLabel style={[styles.error, obj]}>{err}</TextLabel>;
//         // }
//     }

//     labelLocationText = (label, topMargin = {}) => {
//         return (

//             <View>
//                 {/* <Icon
//                     style={styles.iconstyle}
//                    // reverse
//                     name='fontawesome-ok-circle'
//                    // type='feather'
//                    type='Font Awesome'

//                     color='rgb(8, 84, 140)'
//                 /> */}
//                 <TextLabel style={[styles.textLocation, topMargin]}>
//                     {label}
//                 </TextLabel>
//             </View>

//         );
//     };

//     render() {
//         getCurrentRouteName();
//         let { tab } = this.props.navigation.state.params,
//             initialPage = tab ? 1 : 0;

//         return (
//             <View style={styles.container}>
//                 <HeaderTabs initialPage={initialPage}>
//                     <Active tabLabel="ONBOARD" />
//                     <Closed tabLabel="CLOSED" />
//                 </HeaderTabs>

//                 <Supporticon
//                     clickBtn={() => push("Support")} />


//             </View>


//         );
//     }
// }

// const actions = { generalAction, generalSaveAction };

// export default connect(null, actions)(WithFetching(MySchedule));


import React, { Component } from "react";
import {
  View,
  TouchableOpacity,
  Image,
  Text
} from "react-native";
import { Icon } from "react-native-elements";
import { connect } from "react-redux";
import { TabView, TabBar, SceneMap } from "react-native-tab-view";
import { Dimensions } from "react-native";
import { Supporticon, TextLabel } from "../../components";
import { Images, icons, colors } from "../../assets";
import styles from "./styles";
import { push, getCurrentRouteName } from "../../services/NavigationService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { WithFetching } from "../../HOC";
import Active from "./Active";
import Closed from "./Closed";

const initialLayout = { width: Dimensions.get("window").width };

class MySchedule extends Component {
  constructor(props) {
    super(props);
    const tab = props?.route?.params?.tab; // for React Navigation v6
    const initialIndex = tab ? 1 : 0;

    this.state = {
      index: initialIndex,
      routes: [
        { key: "active", title: "ONBOARD" },
        { key: "closed", title: "CLOSED" },
      ],
    };
  }

  renderScene = SceneMap({
    active: () => <Active />,
    closed: () => <Closed />,
  });

  renderTabBar = props => (
    <TabBar
      {...props}
      indicatorStyle={{ backgroundColor: colors.ActiveTabTitle }}
      style={{ backgroundColor: colors.TabBackgroundColor }}
      labelStyle={{
        color: colors.ActiveTabTitle,
        fontWeight: "600",
        fontSize: 13,
      }}
      inactiveColor={colors.InActiveTabTitle}
      activeColor={colors.ActiveTabTitle}
    />
  );

  render() {
    getCurrentRouteName();

    return (
      <View style={styles.container}>
        <TabView
          navigationState={this.state}
          renderScene={this.renderScene}
          renderTabBar={this.renderTabBar}
          onIndexChange={index => this.setState({ index })}
          initialLayout={initialLayout}
        />

        <Supporticon clickBtn={() => push("Support")} />
      </View>
    );
  }
}

const actions = { generalAction, generalSaveAction };

export default connect(null, actions)(WithFetching(MySchedule));
