import React, { Component } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    ScrollView, Button,
    TextInput,
    TouchableWithoutFeedback
} from "react-native";
import { connect } from "react-redux";
import {
    InfoModal,
    InfoMileage,
    AllInfo
} from "../../appComponents/ModalComponents";
import PostTypeSelection from "../ShiftHome/postTypeSelection";
import { compose } from "redux";
import { pop, push, popToTop } from "../../services/NavigationService";
import { Images, icons, colors, UIFont, fonts, fontSize } from "../../assets";
import StarRating from "react-native-star-rating";
import moment from "moment";
import {
    DetailCard,
    Separator,
    TextLabel,
    FooterDetail,
    ReusableModal, Supporticon, AppButton
} from "../../components";
import {
    API_DELETE_CONTRACT,
    API_USER_RATING_CHECK,
    API_CONTRACT_DETAIL, POST_LATLNG_API, POST_VERIFY_API, BASE_URL
} from "../../services/WebService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import { WithFetching } from "../../HOC";
import Utils from "../../Utils";
import styles from "./styles";
import { API_KEY_GOOGLE } from "../../constants";
import { selectPostDetails } from "../../reduxSelectors";
import { Overlay } from 'react-native-elements';
import Geolocation from '@react-native-community/geolocation';
import axios from "axios";

class MyScheduleDetail extends Component {
    constructor(props) {
        super(props);

        const val = this.props.route.params.address_val == undefined ? "" :
            this.props.route.params.address_val == "" ? "" :
                this.props.route.params.address_val;

        this.state = {
            maxRadius: props.route.params.data.maximum_radius,
            ratingUser: 0,
            contractDetail: [],
            Modal: false,
            shift_name: '',
            shift_time: '',
            current_loc: val,
            show_location: val,
            to_loc: '',
            sign_name: '',
            sign_title: '',
            location_status: '',
            isError: false,
            isbutton: false,
            iseditable: true,
            mileage_val: props.route.params.data.mileage_amount,
            location_fetch: '',

        };
    }

    componentDidMount() {
        this.fetchRating();
        const {
            contract_type,
            cost_per_mile
        } = this.props.route.params.data;
        this.props.navigation.setParams({
            showInfo: () => this.showModal("allInfo"),
            boo:
                contract_type == "Shift" && cost_per_mile == null
                    ? null
                    : cost_per_mile
        });

        this.getContractDetail();

        this.getOneTimeLocation();



    }

    getOneTimeLocation = () => {
        Geolocation.getCurrentPosition(
            (position) => {

                this.setState({ location_fetch: "" })

                const currentLongitude =
                    JSON.stringify(position.coords.longitude);

                const currentLatitude =
                    JSON.stringify(position.coords.latitude);

                this.props.cbShowLoader(true);

                this.props.route.params.address_val == undefined ?
                    this.getAddress(currentLatitude, currentLongitude) :

                    this.props.route.params.address_val == "" ?
                        this.getAddress(currentLatitude, currentLongitude) :
                        this.checkLocation(currentLatitude, currentLongitude);

            },
            (error) => {

                this.setState({ location_fetch: error.message })

            },
            {
                enableHighAccuracy: false,
                timeout: 30000,
                maximumAge: 1000
            },
        );
    };

    checkLocation = (lat, lng) => {

        let self = this;

        const c_id = this.props.route.params.data.contract_id;
        let params = {
            contract_id: c_id,
            latitude: lat,
            longitude: lng
        }


        axios.post(BASE_URL + POST_LATLNG_API, params, {
            headers: {
                token: "api.Pd*!(5675",
                api_version: '1.0',
                api_client: 'android'
            }
        })
            .then(function (response) {

                const checkval = response.data.message;

                self.props.cbShowLoader(false);

                if (checkval != 'failure') {

                    self.setState({ location_status: true })

                    self.setState({ show_location: self.state.to_loc })


                } else {

                    self.setState({ location_status: false })


                }


            })
            .catch(function (error) {
                console.log(error);
            })
    }
    getContractDetail = () => {
        this.props.cbShowLoader(true);

        const { contract_id } = this.props.route.params.data;
        const { isClosedItem } = this.props.route.params;

        const { id } = this.props.user
        let params = {
            contract_id,
            user_id: id,
            is_contract_complete: isClosedItem ? 'complete' : 'incomplete',
            contract_status: isClosedItem ? 'close' : 'active',
        }

        this.props.generalAction(
            API_CONTRACT_DETAIL,
            params,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbOnSuccess,
            this.cbFailure,
            true
        );

    }
    cbOnSuccess = (response) => {
        this.setState({
            contractDetail: response
        });

        const location_verified = response[0].contract_location_verified;

        const to_location = response[0].location_address;
        const category_name = response[0].category_name;

        const start_t = response[0].shift_start_time;
        const end_t = response[0].shift_end_time;

        const signname = response[0].name;
        const signtitle = response[0].title;

        const time = start_t + " to " + end_t;

        if (signname == '' && signtitle == '') { //complete by clnicicans

            this.setState({ isbutton: false, iseditable: true })

        } else {

            this.setState({ isbutton: true, iseditable: false })

        }

        this.setState({ sign_name: signname, sign_title: signtitle })

        this.setState({ to_loc: to_location, shift_name: category_name, shift_time: time })

        this.state.location_status == true ? this.setState({ show_location: to_location }) : null
        const ismarked = response[0].is_marked;

        if (location_verified == 0) { //complete by clnicicans

            this.setState({ Modal: true })

        } else if (location_verified == 1) {  // verify location

            this.setState({ Modal: true, })

        } else if (location_verified == 2) {  // reject shift

            this.setState({ Modal: false, })
        }
        else {

            this.setState({ Modal: false })

        }

        this.props.cbShowLoader(false);
    }
    cbFailure = (error) => {
        this.props.cbShowLoader(false);
        Utils.showError(error);
    }

    labelText = (label, topMargin = {}) => {
        return (
            <TextLabel color={"black"} style={[styles.textLabelgender, topMargin]}>
                {label}
            </TextLabel>
        );
    };

    renderError(err, obj = { marginTop: 4 }) {
        if (this.state.isError) {
            return <TextLabel style={[styles.error, obj]}>{err}</TextLabel>;
        }
    }

    labelLocationText = (label, topMargin = {}) => {
        return (

            <View>
                <TextLabel style={[styles.textLocation, topMargin]}>
                    {label}
                </TextLabel>
            </View>

        );
    };

    labelLocationerror = (label, topMargin = {}) => {
        return (

            <View>
                <TextLabel style={[styles.error, topMargin]}>
                    {label}
                </TextLabel>
            </View>

        );
    };


    fetchRating = (isConcat: boolean = false, page: Number = 1) => {
        const { contract_id } = this.props.route.params.data,
            { user } = this.props;
        this.props.generalAction(
            API_USER_RATING_CHECK,
            {
                user_id: user.id,
                contract_id: contract_id,
                user_role: "clinician"
            },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            data => {
                this.setState({
                    ratingUser: +data[0].rating
                });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    getAddress(latitude, longitude) {

        fetch(
            `https://maps.googleapis.com/maps/api/geocode/json?address=${latitude},${longitude}&key=${API_KEY_GOOGLE}`).
            then((response) => response.json())
            .then((responseJson) => {
                const results = JSON.stringify(responseJson);

                const address_current = responseJson.results[0].formatted_address;

                this.setState({ show_location: address_current })

                this.checkLocation(latitude, longitude);
            }
            );
    }

    showModal = modal => {
        this.setState({ modal });
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.setState({ boo: false });
        this.Modal.setModalVisible(false);
    };

    renderModal = () => {
        const { modal, boo, rejectReason, maxRadius, contractDetail } = this.state;

        let data = contractDetail.length === 0
            ? this.props.route.params.data
            : contractDetail[0];

        const {
            bid_amount,
            contract_type,
            cost_per_mile,
            contract_invitations,
            latitude,
            longitude,
            shift_end_time,
            shift_start_time,
            total_hours
        } = data;

        let totalRadius = maxRadius;
        if (Array.isArray(contract_invitations)) {
            let dist = Utils.distance(
                contract_invitations[0].latitude,
                contract_invitations[0].longitude,
                contract_invitations[0].invitation_latitude,
                contract_invitations[0].invitation_longitude
            );
            totalRadius = dist > maxRadius ? maxRadius : dist;
        } else {
            let dist =
                contract_invitations.invitation_latitude == null
                    ? maxRadius
                    : Utils.distance(
                        contract_invitations.invitation_latitude,
                        contract_invitations.invitation_longitude,
                        contract_invitations.latitude,
                        contract_invitations.longitude
                    );
            totalRadius = dist > maxRadius ? maxRadius : dist;
        }
        let diffTime = this.calculateDiffTime(shift_end_time, shift_start_time);
        let { rate } = this.totalBidNMileage();
        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={styles.modalContainer}>
                        <View style={styles.modalInner}>
                            {modal == "info" && (
                                <InfoModal
                                    costMile={cost_per_mile}
                                    maxRadius={totalRadius}
                                />
                            )}
                            {modal == "allInfo" && (
                                <AllInfo note={this.props.note} />
                            )}
                            {modal == "mileage" && (
                                <InfoMileage
                                    rate={rate}
                                    contract_type={contract_type}
                                    diffTime={total_hours}
                                />
                            )}
                        </View>
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };

    heading(label) {
        return (
            <TextLabel
                type="medium"
                size="medium"
                color={"black"}
                style={styles.boldText}
            >
                {label}
            </TextLabel>
        );
    }

    footer(label, bgColor, textColor, obj) {
        return (
            <FooterDetail
                style={obj}
                text={label}
                backgroundColor={{ backgroundColor: bgColor }}
                textColor={{ color: textColor }}
                clickBtn={() => push()}
            />
        );
    }

    marksAsCompleteBtn() {
        // const { data, isClosedItem } = this.props.route.params;
        // const { contract_type } = data;
        // let route = contract_type === 'Contract' ? 'AddContractTiming' : 'AddShiftTiming';

        const { contractDetail } = this.state;

        let data = contractDetail.length === 0
            ? this.props.route.params.data
            : contractDetail[0];

        const { contract_type } = data;
        let route = contract_type === 'Contract' ? 'AddContractTiming' : 'AddShiftTiming';

        const { contract_history_data } = data;
        const { contract_history_rejected_count, contract_history_pending_count } = contract_history_data;

        return (
            <View>
                {contract_history_pending_count === 0 &&
                    <FooterDetail
                        text={contract_history_rejected_count === 0 ? "MARK AS COMPLETE" : 'SEND REQUEST AGAIN'}
                        backgroundColor={{ backgroundColor: "#08548c" }}
                        textColor={{ color: "#ffffff" }}
                        // img={icons.ic_completed}
                        clickBtn={() => push(route, {
                            data: contractDetail[0], location: this.state.show_location
                        })}
                    />
                }
            </View>
        );
    }

    paragraph(para, style, numberOfLines) {
        return (
            <Text style={style} numberOfLines={numberOfLines}>
                {para}
            </Text>
        );
    }

    renderMap = (latitude, longitude) => {
        const baseUrl = "https://maps.googleapis.com/maps/api/staticmap";
        const markerCenter = `center=${latitude},${longitude}`;
        const API_KEY = `key=${API_KEY_GOOGLE}`;
        const zoomLevel = "zoom=16";
        const imageSize = `size=400x400`;
        const customMarkerIcon = `markers=icon:https://assets.mapquestapi.com/icon/v2/circle.png%7Clabel:C%7C${latitude},${longitude}`;
        const mapImageUrl = `${baseUrl}?${markerCenter}&${zoomLevel}&${imageSize}&${API_KEY}&${customMarkerIcon}`;
        return (
            <View style={styles.mapStyle}>
                <Image
                    source={{ uri: mapImageUrl }}
                    style={{ width: "100%", height: "100%", borderRadius: 6 }}
                />
            </View>
        );
    };

    rateCard = () => {

        const { ratingUser, contractDetail } = this.state;

        let data = contractDetail.length === 0
            ? this.props.route.params.data
            : contractDetail[0];

        const { contract_id, user_id } = data;
        const { user } = this.props;
        return (
            <View
                style={{
                    height: 60,
                    width: "100%",
                    flexDirection: "row",
                    paddingHorizontal: 20,
                    paddingTop: 25,
                    justifyContent: "space-between"
                }}
            >
                <TouchableOpacity
                    onPress={() =>
                        ratingUser > 0
                            ? null
                            : push("rating", {
                                userType: "contractor",
                                contract_id,
                                contractor_id: user.id,
                                facility_id: user_id
                            })
                    }
                >
                    <Text style={styles.rateText}>
                        {ratingUser > 0 ? "Average Rating" : "Rate Facility"}
                    </Text>
                </TouchableOpacity>


                {ratingUser > 0 ? (
                    <View style={{ flex: 0.3 }}>
                        {
                            <StarRating
                                disabled={true}
                                maxStars={5}
                                rating={ratingUser}
                                starSize={14}
                                fullStarColor={"rgb(255,186,73)"}
                            />
                        }
                    </View>
                ) : null}
            </View>
        );
    };

    calculateDiffTime = (b, a) => {
        let dif = moment(b, "HH:mm:a").diff(moment(a, "HH:mm:a"));
        let diffTime = moment.duration(dif).hours();
        return +diffTime == 0 ? 1 : diffTime;
    };

    totalBidNMileage() {
        const { maxRadius, contractDetail } = this.state;
        // let data = contractDetail[0];
        let data = contractDetail.length === 0
            ? this.props.route.params.data
            : contractDetail[0];

        let rate =
            data.hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0, data.contract_rate.indexOf("."))
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0,
                    data.hourly_pay_rate.indexOf(".")
                );

        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * data.total_hours; //i will change hour here with on shift

        let totalRadius = maxRadius;
        if (Array.isArray(data.contract_invitations)) {
            let dist = Utils.distance(
                data.contract_invitations[0].latitude,
                data.contract_invitations[0].longitude,
                data.contract_invitations[0].invitation_latitude,
                data.contract_invitations[0].invitation_longitude
            );
            totalRadius = dist > maxRadius ? maxRadius : dist;
            if (
                data.contract_invitations[0].bid_amount !== null &&
                data.contract_invitations[0].bid_amount !== "0.00"
            ) {
                rate =
                    data.contract_type === "Contract"
                        ? data.contract_invitations[0].bid_amount
                        : data.contract_invitations[0].bid_amount /
                        data.total_hours; //change hour here
                bidAmount = data.contract_invitations[0].bid_amount;
            }
        } else {
            let dist =
                data.contract_invitations.invitation_latitude == null
                    ? maxRadius
                    : Utils.distance(
                        data.contract_invitations.invitation_latitude,
                        data.contract_invitations.invitation_longitude,
                        data.contract_invitations.latitude,
                        data.contract_invitations.longitude
                    );
            totalRadius = dist > maxRadius ? maxRadius : dist;
            if (
                data.contract_invitations.bid_amount !== null &&
                data.contract_invitations.bid_amount !== "0.00"
            ) {
                rate =
                    data.contract_type === "Contract"
                        ? data.contract_invitations.bid_amount
                        : data.contract_invitations.bid_amount /
                        data.total_hours; //change hour here
                bidAmount = data.contract_invitations.bid_amount;
            }
        }
        let totalAmount = data.cost_per_mile
            ? +bidAmount + +data.cost_per_mile * totalRadius
            : +bidAmount;
        return { totalAmount, rate };
    }

    verifyShiftClose = () => {

        let self = this;

        const c_id = this.props.route.params.data.contract_id;

        const {
            sign_name,
            sign_title,

        } = this.state;

        if (sign_name && sign_title) {

            let params = {
                contract_id: c_id,
                name: this.state.sign_name,
                title: this.state.sign_title
            }
            this.props.cbShowLoader(true);

            axios.post(BASE_URL + POST_VERIFY_API, params, {
                headers: {
                    token: "api.Pd*!(5675",
                    api_version: '1.0',
                    api_client: 'android'
                }
            })
                .then(function (response) {

                    const checkval = response.data.message;

                    if (checkval != 'failure') {


                        self.props.cbShowLoader(false);

                        pop();

                    } else {




                    }


                })
                .catch(function (error) {
                    console.log(error);
                    //alert(error);
                })

        } else {


            this.setState({ isError: true });

        }
    }

    render() {
        let isClosedItem = this.props.route.params.isClosedItem;
        const { contractDetail } = this.state;
        if (contractDetail.length === 0) {
            isClosedItem = true
        }

        let data = contractDetail.length === 0
            ? this.props.route.params.data
            : contractDetail[0];
        const { contract_status } = data;

        let rejected_history_data = [];
        if (contractDetail.length !== 0) {
            rejected_history_data = contractDetail[0].rejected_history_data;
        }


        return (
            <React.Fragment>
                <ScrollView>
                    <DetailCard
                        data={data}
                        cbMileage={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("info")
                        }
                        cbTotal={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("mileage")
                        }
                        style={{ backgroundColor: colors.cardColor }}
                    />
                    <Separator style={styles.separatorStyle} />
                    {this.heading("Description")}
                    {this.paragraph(data.description, styles.descriptionStyle, 2)}

                    {
                        !isClosedItem && (rejected_history_data.length !== 0 &&
                            <View>
                                <Separator style={styles.separatorStyle} />
                                {this.heading("Reason")}
                                {this.paragraph(rejected_history_data[0].rejected_reason, styles.descriptionStyle, 15)}
                            </View>
                        )
                    }


                    {isClosedItem ? this.rateCard() : null}
                    <Separator style={styles.separatorStyle} />
                    {this.paragraph(data.locationText, styles.locationStyle, 1)}
                    {this.renderMap(data.latitude, data.longitude)}
                </ScrollView>


                {contractDetail.length !== 0 && contract_status === 'active' && this.marksAsCompleteBtn()}
                {this.renderModal()}


                <View style={styles.centeredView}>
                    <Overlay

                        animationType="slide"
                        transparent={true}
                        isVisible={this.state.Modal}
                        onRequestClose={() => {

                            this.setState({ Modal: false })

                            //  pop();
                        }} >

                        <ScrollView
                            showsHorizontalScrollIndicator={false}
                            keyboardShouldPersistTaps="always"
                            style={{

                                // flexDirection: 'row',
                                flexGrow: 0,
                                //width: '100%',
                            }}>

                            <View >

                                <TouchableOpacity
                                    activeOpacity={1}
                                // onPressOut={() => this.setState({ Modal: false })}
                                >

                                    <View style={styles.modalView}>

                                        {this.labelText("Title/certification")}
                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.shift_name}
                                            editable={false}
                                            selectTextOnFocus={false}

                                            style={styles.inputhiddenStyle} />

                                        {this.labelText("Timing")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.shift_time}
                                            editable={false}
                                            selectTextOnFocus={false}
                                            style={styles.inputhiddenStyle}
                                        />

                                        {this.labelText("Current Location")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.show_location}
                                            editable={false}
                                            textAlign={'left'}
                                            autoFocus={true}
                                            selection={{ start: 0, end: 0 }}
                                            style={styles.inputhiddenStyle} />

                                        {this.state.location_fetch == "" ? null
                                            : this.labelLocationerror(this.state.location_fetch)}

                                        {this.labelText("To Location")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.to_loc}
                                            editable={false}
                                            textAlign={'left'}
                                            autoFocus={true}
                                            selection={{ start: 0, end: 0 }}
                                            style={styles.inputhiddenStyle} />

                                        {this.state.location_status ? this.labelLocationText("Location is  Matched")
                                            : this.labelLocationerror("Location is not Matched")}


                                        {this.labelText("Signature")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            editable={this.state.iseditable}
                                            placeholder="Enter name"
                                            onChangeText={(entry) => {
                                                this.setState({
                                                    sign_name: entry
                                                })
                                            }}
                                            value={this.state.sign_name}
                                            style={styles.inputStyle} />

                                        {!this.state.sign_name &&
                                            this.renderError(`Name is required`)}
                                        <TextInput
                                            mode='outlined'
                                            editable={this.state.iseditable}
                                            textAlignVertical="top"
                                            placeholder="Enter Title"
                                            onChangeText={(entry) => {
                                                this.setState({
                                                    sign_title: entry
                                                })
                                            }}
                                            value={this.state.sign_title}
                                            style={styles.inputStylelast} />

                                        {!this.state.sign_title &&
                                            this.renderError(`Title is required`)}

                                        <View style={{
                                            flexDirection: "row", alignItems: 'center', alignSelf: 'center',
                                            alignContent: 'center'
                                        }}>
                                            <View style={styles.buttonStyleback}>
                                                <AppButton
                                                    buttonTitle="CANCEL"
                                                    style={{
                                                        backgroundColor: "#d45404", height: 50,
                                                        height: 50,
                                                        width: "100%", alignItems: 'center'
                                                    }}
                                                    btnColor="#d45404"
                                                    onPress={() => {
                                                        this.setState({ Modal: false })
                                                    }}
                                                />
                                            </View>
                                            <View style={styles.buttonStyle}>
                                                <AppButton
                                                    buttonTitle="VERIFY"
                                                    enable={this.state.isbutton}
                                                    style={{
                                                        backgroundColor: !this.state.isbutton ?
                                                            colors.ActiveTabTitle : colors.LightGreyColor,
                                                        height: 50,
                                                        width: "100%", alignItems: 'center'
                                                    }}
                                                    btnColor={colors.cardColor}
                                                    onPress={() => {
                                                        this.verifyShiftClose();
                                                    }}

                                                />

                                            </View>
                                        </View>


                                    </View>


                                </TouchableOpacity>



                            </View>
                        </ScrollView>

                    </Overlay>

                </View>

                <Supporticon
                    clickBtn={() => push("Support")} />
            </React.Fragment>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ infoContent, user }, ownProps) => {
    return {
        data: selectPostDetails(ownProps),
        note: infoContent.data.content,
        user: user.data
    };
};

const DetailComponentCompose = compose(
    connect(mapStateToProps, actions)(WithFetching(MyScheduleDetail))
);

export default DetailComponentCompose;

DetailComponentCompose.navigationOptions = ({ navigation }) => {
    const { state } = navigation;
    const params = state.params || {};
    return {
        headerStyle: styles.header,
        headerRight: (
            <View style={{ flexDirection: "row" }}>
                {params.boo && (
                    <TouchableOpacity onPress={params.showInfo}>
                        <Image
                            style={{ margin: 10 }}
                            resizeMode="contain"
                            source={icons.ic_info}
                        />
                    </TouchableOpacity>
                )}
            </View>
        )
    };
};
