import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import { Metrics } from "../../services";

export default StyleSheet.create({
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.cardColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    separatorStyle: {
        backgroundColor: "#dde3f6",
        marginHorizontal: 20,
        marginVertical: 10
    },
    descriptionStyle: {
        ...UIFont.font(fonts.regular, fontSize.xSmall, colors.BlackColor),
        marginBottom: 10,
        marginHorizontal: 20,
        lineHeight: 22,
        letterSpacing: 0
    },
    boldText: {
        ...UIFont.font(fonts.regular, 18, colors.BlackColor),
        marginTop: 10,
        marginBottom: 10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 22,
        letterSpacing: 0
    },
    locationStyle: {
        ...UIFont.font(fonts.regular, 12, "#525252"),
        marginBottom: 10,
        marginHorizontal: 20,
        lineHeight: 14,
        letterSpacing: 0
    },
    mapStyle: {
        backgroundColor: "white",
        marginTop: 15,
        marginBottom: 80,
        height: 200,
        paddingHorizontal: 20,
        justifyContent: "center",
        alignItems: "center",
        borderRadius: 6
    },
    modalContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
    inputWrapper: {
        flexDirection: "column",
        width: Metrics.screenWidth - Metrics.xDoubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        height: "auto",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        }
    },
    modalFooter: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        borderTopWidth: 1,
        borderColor: "#DDDDDD"
    },
    textColor: {
        ...UIFont.font(fonts.regular, fontSize.medium, "#343434")
    },
    textColor2: {
        ...UIFont.font(fonts.regular, fontSize.medium, colors.CardDate)
    },
    modalInner: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "rgba(0,0,0,0.5)"
    },
    modalFirstColumn: {
        flex: 2,
        flexDirection: "column",
        justifyContent: "center",
        alignItems: "center",
        paddingVertical: 25
    },
    tabTextStyle: {
        paddingTop: Metrics.ratio(12),
        fontFamily: "Gibson",
        fontSize: 13,
        fontWeight: "600",
        fontStyle: "normal",
        lineHeight: 15,
        letterSpacing: 0
    },
    tabUnderline: {
        backgroundColor: colors.ActiveTabTitle
    },
    cardWrapper: {
        backgroundColor: colors.TabsWrapper
    },
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: colors.bgLightGrey
    },
    rateText: {
        flex: 1,
        ...UIFont.font(fonts.regular, fontSize.small, "#08548c")
    },


    centeredView: {
        alignSelf:'center',
        marginTop: 10,
    },
    textLabelgender: {
        ...UIFont.font(fonts.semiBold, fontSize.small, colors.BlackColor),
        alignSelf: "flex-start",
        lineHeight: 21,
        marginTop: 10,
        letterSpacing: 0
    },
    textLocation: {
        ...UIFont.font(fonts.regular, fontSize.small, "green"),
        alignSelf: "flex-start",
        lineHeight: 21,
        marginTop: 10,
        letterSpacing: 0
    },
    error: {
        ...UIFont.font(fonts.regular, fontSize.small, "red"),
        alignSelf: "flex-start",
        lineHeight: 21,
        marginTop: 10,
        letterSpacing: 0
    },
    inputhiddenStyle: {
        fontSize: 16,
        padding: 10,
        marginTop: 5,
        height:40,
      //  borderTopColor: "rgb(8, 84, 140)",
        borderTopWidth: 2,
        borderLeftWidth: 2,
        borderRightWidth: 2,
        borderBottomWidth: 2,
        borderColor:  colors.LightGreyColor,
        color: colors.DarkGreyColor,
        borderRadius: 5,
        marginBottom: 5,
        width: 250,
        flexDirection : 'row',
        alignSelf: "flex-start",
    },
    inputStyle: {
        fontSize: 16,
        padding: 10,
        marginTop: 5,
        height:40,
        borderTopWidth: 2,
        borderLeftWidth: 2,
        borderRightWidth: 2,
        borderBottomWidth: 2,
        borderColor: "rgb(8, 84, 140)",
        borderRadius: 5,
        marginBottom: 5,
        width: 250,
        alignSelf: "flex-start",
    },
    inputStylelast: {
        fontSize: 16,
        padding: 10,
        marginTop: 5,
        height:40,
        borderTopWidth: 2,
        borderLeftWidth: 2,
        borderRightWidth: 2,
        borderBottomWidth: 2,
        borderColor: "rgb(8, 84, 140)",
        borderRadius: 5,
        marginBottom: 30,
        width: 250,
        alignSelf: "flex-start",
    },
    modalView: {
        backgroundColor: "white",
        borderRadius: 5,
        padding: 30,
        alignContent:'center',
        alignSelf: "center",
        alignItems: 'center',
        justifyContent: "center",
        shadowColor: "#000",
        shadowOffset: {
            width: 0,
            height: 2
        },
        shadowOpacity: 0.25,
        shadowRadius: 4,
    //    elevation: 5
    },
    scrollstyle: {
        alignSelf:'center',
        borderRadius: 5,
        padding: 30,
        shadowColor: "#000",
        shadowOpacity: 0.25,
        shadowRadius: 4,
    //    elevation: 5
    },
    iconstyle:{
        resizeMode: 'contain',
        width: 50,
        height: 50,
    },
    modalFooter: {
        width:"100%",
        borderRadius:50,
        
    },

    buttonStyle: {
        width: "40%",
        alignItems: 'center',
        marginLeft: 10,
        marginBottom: 30
    },

    buttonStyleback: {
        width: "40%",
        alignItems: 'center',
        marginRight: 10,
        marginBottom: 30
    },
});
