import React, { Component } from "react";
import { View, Text } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, MainCard } from "../../components";
import { API_GET_CONTRACTS } from "../../services/WebService";
import { push } from "../../services/NavigationService";
import styles from "./styles";

import { generalAction } from "../../actions/GeneralActions";
import { LIST_ACTIVE_CONTRACTS } from "../../actions/ActionTypes";

class Active extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isFetching: false
        };
    }

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        this.setState({ isFetching: true });

        this.props.generalAction(
            API_GET_CONTRACTS,
            {
                user_id: this.props.user.id,
                contract_status: "active",
                is_contract_complete: "incomplete",
                is_onboarded: 0,
                page
            },
            LIST_ACTIVE_CONTRACTS.SUCCESS,
            LIST_ACTIVE_CONTRACTS.FAILURE,
            () => {
                this.setState({ isFetching: false });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );


    };

    renderItem = ({ item, index }, onDelete, goTo) => {

        return <MainCard item={item} onDelete={onDelete} goTo={goTo} />;
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    // isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.activeContracts}
                    renderItem={item =>
                        
                        this.renderItem(
                            item,
                            () => this.props.onDelete(item),
                            (data, isClosedItem) =>
                                push("detailScreen", { data, isClosedItem })
                        )
                        
                    }
                />
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, activeContracts }) => ({
    user: user.data,
    activeContracts: activeContracts.data

    
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    Active
);
