// import React, { Component } from "react";
// import {
//     View,
//     TouchableOpacity,
//     Image,
//     Text,
//     TouchableWithoutFeedback
// } from "react-native";
// import { connect } from "react-redux";
// import ScrollableTabView from "react-native-scrollable-tab-view";
// import { HeaderTabs, ReusableModal ,Supporticon} from "../../components";
// import { Images, icons, colors } from "../../assets";
// import styles from "./styles";
// import { push } from "../../services/NavigationService";
// import PostTypeSelection from "../ShiftHome/postTypeSelection";
// import { API_DELETE_CONTRACT } from "../../services/WebService";
// import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
// import { DeleteModal } from "../../appComponents/ModalComponents";
// import { DUMP } from "../../actions/ActionTypes";
// import { WithFetching } from "../../HOC";
// import Utils from "../../Utils";
// import Active from "./Active";
// import Closed from "./Closed";
// import Rejected from "./Rejected";


// class MyShiftsContracts extends Component {
//     constructor(props) {
//         super(props);
//         this.activeTab = React.createRef();
//         this.state = {
//             obj: {}
//         };
//     }
//     static navigationOptions = ({ navigation }) => {
//         return {
//             headerRight: (
//                 <TouchableOpacity>
//                     <Image
//                         style={{ margin: 10 }}
//                         resizeMode="contain"
//                         source={icons.search_icon_black}
//                     />
//                 </TouchableOpacity>
//             )
//         };
//     };

//     deleteContractRequest = () => {
//         this.props.generalAction(
//             API_DELETE_CONTRACT,
//             { id: this.state.obj.contract_id },
//             DUMP.SUCCESS,
//             DUMP.FAILURE,
//             this.onDeleteSuccess,
//             this.onDeleteFailure,
//             true
//         );
//         this.hideModal();
//         setTimeout(() => this.props.cbShowLoader(true), 200);
//     };

//     onDeleteSuccess = user => {
//         setTimeout(() => this.props.cbShowLoader(false), 500);

//         setTimeout(() => {
//             this.activeTab.fetchData();
//             Utils.showMessage(
//                 "Success",
//                 `${this.state.obj.contract_type} deleted successfully`,
//                 "success"
//             );
//         }, 1000);
//     };

//     onDeleteFailure = err => {
//         this.props.cbShowLoader(false);
//         Utils.showError(err);
//     };

//     showModal = () => this.Modal.setModalVisible(true);

//     hideModal = () => this.Modal.setModalVisible(false);

//     onDelete = ({ item }) => {
//         this.setState({ obj: item });
//         this.showModal();
//     };

//     renderModal = () => {
//         const { obj } = this.state;
//         return (
//             <ReusableModal ref={ref => (this.Modal = ref)}>
//                 <TouchableWithoutFeedback onPress={this.hideModal}>
//                     <View blurRadius={1} style={styles.modalContainer}>
//                         <View style={styles.modalInner}>
//                             <DeleteModal
//                                 deleteContract={this.deleteContractRequest}
//                                 hideModal={this.hideModal}
//                                 text1={"Are you sure you want to delete"}
//                                 text2={`this ${obj.contract_type}?`}
//                             />
//                         </View>
//                     </View>
//                 </TouchableWithoutFeedback>
//             </ReusableModal>
//         );
//     };

//     render() {
//         let { tab } = this.props.navigation.state.params,
//             initialPage = tab ? 1 : 0;
            
//         return (
//             <View style={styles.container}>
//                 <HeaderTabs initialPage={initialPage}>
//                     <Active
//                         tabLabel="ACTIVE"
//                         onDelete={this.onDelete}
//                         ref={ref => (this.activeTab = ref)}
//                     />
//                     <Closed tabLabel="CLOSED" ref={ref => (this.activeTab = ref)} />
//                     <Rejected tabLabel="REJECTED" />
//                 </HeaderTabs>
//                 {this.renderModal()}

//                 <Supporticon
//                  clickBtn={() =>push("Support")}/>
//             </View>
//         );
//     }
// }

// const actions = { generalAction, generalSaveAction };

// export default connect(null, actions)(WithFetching(MyShiftsContracts));
import React, { Component } from "react";
import {
  View,
  TouchableOpacity,
  Image,
  TouchableWithoutFeedback,
} from "react-native";
import { connect } from "react-redux";
import { TabView, TabBar, SceneMap } from "react-native-tab-view";
import { Dimensions } from "react-native";
import { ReusableModal, Supporticon } from "../../components";
import { icons, colors } from "../../assets";
import styles from "./styles";
import { push } from "../../services/NavigationService";
import { API_DELETE_CONTRACT } from "../../services/WebService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { DeleteModal } from "../../appComponents/ModalComponents";
import { DUMP } from "../../actions/ActionTypes";
import { WithFetching } from "../../HOC";
import Utils from "../../Utils";
import Active from "./Active";
import Closed from "./Closed";
import Rejected from "./Rejected";

const initialLayout = { width: Dimensions.get("window").width };

class MyShiftsContracts extends Component {
  constructor(props) {
    super(props);
    const tab = props?.route?.params?.tab; // updated for React Navigation v6
    const initialIndex = tab ? 1 : 0;

    this.state = {
      index: initialIndex,
      routes: [
        { key: "active", title: "ACTIVE" },
        { key: "closed", title: "CLOSED" },
        { key: "rejected", title: "REJECTED" },
      ],
      obj: {},
    };

    this.activeTab = React.createRef();
  }

  // 🗑️ Delete flow
  deleteContractRequest = () => {
    this.props.generalAction(
      API_DELETE_CONTRACT,
      { id: this.state.obj.contract_id },
      DUMP.SUCCESS,
      DUMP.FAILURE,
      this.onDeleteSuccess,
      this.onDeleteFailure,
      true
    );
    this.hideModal();
    setTimeout(() => this.props.cbShowLoader(true), 200);
  };

  onDeleteSuccess = () => {
    setTimeout(() => this.props.cbShowLoader(false), 500);
    setTimeout(() => {
      this.activeTab?.current?.fetchData?.();
      Utils.showMessage(
        "Success",
        `${this.state.obj.contract_type} deleted successfully`,
        "success"
      );
    }, 1000);
  };

  onDeleteFailure = (err) => {
    this.props.cbShowLoader(false);
    Utils.showError(err);
  };

  // 🧱 Modal Controls
  showModal = () => this.Modal.setModalVisible(true);
  hideModal = () => this.Modal.setModalVisible(false);

  onDelete = ({ item }) => {
    this.setState({ obj: item });
    this.showModal();
  };

  renderModal = () => {
    const { obj } = this.state;
    return (
      <ReusableModal ref={(ref) => (this.Modal = ref)}>
        <TouchableWithoutFeedback onPress={this.hideModal}>
          <View style={styles.modalContainer}>
            <View style={styles.modalInner}>
              <DeleteModal
                deleteContract={this.deleteContractRequest}
                hideModal={this.hideModal}
                text1={"Are you sure you want to delete"}
                text2={`this ${obj.contract_type}?`}
              />
            </View>
          </View>
        </TouchableWithoutFeedback>
      </ReusableModal>
    );
  };

  // 🧭 Tabs
  renderScene = SceneMap({
    active: () => <Active onDelete={this.onDelete} ref={this.activeTab} />,
    closed: () => <Closed ref={this.activeTab} />,
    rejected: () => <Rejected />,
  });

  renderTabBar = (props) => (
    <TabBar
      {...props}
      indicatorStyle={{ backgroundColor: colors.ActiveTabTitle }}
      style={{ backgroundColor: colors.TabBackgroundColor }}
      labelStyle={{
        color: colors.ActiveTabTitle,
        fontWeight: "600",
        fontSize: 13,
      }}
      inactiveColor={colors.InActiveTabTitle}
      activeColor={colors.ActiveTabTitle}
    />
  );

  render() {
    return (
      <View style={styles.container}>
        <TabView
          navigationState={this.state}
          renderScene={this.renderScene}
          renderTabBar={this.renderTabBar}
          onIndexChange={(index) => this.setState({ index })}
          initialLayout={initialLayout}
        />

        {this.renderModal()}

        <Supporticon clickBtn={() => push("Support")} />
      </View>
    );
  }
}

const actions = { generalAction, generalSaveAction };

export default connect(null, actions)(WithFetching(MyShiftsContracts));
