import { StyleSheet } from "react-native";
import { Metrics } from "../../services";
import { colors, UIFont, fonts, fontSize } from "../../assets";

export default StyleSheet.create({
    container: {
        flex: 1
    },
    modalContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
    inputWrapper: {
        flexDirection: "column",
        width: Metrics.screenWidth - Metrics.xDoubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        height: "auto",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        }
    },
    modalFooter: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        borderTopWidth: 1,
        borderColor: "#DDDDDD"
    },
    textColor: {
        ...UIFont.font(fonts.regular, fontSize.medium, "#343434")
    },
    textColor2: {
        ...UIFont.font(fonts.regular, fontSize.medium, colors.CardDate)
    },
    modalInner: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "rgba(0,0,0,0.5)"
    },
    modalFirstColumn: {
        flex: 2,
        flexDirection: "column",
        justifyContent: "center",
        alignItems: "center",
        paddingVertical: 25
    },
    tabTextStyle: {
        paddingTop: Metrics.ratio(12),
        fontFamily: "Gibson",
        fontSize: 13,
        fontWeight: "600",
        fontStyle: "normal",
        lineHeight: 15,
        letterSpacing: 0
    },
    tabUnderline: {
        backgroundColor: colors.ActiveTabTitle
    },
    cardWrapper: {
        backgroundColor: colors.TabsWrapper
    },
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: colors.bgLightGrey
    }
});
