import React, { Component, Fragment } from "react";
import {
    View,
    StyleSheet,
    Text,
    TouchableOpacity,
    Image,
    TouchableWithoutFeedback
} from "react-native";
import { connect } from "react-redux";
import { WithFetching } from "../../HOC";
import { ReusableModal, FlatListHandler,Supporticon } from "../../components";
import {
    API_GET_NOTIFICATIONS,
    API_UPDATE_NOTIFICATIONS_STATUS,
    API_GET_EACH_CONTRACT,
    API_GET_CONTRACTOR,
    API_CLEAR_NOTIFICATIONS
} from "../../services/WebService";
import { push,pop } from "../../services/NavigationService";
import { Metrics } from "../../services";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { compose } from "redux";
import { DeleteModal } from "../../appComponents/ModalComponents";
import { generalAction } from "../../actions/GeneralActions";
import { LIST_NOTIFICATIONS, DUMP, USER } from "../../actions/ActionTypes";
import _ from "lodash";

class Notifications extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isFetching: false
        };
    }

    componentDidMount() {
        this.fetchNotifications();

      //  this.showModal();

      this.props.navigation.setParams({
        showInfo: () => this.showModal()});
    }

    fetchNotifications = (isConcat: boolean = false, page: Number = 1) => {

        this.setState({ isFetching: true });
        this.props.generalAction(
            API_GET_NOTIFICATIONS,
            { user_id: this.props.user.id },
            LIST_NOTIFICATIONS.SUCCESS,
            LIST_NOTIFICATIONS.FAILURE,

            data => {
                let unRead = data.map(elem => elem.is_read);
                this.setState({ isFetching: false });
                this.props.navigation.setParams({
                    showModal: unRead.includes(1) ? this.showModal : () => { }
                });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true
        );


    };

    showModal = () => {

        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.Modal.setModalVisible(false);
    };

    isReadOrNot = (id, is_read, identifier, data, invitation_id) => {
        if (is_read == 0) {
            this.changeStatus(id, identifier, data, invitation_id);
        } else {
            this.notificationRouting(data, identifier, invitation_id);
        }
    };

    notificationRouting = (id, identifier, invitation_id) => {
        if (
            identifier == "profile_verified" ||
            identifier == "facility_profile_verified"
        ) {
            this.updateUserAfterProfileVerification();
        } else if (identifier == "contractor_invitation_reject") {
            push("rejectedDetail", {
                contract_id: id,
                invitation_id: invitation_id
            });
        } else if (
            identifier !== "contractor_invitation_reject" &&
            identifier !== "facility_invitation_reject"
        ) {
            this.props.generalAction(
                API_GET_EACH_CONTRACT,
                {
                    id,
                    invitation_id,
                    identifier
                },
                DUMP.SUCCESS,
                DUMP.FAILURE,
                dataArr => {
                  
                    let data = dataArr[0];
                    if (identifier == "contract_accepted_contractor" || identifier == "mark_complete_as_clinician") {
                        setTimeout(
                            () => push("onboardProjectsDetail", { data }),
                            1000
                        );
                    } else if (identifier == "contract_accepted_facility" || identifier == 'update_onboarded_contract_history') {
                        push("myScheduleDetail", {
                            data,
                            isClosedItem: data.contract_status == "active" ? false : true
                        });
                    } else if (
                        identifier == "facility_invitation" && //strequest
                        !_.isUndefined(data.contract_invitations[0])
                    ) {
                        push("requestsDetail", {
                            data: data.contract_invitations[0],
                            screen: "received"
                        });
                    } else if (
                        identifier == "contractor_invitation" &&
                        !_.isUndefined(data.contract_invitations[0])
                    ) {
                        push("availableJobsDetail", {
                            data: data.contract_invitations[0],
                            screen: "received"
                        });
                    } else {
                    }
                },
                err => {
                    console.log(err);
                },
                true
            );
        }
    };

    updateUserAfterProfileVerification() {
        const { user, generalAction } = this.props;
        generalAction(
            API_GET_CONTRACTOR,
            { user_id: user.id },
            USER.SUCCESS,
            USER.FAILURE,
            dataArr => {
                push("profile");
            },
            err => {
                console.log(err);
            },
            true
        );
    }

    changeStatus(id, identifier, data, invitation_id, user_id = undefined) {
        const payload = new FormData();
        payload.append("id", id);
        this.props.cbShowLoader(true);
        this.props.generalAction(
            user_id ? API_CLEAR_NOTIFICATIONS : API_UPDATE_NOTIFICATIONS_STATUS,
            user_id ? { user_id } : payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.statusSuccess(data, identifier, invitation_id, user_id),
            this.statusFailure,
            user_id ? true : false
        );
    }

    statusSuccess = (data, identifier, invitation_id, user_id) => another => {
        setTimeout(() => {
            this.props.cbShowLoader(false);
            user_id
                ? () => { }
                : this.notificationRouting(data, identifier, invitation_id);
            this.fetchNotifications();
        }, 1000);
    };

    statusFailure = () => {
        setTimeout(() => {
            this.props.cbShowLoader(false);
        }, 1000);
    };

    clearAll = () => {
        this.hideModal();
        this.changeStatus("", "", "", "", this.props.user.id);
    };

    renderModal = () => {
        return (
            <ReusableModal ref={ref => (this.Modal = ref)}
               >
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={styles.modalContainer}>
                        <View style={styles.modalInner}>
                            <DeleteModal
                                deleteContract={this.clearAll}
                                hideModal={this.hideModal}
                                text1={"Are you sure you want to clear"}
                                text2={`read notifications?`}
                            />
                        </View>
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };

    renderItem = ({ item, index }) => {

        //remove in live
        return (
            <TouchableOpacity
                key={`${item.created_at}${item.id}`}
                onPress={() =>
                    this.isReadOrNot(
                        item.id,
                        item.is_read,
                        item.notification_identifier,
                        item.contract_id,
                        item.invitation_id
                    )
                }
                style={styles.mainColumn}
            >
                
                <View style={{ flex: 1, flexDirection: "row" }}>
                    <Text style={styles.title}>{item.user == null ?"":item.user.full_name}</Text>
                    {item.is_read === 0 && (
                        <Image
                            style={styles.icon}
                            resizeMode="contain"
                            source={icons.icNoty}
                        />
                    )}
                    <Text style={styles.since}>{item.created_at}</Text>
                </View>
                <Text style={styles.message}>{item.description}</Text>
            </TouchableOpacity>
        );
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchNotifications}
                    data={this.props.notifications}
                    renderItem={this.renderItem}
                />
                {this.renderModal()}

                <Supporticon
                    clickBtn={() => push("Support")} />
            </View>
        );
    }
}

const actions = { generalAction };

function mapStateToProps({ user, notifications }) {
    return {
        user: user.data,
        notifications: notifications.data
    };
}

const NotificationComponentCompose = compose(
    connect(mapStateToProps, actions, null, { forwardRef: true })(
        WithFetching(Notifications)
    )
);

export default NotificationComponentCompose;

NotificationComponentCompose.navigationOptions = ({ navigation }) => {
    const { state } = navigation;
    const params = state.params || {};

    return {
        headerStyle: styles.header,
        headerRight: (
            <View style={{ flexDirection: "row" }}>
                <TouchableOpacity
                   // onPress={() => params.showModal && params.showModal()}
                    onPress={params.showInfo}

                    style={{ paddingHorizontal: 10 }}>

                    <Text style={{ color: "black" }}>Clear</Text>
                </TouchableOpacity>
            </View>
        )
    };
};

const styles = StyleSheet.create({
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: "#f7f7fa"
    },
    title: {
        ...UIFont.font(fonts.semiBold, 14, colors.BlackColor),
        textAlign: "left",
        alignSelf: "center"
    },
    icon: {
        margin: 10,
        paddingLeft: 15,
        alignSelf: "center"
    },
    since: {
        ...UIFont.font(fonts.regular, 12, "#a4a4a4"),
        flex: 1,
        textAlign: "right",
        alignSelf: "center"
    },
    message: {
        ...UIFont.font(fonts.regular, 16, "#646464"),
        flex: 1
    },
    separatorStyle: {
        backgroundColor: "#f7f7fa",
        marginTop: 30
    },
    mainColumn: { paddingVertical: 10, paddingHorizontal: 20 },
    modalInner: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "rgba(0,0,0,0.5)"
    },
    modalContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.cardColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    }
});
