import React, { Component } from "react";
import { View, StyleSheet } from "react-native";
import { connect } from "react-redux";
import {
    FlatListHandler,
    MainCard,
    ImageButton,
    SearchBox, Supporticon
} from "../../components";
import { push } from "../../services/NavigationService";
import { API_GET_CONTRACTS } from "../../services/WebService";
import { colors, icons, Images } from "../../assets";

import { generalAction } from "../../actions/GeneralActions";
import { LIST_ACTIVE_CONTRACTS } from "../../actions/ActionTypes";

class OnboardProjects extends Component {
    constructor(props) {
        super(props);
        this.filterCategories = this.filterCategories.bind(this);
        this.state = {
            isFetching: false,
            showInput: false
        };
    }

    componentDidMount() {
        this.props.navigation.setParams({
            filterCategories: this.filterCategories
        });
        this.fetchData();
        
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        this.setState({ isFetching: true });

        this.props.generalAction(
            API_GET_CONTRACTS,
            {
                user_id: this.props.user.id,
                contract_status: "active",
                is_contract_complete: "incomplete",
                is_onboarded: 1,
                page
            },
            LIST_ACTIVE_CONTRACTS.SUCCESS,
            LIST_ACTIVE_CONTRACTS.FAILURE,
            () => {
                this.setState({ isFetching: false });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    filterCategories = () => {
        this.setState({ showInput: !this.state.showInput });
    };

    renderItem = ({ item, index }, goTo) => {

        return <MainCard item={item} onDelete={() => { }} goTo={goTo} />;
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
               
                <FlatListHandler
                    isFetching={this.state.isFetching}
                     refreshing={this.state.isFetching}
                     onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.activeContracts}
                    renderItem={item =>
                        this.renderItem(item, data =>
                            push("onboardProjectsDetail", { data })
                        )
                    }
                />

                <Supporticon
                    clickBtn={() => push("Support")} />
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, activeContracts }) => ({
    user: user.data,
    activeContracts: activeContracts.data
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    OnboardProjects
);

const styles = StyleSheet.create({
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: colors.bgLightGrey
    },
    searchInput: {
        flexDirection: "row",
        width: "90%",
        borderRadius: 5,
        backgroundColor: "yellow",
        textAlign: "center"
    },
    headerTitle: {
        color: colors.BlackColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.HeaderColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    }
});
