import React, { Component } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    ScrollView,
    TouchableWithoutFeedback,
    TextInput
} from "react-native";
import { connect } from "react-redux";
import PostTypeSelection from "../ShiftHome/postTypeSelection";
import { compose } from "redux";
import { reset, push, popToTop, pop } from "../../services/NavigationService";
import {
    DeleteModal,
    AllInfo,
    InfoModal,
    InfoMileage,
    Rating
} from "../../appComponents/ModalComponents";
import { IMAGE_BASE_URL, API_UPDATE_ONBOARD_CONTRACT, API_ONBOARD_PADDING_CONTRACT } from "../../services/WebService";
import { Images, icons, colors, UIFont, fonts, fontSize } from "../../assets";
import {
    DetailCard,
    Separator,
    TextLabel,
    FooterDetail,
    RequestsCard,
    ReusableModal,
    ButtonView,
    InfoRoundBox,
    InfoCard,
    AppButton, Supporticon
} from "../../components";
import {
    API_CONTRACT_COMPLETE,
    API_GET_CONTRACTOR,
    API_RATE_CONTRACTOR
} from "../../services/WebService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import { WithFetching } from "../../HOC";
import Utils from "../../Utils";
import moment from "moment";
import styles from "./styles";
import { selectPostDetails } from "../../reduxSelectors";
import { Metrics } from "../../theme";
import { Colors } from "../../services";
import { API_KEY_GOOGLE } from "../../constants";
import CardStatus from "../../components/CardStatus";

class OnboardProjectsDetail extends Component {
    constructor(props) {
        super(props);
        this.state = {
            modal: "",
            maxRadius: props.route.params.data.maximum_radius,
            rating: 0,
            contractor: {},
            reason: '',
            pendingContract: {},
            label_lunch: '',
            label_signature: '',
            label_location: '',
        };

    }

    componentDidMount() {

        this.fetchData();
        const {
            contract_type,
            cost_per_mile
        } = this.props.route.params.data;
        this.props.navigation.setParams({
            infoRDelete: this.infoRDelete,
            boo:
                contract_type == "Shift" && cost_per_mile == null
                    ? null
                    : cost_per_mile
        });

        this.getPendingContract();
    }
    getPendingContract = () => {
        this.props.cbShowLoader(true);
        const { contract_id } = this.props.route.params.data;
        let params = {
            contract_id
        }

        this.props.generalAction(
            API_ONBOARD_PADDING_CONTRACT,
            params,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbOnSuccess,
            this.cbFailure,
            true
        );

    }
    cbOnSuccess = (response) => {

        this.setState({
            pendingContract: Utils.isEmpty(response) ? {} : response
        });
        this.props.cbShowLoader(false);

        response.contract.lunch_break == "yes" ? this.setState({ label_lunch: "Lunch Taken" }) :
            this.setState({ label_lunch: "Reason for missed lunch" })

        response.location == null ? this.setState({ label_signature: "Signature Not Verified" }) :
            this.setState({ label_signature: "Signature Verified" })

        response.contract.is_location_matched == null ? this.setState({ label_location: "Location Not Matched" }) :
           
        response.contract.is_location_matched == "no" ? this.setState({ label_location: "Location Not Matched" }) :
            this.setState({ label_location: "Location Matched" })

            
    }


    infoRDelete = modal => {
        this.showModal(modal);

    };

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { contractor_id } = this.props.route.params.data;

        this.setState({ isFetching: true });
        this.props.generalAction(
            API_GET_CONTRACTOR,
            {
                user_id: contractor_id
            },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            data => {
                this.setState({
                    isFetching: false,
                    contractor: data
                });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    onCompleteTask = contract_amount => {
        const { contract_id } = this.props.route.params.data;
        let payload = new FormData();
        payload.append("id", contract_id);
        payload.append("contract_amount", contract_amount);
        this.props.generalAction(
            API_CONTRACT_COMPLETE,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.onCompleteSuccessful,
            this.onCompleteFailure
        );
        this.props.cbShowLoader(true);
        this.hideModal();
    };

    onCompleteSuccessful = user => {
        const {
            contract_id,
            contractor_id,
            user_id
        } = this.props.route.params.data;
        pop();
        push("rating", {
            userType: "facility",
            contract_id,
            contractor_id,
            facility_id: user_id
        });
        this.props.cbShowLoader(false);
        Utils.showMessage(
            "Success",
            `Payment has been made successfully to ${this.props.user.data.full_name}, the contract has been marked as complete`,
            "success"
        );
    };

    onCompleteFailure = err => {
        this.props.cbShowLoader(false);
        Utils.showError(err);
    };

    rateContractor = () => {
        const { data } = this.props.route.params,
            { user } = this.props,
            { rating } = this.state;
        let payload = new FormData();
        payload.append("contractor_id", data.contractor_id);
        payload.append("contract_id", data.contract_id);
        payload.append("rate_value", rating);
        payload.append("facility_id", user.data.id);

        this.props.generalAction(
            API_RATE_CONTRACTOR,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            () => { },
            () => { }
        );
    };

    showModal = modal => {
        this.setState({ modal });
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.Modal.setModalVisible(false);
    };

    renderModal = () => {
        const { modal, maxRadius, rating } = this.state;
        const {
            cost_per_mile,
            full_name,
            image_url,
            contract_type,
            shift_end_time,
            shift_start_time,
            contract_id,
            contractor_id,
            user_id,
            total_hours
        } = this.props.route.params.data;

        let { totalDistance, totalAmount, rate } = this.calculateTotalAmount(
            this.props.route.params.data
        );
        let diffTime = this.calculateDiffTime(shift_end_time, shift_start_time);
        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={{ flex: 1, backgroundColor: "rgba(0,0,0,0.5)", alignItems: 'center', justifyContent: 'center' }}>
                        {modal == "complete" && (
                            <DeleteModal
                                deleteContract={() =>
                                    this.onCompleteTask(totalAmount)
                                }
                                hideModal={this.hideModal}
                                text1={"Are you sure you want to mark"}
                                text2={`The ${contract_type} Complete?`}
                            />
                        )}
                        {modal == "info" && (
                            <InfoModal
                                costMile={cost_per_mile}
                                maxRadius={totalDistance}
                            />
                        )}
                        {modal == "allInfo" && (
                            <AllInfo note={this.props.note} />
                        )}
                        {modal == "mileage" && (
                            <InfoMileage
                                rate={rate}
                                contract_type={contract_type}
                                diffTime={total_hours}
                            />
                        )}
                        {modal == "reject" &&
                            this.rejectModel()
                        }
                        {/* </View> */}
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };

    rejectModel = () => {
        return (
            <View style={{ flex: 1, alignItems: 'center', justifyContent: 'center' }}>
                <TouchableOpacity onPress={() => this.hideModal()} style={{ width: 50, height: 50, margin: 16, position: 'absolute', top: 0, left: 0 }}>
                    <Image source={icons.ic_cross} style={{ tintColor: '#fff' }} />
                </TouchableOpacity>
                <View style={{
                    padding: 16,
                    width: Metrics.screenWidth - 40,
                    backgroundColor: "#fff", alignItems: 'center', borderRadius: 8
                }}>
                    <TextLabel
                        style={{
                            color: colors.BlackColor,
                            fontSize: 16,
                            fontWeight: 'bold',
                            textAlign: 'center'
                        }}>
                        {'Please enter the reason to reject the request'}
                    </TextLabel>
                    <TextInput
                        style={styles.inputStyle}
                        placeholder={'Type here...'}
                        value={this.state.reason}
                        onChangeText={text => this.setState({ reason: text })}
                        multiline={true}
                    />

                </View>
                <AppButton
                    buttonTitle="SUBMIT"
                    style={{ backgroundColor: colors.ActiveTabTitle, width: Metrics.screenWidth, position: "absolute", bottom: 0 }}
                    btnColor={'#fff'}
                    onPress={() => this._apiForRejectAndApprove()}
                />
            </View>
        );
    }

    _apiForRejectAndApprove = (type = 'rejected') => {
        const { contract_id, contractor_id } = this.props.route.params.data;
        const { reason, pendingContract } = this.state;
        this.props.cbShowLoader(true);


        let payload = new FormData();
        payload.append('contract_id', contract_id);
        payload.append('id', pendingContract.id);
        payload.append('action_status', type);
        payload.append('rejected_reason', reason);

        this.props.generalAction(
            API_UPDATE_ONBOARD_CONTRACT,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            (response, message) => {
                this.props.cbShowLoader(false);
                this.hideModal();

                Utils.showMessage("Success", message, "success");

                pop();

                if (type !== 'rejected') {
                    const {
                        contract_id,
                        contractor_id,
                        user_id
                    } = this.props.route.params.data;
                    push("rating", {
                        userType: "facility",
                        contract_id,
                        contractor_id,
                        facility_id: user_id
                    });
                }
            },
            this.cbFailure
        );

    }
    cbSuccess = (response, message) => {
        this.props.cbShowLoader(false);
        this.hideModal();
        Utils.showMessage("Success", message, "success");

        const {
            contract_id,
            contractor_id,
            user_id
        } = this.props.route.params.data;
        pop();

        push("rating", {
            userType: "facility",
            contract_id,
            contractor_id,
            facility_id: user_id
        });
        // setTimeout(() => {
        //     pop(2)
        // }, 300);
    }
    cbFailure = (error) => {

        this.props.cbShowLoader(false);
        Utils.showError(error);
    }
    heading(label) {
        return (
            <TextLabel
                type="medium"
                size="medium"
                color={"black"}
                style={styles.boldText}
            >
                {label}
            </TextLabel>
        );
    }

    footer() {
        return (
            <FooterDetail
                style={{ position: "absolute", bottom: 0 }}
                text={"MARK AS COMPLETE"}
                backgroundColor={{ backgroundColor: "#08548c" }}
                textColor={{ color: "#ffffff" }}
                img={icons.ic_completed}
                clickBtn={() => this.showModal("complete")}
            />
        );
    }
    _acceptRejectBtn = () => {
        const { data } = this.props.route.params;
        const { contract_status, contract_type } = data;
        const { contractor } = this.state;
        return (
            <View style={{ width: Metrics.screenWidth, height: 60, marginTop: 8, flexDirection: "row" }}>
                <ButtonView
                    style={styles.btn}
                    onPress={() => this.showModal("reject")}
                >
                    <Text style={{ color: '#08548c' }}>{'Reject'}</Text>
                </ButtonView>
                <ButtonView
                    style={[styles.btn, { backgroundColor: "#08548c" }]}
                    onPress={() => this._apiForRejectAndApprove('approved')}
                >
                    <Text style={{ color: Colors.white, }}>{'Approve'}</Text>
                </ButtonView>
            </View>
        );
    }

    paragraph(para, style, numberOfLines) {
        return (
            <Text style={style} numberOfLines={numberOfLines}>
                {para}
            </Text>
        );
    }

    renderMap = (latitude, longitude) => {
        const baseUrl = "https://maps.googleapis.com/maps/api/staticmap";
        const markerCenter = `center=${latitude},${longitude}`;
        const API_KEY = `key=${API_KEY_GOOGLE}`;
        const zoomLevel = "zoom=16";
        const imageSize = `size=400x400`;
        const customMarkerIcon = `markers=icon:https://assets.mapquestapi.com/icon/v2/circle.png%7Clabel:C%7C${latitude},${longitude}`;
        const mapImageUrl = `${baseUrl}?${markerCenter}&${zoomLevel}&${imageSize}&${API_KEY}&${customMarkerIcon}`;
        return (
            <View style={styles.mapStyle}>
                <Image
                    source={{ uri: mapImageUrl }}
                    style={{ width: Metrics.screenWidth, height: 200, borderRadius: 6 }}
                />
            </View>
        );
    };

    calculateDiffTime = (b, a) => {
        let dif = moment(b, "HH:mm:a").diff(moment(a, "HH:mm:a"));
        let diffTime = moment.duration(dif).hours();
        return +diffTime == 0 ? 1 : diffTime;
    };

    calculateTotalAmount(data) {

        let rate =
            data.hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0, data.contract_rate.indexOf("."))
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0,
                    data.hourly_pay_rate.indexOf(".")
                );
        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * data.total_hours;
         let totalAmount, totalDistance ;
            if (data.contract_invitations.length == 0){

                pop(2)

            }
            else{

                let dist = Utils.distance(
                    data.latitude,
                    data.longitude,
                    data.contract_invitations[0].invitation_latitude,
                    data.contract_invitations[0].invitation_longitude
                );

                if (
                    data.contract_invitations[0].bid_amount !== null &&
                    data.contract_invitations[0].bid_amount !== "0.00" &&
                    data.contract_invitations[0].bid_amount > 0
                ) {
                    rate =
                        data.contract_type === "Contract"
                            ? data.contract_invitations[0].bid_amount
                            : data.contract_invitations[0].bid_amount /
                            data.total_hours;
                    bidAmount = data.contract_invitations[0].bid_amount;
                }

                let totalDistance =
                dist > this.state.maxRadius ? this.state.maxRadius : dist;
            let totalAmount = data.cost_per_mile
                ? +bidAmount + +data.cost_per_mile * totalDistance
                : +bidAmount;

                return { totalAmount, totalDistance, rate };

            }
        
       return { totalAmount, totalDistance, rate };
       
    }

    _getRate = (value) => {
        const { data } = this.props.route.params;
        const { contract_invitations, contract_type, total_hours } = data;

        const { bid_amount } = contract_invitations[0];

        let rate = 0;
        if (contract_type === 'Contract') {
            rate = !Utils.isNull(bid_amount) && bid_amount !== '0.00' ? parseFloat(bid_amount) : parseFloat(value);
        } else {
            rate = !Utils.isNull(bid_amount) && bid_amount !== '0.00' ? parseFloat(bid_amount) / total_hours : parseFloat(value);
        }
        return rate;
    }

    render() {
        const { data } = this.props.route.params,
            { user } = this.props;
       let { totalAmount, totalDistance, } = this.calculateTotalAmount(data);
        const { contract_status, contract_type, contract_rate, hourly_pay_rate,
            is_mileage_paid, cost_per_mile, mileage_amount, hour_rate } = data;
        const { contractor, pendingContract } = this.state;

        return (
            <React.Fragment>
                <ScrollView style={{ backgroundColor: "#f8f8f8" }}>
                    <DetailCard
                        data={data}
                        user={user.data}
                        cbMileage={() =>
                            contract_type === "Contract"
                                ? null
                                : this.showModal("info")
                        }
                        cbTotal={() =>
                            contract_type === "Contract"
                                ? null
                                : this.showModal("mileage")
                        }
                    />
                    <Separator style={styles.separatorStyle} />
                    {this.heading("Description")}
                    {this.paragraph(
                        data.description,
                        styles.descriptionStyle,
                        2
                    )}
                    {/* <Separator style={styles.separatorStyle} /> */}
                    {/* <RequestsCard
                        request={"received"}
                        item={contractor}
                        bidAmount={totalAmount.toFixed(2)}
                        showSeperator={false}
                        goTo={() =>
                            push("contractorDetail", {
                                data: { user_id: data.contractor_id },
                                showFooter: false
                            })
                        }
                    /> */}
                    {Object.keys(pendingContract).length !== 0 &&
                        <View>
                            <InfoCard
                                item={contractor}
                                onPress={() => push("contractorDetail", {
                                    data: { user_id: data.contractor_id },
                                    showFooter: false
                                })}
                                rightText={contract_type === "Contract" ? true : false}
                                onRightTextPress={() => push('ContractSchedule', { data, contractor, pendingContract })}
                            />
                            <View style={{ marginHorizontal: 12, marginVertical: 8 }}>
                                {
                                    contract_type !== "Contract" && <View style={{ flexDirection: 'row' }}>
                                        <InfoRoundBox
                                            heading={'Start Time'}
                                            subHeading={pendingContract.shift_start_time}
                                            style={{ width: (Metrics.screenWidth / 2) - 20 }}
                                        />
                                        <InfoRoundBox
                                            heading={'End Time'}
                                            subHeading={pendingContract.shift_end_time}
                                            style={{ width: (Metrics.screenWidth / 2) - 20 }}
                                        />
                                    </View>
                                }
                                <View style={{ flexDirection: "row" }}>
                                    {
                                        contract_type === "Contract" &&
                                        <InfoRoundBox
                                            heading={'Total Shift Hours'}
                                            subHeading={parseFloat(pendingContract.total_hours).toFixed(2)}
                                            style={{ width: 90 }}
                                        />
                                    }
                                    {/* <InfoRoundBox
                                        heading={'Hour Rate'}
                                        subHeading={`$${contract_type === 'Contract' ? this._getRate(contract_rate) : this._getRate(hourly_pay_rate)}`}
                                        style={{ width: 90 }}

                                    /> */}

                                    <InfoRoundBox
                                        heading={'Hour Rate'}
                                        subHeading={`$${hour_rate}`}
                                      //  subHeading={`$${contract_type === 'Contract' ? hour_rate: this._getRate(hourly_pay_rate).toFixed(2)}`}
                                        style={{ width: 90 }}

                                    />

                                    {
                                        contract_type !== 'Contract' && (is_mileage_paid === 1 &&
                                            <InfoRoundBox
                                                heading={'Mileage Paid'}
                                                // subHeading={`$${+cost_per_mile * +totalDistance}`}
                                                subHeading={`$${mileage_amount}`}
                                                style={{ width: 90 }}
                                            />
                                        )
                                    }

                                    <InfoRoundBox
                                        heading={`Total ${is_mileage_paid === 1 ? '(Mileage + Shift Hours)' : ''}`}
                                        subHeading={`$${(pendingContract.total_amount)}`}
                                        style={{ width: 140, borderColor: '#d93636' }}
                                    />

                                </View>
                            </View>

                            <View style={{ flexDirection: "row", marginStart: 10 }}>

                                <CardStatus
                                    label={this.state.label_location}
                                    style={{
                                        backgroundColor: pendingContract.contract.is_location_matched == null ?'#c95454':
                                        pendingContract.contract.is_location_matched == "no"? "#c95454" : "#33be57",
                                        width: 100,
                                        margin: 5,
                                        fontSize: 5,
                                        padding: 5
                                    }}
                                />

                                <CardStatus
                                    label={this.state.label_signature}
                                    style={{
                                        backgroundColor: pendingContract.location == null ? "#c95454" : "#33be57",
                                        width: 100,
                                        margin: 5,
                                        padding: 5,
                                        ...UIFont.font(fonts.regular, fontSize.small),
                                    }}
                                />

                                {pendingContract.contract.lunch_break != null ?
                                    <CardStatus
                                        label={this.state.label_lunch}
                                        style={{
                                            backgroundColor: pendingContract.contract.lunch_break == "no" ?
                                                "#c95454" : "#33be57",
                                            width: 100,
                                            margin: 5,
                                            fontSize: 5,
                                            padding: 5,
                                            textAlign: "center",
                                            ...UIFont.font(fonts.regular, fontSize.small, "red"),
                                        }}
                                    />
                                    : null}

                            </View>


                            {pendingContract.contract.lunch_break == "no" ?
                                <View>
                                    {this.heading("Reason")}
                                    {this.paragraph(
                                        pendingContract.contract.lunch_break_reason,
                                        styles.descriptionStyle,
                                        2
                                    )}
                                </View>
                                : null}

                            {
                                contract_status == "active" && this._acceptRejectBtn()
                            }
                        </View>

                    }

                    <Separator style={styles.separatorStyle} />
                    {this.paragraph(data.location_address, styles.locationStyle, 1)}
                    {this.renderMap(data.latitude, data.longitude)}
                </ScrollView>
                {/* {contract_status == "active" && this.footer()} */}
                {this.renderModal()}

                <Supporticon
                    clickBtn={() => push("Support")} />
            </React.Fragment>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ user, infoContent }, ownProps) => {
    return {
        data: selectPostDetails(ownProps),
        user,
        note: infoContent.data.content
    };
};

const DetailComponentCompose = compose(
    connect(mapStateToProps, actions)(WithFetching(OnboardProjectsDetail))
);

export default DetailComponentCompose;

DetailComponentCompose.navigationOptions = ({ navigation }) => {
    const { state } = navigation;
    const params = state.params || {};
    return {
        headerStyle: styles.header,
        headerRight: (
            <View style={{ flexDirection: "row" }}>
                {params.boo && (
                    <TouchableOpacity
                        onPress={() =>
                            params.infoRDelete && params.infoRDelete("allInfo")
                        }
                    >
                        <Image
                            style={{ margin: 10 }}
                            resizeMode="contain"
                            source={icons.ic_info}
                        />
                    </TouchableOpacity>
                )}
            </View>
        )
    };
};