import React, { Component } from "react";
import { View, Text, Image,TouchableOpacity } from "react-native";
import { WithFetching } from "../../HOC";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { connect } from "react-redux";
//import { TouchableOpacity } from "react-native-gesture-handler";
import { Images, icons, UIFont, fontSize, fonts, colors } from "../../assets";
import { Container, TextLabel } from "../../components";
import { Metrics } from "../../theme";
import { push } from "../../services/NavigationService";

class SelectAccountType extends Component {
    _renderBtn = (title, onPress) => {
        return (
            <TouchableOpacity onPress={onPress}
            >
                <View style={{
                    flexDirection: 'row', justifyContent: 'space-between', width: Metrics.screenWidth,
                    height: 60, alignItems: 'center', backgroundColor: '#fff', padding: 8, paddingHorizontal: 16
                }}>
                    <TextLabel style={{ fontWeight: 'bold', fontSize: 16, color: '#000' }}>{title}</TextLabel>
                    <Image source={icons.expand_farward} />

                </View>
            </TouchableOpacity>
        )
    }
    render() {
        return (
            <Container>

                {this._renderBtn('Bank Account',() =>push('BankAccountDetails'))}
                {this._renderBtn('Debit Card', () => push('DebitCardDetails'))}

            </Container>
        );
    }
}
const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ user, networkInfo }) => {
    return { user: user.data, networkInfo };
};

export default connect(
    mapStateToProps,
    actions
)(WithFetching(SelectAccountType));
