import React, { Component, Fragment } from "react";
import { StyleSheet, View, Text, Keyboard } from "react-native";
import { CardField } from "@stripe/stripe-react-native";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { connect } from "react-redux";
import {
    FooterDetail,
    FormHandler,
    Input,
    StripeCardDetails, Supporticon
} from "../../components";
import { colors } from "../../assets";
import Stripe from "../../services/Stripe";
import { WithFetching } from "../../HOC";
import Utils from "../../Utils";
import { API_ADD_ACCOUNT_INFO } from "../../services/WebService";
import { USER } from "../../actions/ActionTypes";
import { pop,push } from "../../services/NavigationService";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";
// import BankAccountDetails from "./BankAccountDetails";
import SelectAccountType from "./SelectAccountType";

class PaymentMethod extends Component {
    constructor(props) {
        super(props);
        this.state = {
            cardParams: {
                type: 'Card',
                billingDetails: {
                    number: "",
                    expMonth: "",
                    expYear: "",
                    type: ""
                },
               
                // cvc: ""
            },
            cardError: "Please give correct card details",
            isError: false
        };
    }
    handleFieldParamsChange = (cardDetails) => {

        if (cardDetails.validCVC == 'Valid' & cardDetails.validExpiryDate == 'Valid' & cardDetails.validNumber == 'Valid') {

            this.setState({
                cardParams: {
                    type: 'Card',
                    billingDetails: {
                    number: cardDetails.last4,
                    expMonth: cardDetails.expiryMonth,
                    expYear: cardDetails.expiryYear,
                    }
                }
            });

        }
        else {


        }

    };

    isPaymentCardTextFieldFocused = () => this.paymentCardInput.isFocused();

    focusPaymentCardTextField = () => this.paymentCardInput.focus();

    blurPaymentCardTextField = () => this.paymentCardInput.blur();

    resetPaymentCardTextField = () => this.paymentCardInput.setParams({});

    footer() {
        return (
            <FooterDetail
                style={{
                    position: "absolute",
                    bottom: 10,
                    marginHorizontal: 10
                }}
                text={"Submit"}
                backgroundColor={{ backgroundColor: "#08548c" }}
                textColor={{ color: "#ffffff" }}
                clickBtn={this.submitDetails}
            />
        );
    }

    submitDetails = () => {
        const { user, cbShowLoader } = this.props,
            { cardParams } = this.state;

        if (user.user_type == "Facility") {
            if (cardParams.number !== "") {
                cbShowLoader(true);
                Stripe.getStripeTokenFromCard(
                    cardParams,
                    response => this.makingPayload(response.id, user.id),
                    this.onAccountTokenFailure
                );
            } else {
                this.setState({ isError: true });
            }
        } else {
            if (!this.accountInfo.getValue().length) {
                this.accountInfo.setError(true);
            }
            if (!this.routingNumber.getValue().length) {
                this.routingNumber.setError(true);
            } else {
                // let params = {
                //     accountNumber: this.accountInfo.getValue(),
                //     routingNumber: this.routingNumber.getValue(),
                //     countryCode: "us",
                //     currency: "usd"
                // };


                let params = {
                    accountNumber: this.accountInfo.getValue(),
                    routingNumber: this.routingNumber.getValue(),
                    country: 'US',
                    type: 'BankAccount',
                    currency: 'usd',
                };
                Stripe.getStripTokenFromAccount(
                    params,
                    response => this.makingPayload(response.id, this.props.user.id),
                    this.onAccountTokenFailure
                );
            }
        }
    };

    makingPayload = (stripe_key, user_id) => {
        let payload = new FormData();
        payload.append("user_id", user_id);
        payload.append("stripe_key", stripe_key);
        payload.append("info_type", 'null');

        this.onAccountTokenSuccess(payload);
    };

    onAccountTokenSuccess = payload => {
        this.props.generalAction(
            API_ADD_ACCOUNT_INFO,
            payload,
            USER.SUCCESS,
            USER.FAILURE,
            user => {
                this.props.cbShowLoader(false);
                Utils.showMessage(
                    "Success",
                    "Account details submitted successfully",
                    "success"
                );
                pop();
            },
            err => {
                Utils.showError(err);
                this.props.cbShowLoader(false);
            }
        );
    };

    onAccountTokenFailure = err => {
        this.props.cbShowLoader(false);
        setTimeout(() => {
            Utils.showMessage(
                "Error",
                "Unable to verify account. Check account details."
            );
        }, 1000);
    };

    renderError(err, obj) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    render() {
        const { user } = this.props,
            { cardParams, cardError } = this.state;
        return (
            <View style={styles.container}>
                {user.user_type == "Facility" ? (
                    <Fragment>
                        <CardField
                            ref={ref => {
                                this.paymentCardInput = ref;
                            }}
                            cursorColor="gray"
                            postalCodeEnabled={false}
                            textErrorColor="red"
                            placeholderColor="blue"
                            placeholder={{
                                number: '4242 4242 4242 4242',


                            }}
                            cardStyle={{
                                borderWidth: 1,
                                backgroundColor: '#FFFFFF',
                                borderColor: '#000000',
                                borderRadius: 8,
                                fontSize: 14,
                                placeholderColor: '#999999',
                            }}
                            style={{
                                width: '100%',
                                height: 50,
                                marginVertical: 30,
                            }}
                            disabled={false}
                            onCardChange={this.handleFieldParamsChange}
                        />
                        {cardParams.number == ""
                            ? this.renderError(cardError, {})
                            : null}
                        {this.footer()}
                    </Fragment>
                ) : (
                    
                    <SelectAccountType />
                )}

                <Supporticon style={{ bottom: 60 }}
                    clickBtn={() => push("Support")} />
            </View>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ user, networkInfo }) => {
    return { user: user.data, networkInfo };
};

export default connect(mapStateToProps, actions)(WithFetching(PaymentMethod));

const styles = StyleSheet.create({
    container: {
        flex: 1,
        alignItems: "center",
        paddingTop: 10,
        backgroundColor: colors.HeaderColor
    },
    field: {
        width: 350,
        color: "#449aeb",
        borderColor: "#000",
        borderWidth: 1,
        borderRadius: 5
    },
    emailAddressTextField: {
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
        borderColor: Colors.textfieldBorder,
        borderBottomWidth: 1
    }
});
