import { StyleSheet } from "react-native";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";
import { Images, icons, UIFont, fontSize, fonts, colors } from "../../assets";

export default StyleSheet.create({
    container: {
        flex:1,
        padding:16
    },
    labelStyle: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor)
    },
    inputWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.4,
        shadowRadius: 2,
        shadowOffset: {
            height: 2,
            width: 2
        },
        paddingVertical: 10,
        marginBottom: 20
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    txtInputStyle: {
        minHeight: 50,
        fontSize: 20,
        color: "#000",
        borderRadius: 10,
        paddingLeft: 15,
        paddingBottom: 5,
        marginBottom: 10,
        paddingRight: 15,
        marginHorizontal: 10,
        alignSelf: "stretch",
        flex: 1,
        borderColor: "#dddddd",
        borderBottomWidth: 1
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6,
        marginHorizontal: 10
    },
    categoryStyle: {
        // width: "90%",
        flexDirection: "row",
        height: 60,
        alignItems: "center"
    },
    seperatorStyle: {
        backgroundColor: "#dddddd",
        width: "90%",
        alignSelf: "center",
        marginBottom: 10
    },
    actionSheetView: {
        justifyContent: "space-between",
    },
    zeroIndexCategoryStyle: {
        ...UIFont.font(fonts.reqular, 15, Colors.textfieldBorder),
        letterSpacing: 0
    },
    textCategoryStyle: {
        ...UIFont.font(fonts.reqular, 15, "#040404"),
        letterSpacing: 0
    },
    imageIcon: {
        marginTop: Metrics.baseMargin,
        marginRight: Metrics.baseMargin
    },

    imageIcon: {
        marginTop: Metrics.baseMargin,
        marginRight: Metrics.baseMargin
    },
    passwordContainer: {
        flexDirection: 'row',
        borderBottomWidth: 1,
        borderColor: Colors.textfieldBorder,
        paddingBottom: 10,
    },
    inputStyle: {
        flex: 1,
        color:colors.BlackColor,
    },
    viewstyle: {
        flex: 1,
        flexDirection: "row",
        marginStart:15,
        marginEnd:15,
        marginTop:10,
        alignItems: "center",

    },
    ImageStyle: {
        padding: 10,
        margin: 5,
        height: 30,
        width: 30,
        resizeMode: 'stretch',
        alignItems: 'center',
    },
});
