const getPostShiftPayload = obj => {
    const {
        contract_type,
        description,
        hourly_pay_rate,
        shift_start_date,
        shift_end_date,
        shift_start_time,
        shift_end_time,
        user_id,
        category_id,
        isOn,
        address,
        maximum_radius,
        cost_per_mile,
        latitude,
        longitude,
        contract_status,
        total_hours,
        iscovid
    } = obj;

    const payload = new FormData();
    payload.append("contract_type", contract_type);
    payload.append("description", description);
    payload.append("hourly_pay_rate", hourly_pay_rate);
    payload.append("shift_start_date", shift_start_date);
    payload.append("shift_end_date", shift_end_date);
    payload.append("shift_start_time", shift_start_time);
    payload.append("shift_end_time", shift_end_time);
    payload.append("user_id", user_id);
    payload.append("category_id", category_id);
    payload.append("is_mileage_paid", isOn ? 1 : 0);
    isOn && payload.append("maximum_radius", maximum_radius);
    isOn && payload.append("cost_per_mile", cost_per_mile);
    payload.append("latitude", latitude);
    payload.append("longitude", longitude);
    payload.append("contract_status", contract_status);
    payload.append("location_address", address);
    payload.append("total_hours", total_hours);
    payload.append("iscovid", iscovid);

    return payload;
};

const getPostContractPayload = obj => {
    const {
        contract_type,
        description,
        hourly_pay_rate,
        shift_start_date,
        shift_end_date,
        shift_start_time,
        shift_end_time,
        user_id,
        category_id,
        project_validity,
        latitude,
        longitude,
        address,
        contract_status,
        total_hours,
        shift_hours,
        iscovid
    } = obj;

    const payload = new FormData();
    payload.append("contract_type", contract_type);
    payload.append("description", description);
    payload.append("contract_rate", hourly_pay_rate);
    payload.append("shift_start_date", shift_start_date);
    payload.append("shift_end_date", shift_end_date);
    payload.append("shift_start_time", shift_start_time);
    payload.append("shift_end_time", shift_end_time);
    payload.append("user_id", user_id);
    payload.append("category_id", category_id);
    payload.append("project_validity", project_validity);
    payload.append("latitude", latitude);
    payload.append("longitude", longitude);
    payload.append("contract_status", contract_status);
    payload.append("location_address", address);
    payload.append("total_hours", total_hours);
    payload.append("shift_hours", shift_hours);
    payload.append("iscovid", iscovid);

    return payload;
};

export { getPostShiftPayload, getPostContractPayload };
